<?php

namespace HeacoolAddons\Widgets;

if (!defined('ABSPATH')) {
    exit;
}

use Elementor\Widget_Base;

class Protection_Packages extends Widget_Base {

    public function get_name() {
        return 'elec_protection_packages';
    }

    public function get_title() {
        return __('Protection Plans', 'heacool-core');
    }

    public function get_icon() {
        return 'eicon-banner';
    }

    public function get_categories() {
        return ['heacool'];
    }

    /**
     * Retrieve the list of scripts the widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    public function get_script_depends() {
        return ['pricing-packages'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
                'content_section', [
            'label' => __('Content', 'heacool-core'),
                ]
        );

        $this->add_control(
                'title_1', [
            'label' => __('Title 1', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('Choose a plan that’s right', 'heacool-core'),
            'placeholder' => __('Type your title here', 'heacool-core')
                ]
        );

        $this->add_control(
                'title_2', [
            'label' => __('Title 2', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('Protection Plans', 'heacool-core'),
            'placeholder' => __('Type your title here', 'heacool-core')
                ]
        );

        $repeater = new \Elementor\Repeater();
        
        $repeater->add_control(
            'is_active',
            [
                'label' => __( 'Is Active', 'heacool-core' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'heacool-core' ),
                'label_off' => __( 'No', 'heacool-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $repeater->add_control(
                'badge_text', [
            'label' => __('Badge Text', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
                ]
        );

        $repeater->add_control(
                'title_1', [
            'label' => __('Title', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'placeholder' => __('Type your title here', 'heacool-core'),
                ]
        );
        $repeater->add_control(
                'price', [
            'label' => __('Price', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT
                ]
        );

        $repeater->add_control(
                'duration', [
            'label' => __('Duration', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __(' <span>per month</span>', 'heacool-core'),
                ]
        );
        $repeater->add_control(
                'content', [
            'label' => __('Include', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
                ]
        );

        $repeater->add_control(
                'button_text', [
            'label' => __('Button Text', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('Request Plan', 'heacool-core'),
                ]
        );

        $repeater->add_control(
                'button_url', [
            'label' => __('Button URL', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::URL,
            'default' => [
                'url' => '#',
                'is_external' => '',
            ],
            'show_external' => true,
                ]
        );

        $this->add_control(
                'item_list', [
            'label' => __('Item List', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'title_1' => __('Cooling Maintenance', 'heacool-core'),
                    'price' => __('<sup>$</sup>11.99 ', 'heacool-core'),
                    'content' => __('<li>Annual cooling system check-up</li>
                                        <li>No age restrictions</li>
                                        <li>15% off any repair services</li>', 'heacool-core')
                ],
                [
                    'title_1' => __('Cooling Maintenance', 'heacool-core'),
                    'price' => __('<sup>$</sup>11.99 ', 'heacool-core'),
                    'content' => __('<li>Annual cooling system check-up</li>
                                        <li>No age restrictions</li>
                                        <li>15% off any repair services</li>', 'heacool-core')
                ],
                [
                    'title_1' => __('Cooling Maintenance', 'heacool-core'),
                    'price' => __('<sup>$</sup>11.99 ', 'heacool-core'),
                    'content' => __('<li>Annual cooling system check-up</li>
                                        <li>No age restrictions</li>
                                        <li>15% off any repair services</li>', 'heacool-core')
                ],
            ]
                ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
        <section class="block">
            <div class="container">
                <div class="sec-title">
                    <h4> <?php
                        echo wp_kses_post($settings['title_1']);
                        ?></h4>
                    <h2> <?php
                        echo wp_kses_post($settings['title_2']);
                        ?></h2>
                </div><!--sec-title end-->
                <div class="price-table-sec">
                    <div class="row">
                        <?php
                        if (!empty($settings['item_list'])) {
                            foreach ($settings['item_list'] as $key => $item) {
                                $url = '#';
                                $target = '';
                                if (!empty($item['button_url'])) {
                                    $link = $item['button_url'];
                                    $url = $link['url'];
                                    $target = $link['is_external'] ? 'target="_blank"' : '';
                                }
                                $is_active = '';
                                if ($item['is_active']== 'yes') {
                                    $is_active = 'active';
                                }
                                ?>
                                <div class="col-lg-4 col-md-4 col-sm-6">
                                    <div class="price-table <?php echo esc_attr($is_active);?>">
                                        <h3>
                                            <?php
                                            echo wp_kses_post($item['title_1']);
                                            ?>
                                        </h3>
                                        <h2>  <?php
                                            echo wp_kses_post($item['price']);
                                            ?>
                                        </h2>
                                        <?php
                                        echo wp_kses_post($item['duration']);
                                        ?>
                                        <ul>
                                            <?php
                                            echo wp_kses_post($item['content']);
                                            ?>
                                        </ul>
                                        <?php if (!empty($item['button_text'])) { ?>
                                            <a href="<?php echo esc_url($url); ?>" <?php echo esc_url($target); ?> class="apt_form_btn"> <?php
                                                echo wp_kses_post($item['button_text']);
                                                ?></a>
                                            <?php
                                        }
                                        if (!empty($item['badge_text'])) {
                                            ?>
                                            <h5 class="pc-text"> 
                                                <?php
                                                echo wp_kses_post($item['badge_text']);
                                                ?>
                                            </h5>
                                        <?php }
                                        ?>
                                    </div><!--price-table end-->
                                </div>
                                <?php
                            }
                        }
                        ?>
                    </div>
                </div><!--price-table-sec end-->
            </div>
        </section>
        <?php
    }

}
