<?php

namespace HeacoolAddons\Widgets;

if (!defined('ABSPATH')) {
    exit;
}

use Elementor\Widget_Base;

class Protection_Packages_Tab extends Widget_Base {

    public function get_name() {
        return 'elec_protection_packages_tab';
    }

    public function get_title() {
        return __('Protection Plans Tab', 'heacool-core');
    }

    public function get_icon() {
        return 'eicon-banner';
    }

    public function get_categories() {
        return ['heacool'];
    }

   
    protected function _register_controls() {

        $this->start_controls_section(
                'content_section', [
            'label' => __('First Tab', 'heacool-core'),
                ]
        );

        $this->add_control(
                'tab_title', [
            'label' => __('Tab Title', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => 'Cooling Services',
            'placeholder' => __('Type your title here', 'heacool-core'),
                ]
        );
        $this->add_control(
            'limage', [
            'label' => __('Left service Icon', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::MEDIA,
            
                ]
        );


        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'is_active',
            [
                'label' => __( 'Is Active', 'heacool-core' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'heacool-core' ),
                'label_off' => __( 'No', 'heacool-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $repeater->add_control(
                'choice_plan', [
            'label' => __('Choice Plan', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => '',
                ]
        );
        
        $repeater->add_control(
                'title_1', [
            'label' => __('Title', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'placeholder' => __('Type your title here', 'heacool-core'),
                ]
        );
        $repeater->add_control(
                'price', [
            'label' => __('Price', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT
                ]
        );

        $repeater->add_control(
                'duration', [
            'label' => __('Duration', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __(' <span>per month</span>', 'heacool-core'),
                ]
        );
        $repeater->add_control(
                'content', [
            'label' => __('Include', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
                ]
        );

        $repeater->add_control(
                'button_text', [
            'label' => __('Button Text', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('Request Plan', 'heacool-core'),
                ]
        );

        $repeater->add_control(
                'button_url', [
            'label' => __('Button URL', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::URL,
            'default' => [
                'url' => '#',
                'is_external' => '',
            ],
            'show_external' => true,
                ]
        );

        $this->add_control(
                'item_list', [
            'label' => __('Item List', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'title_1' => __('Cooling Maintenance', 'heacool-core'),
                    'price' => __('<sup>$</sup>11.99 ', 'heacool-core'),
                    'content' => __('<li>Annual cooling system check-up</li>
                                        <li>No age restrictions</li>
                                        <li>15% off any repair services</li>', 'heacool-core')
                ],
                [
                    'title_1' => __('Cooling Maintenance', 'heacool-core'),
                    'price' => __('<sup>$</sup>11.99 ', 'heacool-core'),
                    'content' => __('<li>Annual cooling system check-up</li>
                                        <li>No age restrictions</li>
                                        <li>15% off any repair services</li>', 'heacool-core')
                ],
                [
                    'title_1' => __('Cooling Maintenance', 'heacool-core'),
                    'price' => __('<sup>$</sup>11.99 ', 'heacool-core'),
                    'content' => __('<li>Annual cooling system check-up</li>
                                        <li>No age restrictions</li>
                                        <li>15% off any repair services</li>', 'heacool-core')
                ],
            ]
                ]
        );
        $this->end_controls_section();


        $this->start_controls_section(
                'content_section_1', [
            'label' => __('Second Tab', 'heacool-core'),
                ]
        );

        $this->add_control(
                'tab_title_1', [
            'label' => __('Tab Title', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => 'Cooling Services',
            'placeholder' => __('Type your title here', 'heacool-core'),
                ]
        );
        $this->add_control(
            'rimage', [
            'label' => __('Right service Icon', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::MEDIA,
                ]
        );


        $repeater_1 = new \Elementor\Repeater();

        $repeater_1->add_control(
            'is_active',
            [
                'label' => __( 'Is Active', 'heacool-core' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'heacool-core' ),
                'label_off' => __( 'No', 'heacool-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $repeater_1->add_control(
                'choice_plan', [
            'label' => __('Choice Plan', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => '',
                ]
        );
        $repeater_1->add_control(
                'title_1', [
            'label' => __('Title', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'placeholder' => __('Type your title here', 'heacool-core'),
                ]
        );
        $repeater_1->add_control(
                'price', [
            'label' => __('Price', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT
                ]
        );

        $repeater_1->add_control(
                'duration', [
            'label' => __('Duration', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __(' <span>per month</span>', 'heacool-core'),
                ]
        );
        $repeater_1->add_control(
                'content', [
            'label' => __('Include', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
                ]
        );

        $repeater_1->add_control(
                'button_text', [
            'label' => __('Button Text', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('Request Plan', 'heacool-core'),
                ]
        );

        $repeater_1->add_control(
                'button_url', [
            'label' => __('Button URL', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::URL,
            'default' => [
                'url' => '#',
                'is_external' => '',
            ],
            'show_external' => true,
                ]
        );

        $this->add_control(
                'item_list_1', [
            'label' => __('Item List', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater_1->get_controls(),
            'default' => [
                [
                    'title_1' => __('Cooling Maintenance', 'heacool-core'),
                    'price' => __('<sup>$</sup>11.99 ', 'heacool-core'),
                    'content' => __('<li>Annual cooling system check-up</li>
                                        <li>No age restrictions</li>
                                        <li>15% off any repair services</li>', 'heacool-core')
                ],
                [
                    'title_1' => __('Cooling Maintenance', 'heacool-core'),
                    'price' => __('<sup>$</sup>11.99 ', 'heacool-core'),
                    'content' => __('<li>Annual cooling system check-up</li>
                                        <li>No age restrictions</li>
                                        <li>15% off any repair services</li>', 'heacool-core')
                ],
                [
                    'title_1' => __('Cooling Maintenance', 'heacool-core'),
                    'price' => __('<sup>$</sup>11.99 ', 'heacool-core'),
                    'content' => __('<li>Annual cooling system check-up</li>
                                        <li>No age restrictions</li>
                                        <li>15% off any repair services</li>', 'heacool-core')
                ],
            ]
                ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
        <ul class="tbss-list">
            <li class="active" data-tab="price_cool">
                <span class="vx-icon">
                <?php
                if (!empty($settings['limage']['url'])){
                    echo '<img src="' . $settings['limage']['url'] . '">';
                }else{ 
                ?>
                    <svg version="1.1" id="Capa_179" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                         viewBox="0 0 333.316 333.316" xml:space="preserve">
                        <path d="M315.797,224.574l-5.557-20.818l-39.684,10.592l-33.572-19.441l41.764-18.377v-19.75l-41.767-18.377l33.572-19.439
                              l39.689,10.59l5.557-20.818l-18.861-5.025l19.361-11.197l-10.82-18.645l-19.324,11.188l5.029-18.855l-20.818-5.551l-10.588,39.674
                              l-33.473,19.338l4.918-45.148l-17.061-9.877l-36.758,26.892V52.824l29.045-29.018L191.221,8.539l-13.816,13.807V0h-21.531v22.346
                              L142.064,8.539l-15.236,15.268l29.045,29.018v38.703l-36.756-26.892l-17.061,9.877l4.924,45.148l-33.477-19.336l-10.59-39.676
                              l-20.816,5.553l5.027,18.854l-19.32-11.188L17.018,92.512l19.322,11.197l-18.857,5.025l5.557,20.818l39.684-10.59l33.576,19.439
                              l-41.771,18.377v19.75l41.768,18.377l-33.576,19.441l-39.678-10.592l-5.557,20.818l18.853,5.025l-19.32,11.195l10.787,18.652
                              l19.318-11.18l-5.029,18.84l20.818,5.559l10.59-39.682l33.479-19.338l-4.924,45.15l17.061,9.879l36.756-26.893V280.5l-29.045,29.004
                              l15.236,15.266l13.809-13.805v22.352h21.531v-22.352l13.816,13.805l15.229-15.266L177.404,280.5v-38.717l36.758,26.893l17.061-9.879
                              l-4.92-45.15l33.475,19.338l10.59,39.682l20.818-5.559l-5.029-18.838l19.322,11.178l10.82-18.652l-19.361-11.193L315.797,224.574z
                              M247.668,166.654l-33.779,14.885l-25.75-14.887l25.746-14.877L247.668,166.654z M207.148,96.471l-3.975,36.578l-25.77,14.93
                              v-29.721L207.148,96.471z M126.129,96.471l29.744,21.787v29.721l-25.771-14.93L126.129,96.471z M85.609,166.654l33.783-14.879
                              l25.748,14.877l-25.752,14.887L85.609,166.654z M126.129,236.84l3.973-36.582l25.771-14.924v29.717L126.129,236.84z M207.148,236.84
                              l-29.744-21.789v-29.717l25.77,14.924L207.148,236.84z"/>
                        <g>
                        </g>
                    </svg>
                    <?php } ?>
                </span>
                <?php
                echo wp_kses_post($settings['tab_title']);
                ?>
            </li>
            <li data-tab="price_heating" class="heating">
                <span class="vx-icon">
                <?php
                if (!empty($settings['rimage']['url'])){
                    echo '<img src="' . $settings['rimage']['url'] . '">';
                }else{
                ?>
                    <svg version="1.1" id="Capa_18329" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                         width="45.16px" height="45.16px" viewBox="0 0 45.16 45.16" xml:space="preserve"
                         >
                        <g>
                            <g>
                                <path d="M22.58,11.269c-6.237,0-11.311,5.075-11.311,11.312s5.074,11.312,11.311,11.312c6.236,0,11.311-5.074,11.311-11.312
                                      S28.816,11.269,22.58,11.269z"/>
                                <g>
                                    <g>
                                        <path d="M22.58,7.944c-1.219,0-2.207-0.988-2.207-2.206V2.207C20.373,0.988,21.361,0,22.58,0c1.219,0,2.207,0.988,2.207,2.207
                                              v3.531C24.787,6.956,23.798,7.944,22.58,7.944z"/>
                                    </g>
                                    <g>
                                        <path d="M22.58,37.215c-1.219,0-2.207,0.988-2.207,2.207v3.53c0,1.22,0.988,2.208,2.207,2.208c1.219,0,2.207-0.988,2.207-2.208
                                              v-3.53C24.787,38.203,23.798,37.215,22.58,37.215z"/>
                                    </g>
                                    <g>
                                        <path d="M32.928,12.231c-0.861-0.862-0.861-2.259,0-3.121l2.497-2.497c0.861-0.861,2.259-0.861,3.121,0
                                              c0.862,0.862,0.862,2.26,0,3.121l-2.497,2.497C35.188,13.093,33.791,13.093,32.928,12.231z"/>
                                    </g>
                                    <g>
                                        <path d="M12.231,32.93c-0.862-0.863-2.259-0.863-3.121,0l-2.497,2.496c-0.861,0.861-0.862,2.26,0,3.121
                                              c0.862,0.861,2.26,0.861,3.121,0l2.497-2.498C13.093,35.188,13.093,33.79,12.231,32.93z"/>
                                    </g>
                                    <g>
                                        <path d="M37.215,22.58c0-1.219,0.988-2.207,2.207-2.207h3.531c1.219,0,2.207,0.988,2.207,2.207c0,1.219-0.988,2.206-2.207,2.206
                                              h-3.531C38.203,24.786,37.215,23.799,37.215,22.58z"/>
                                    </g>
                                    <g>
                                        <path d="M7.944,22.58c0-1.219-0.988-2.207-2.207-2.207h-3.53C0.988,20.373,0,21.361,0,22.58c0,1.219,0.988,2.206,2.207,2.206
                                              h3.531C6.956,24.786,7.944,23.799,7.944,22.58z"/>
                                    </g>
                                    <g>
                                        <path d="M32.928,32.93c0.862-0.861,2.26-0.861,3.121,0l2.497,2.497c0.862,0.86,0.862,2.259,0,3.12s-2.259,0.861-3.121,0
                                              l-2.497-2.497C32.066,35.188,32.066,33.791,32.928,32.93z"/>
                                    </g>
                                    <g>
                                        <path d="M12.231,12.231c0.862-0.862,0.862-2.259,0-3.121L9.734,6.614c-0.862-0.862-2.259-0.862-3.121,0
                                              c-0.862,0.861-0.862,2.259,0,3.12l2.497,2.497C9.972,13.094,11.369,13.094,12.231,12.231z"/>
                                    </g>
                                </g>
                            </g>
                        </g>
                    </svg>
                    <?php } ?>
                </span>
                <?php
                echo wp_kses_post($settings['tab_title_1']);
                ?>
            </li>
        </ul><!--tbs-list end-->
        <div class="tbb_content">
            <div class="tbb-details active" id="price_cool">
                <div class="price-table-sec">
                    <div class="row">
                        <?php
                        if (!empty($settings['item_list'])) {
                            foreach ($settings['item_list'] as $key => $item) {
                                $url = '#';
                                $target = '';
                                if (!empty($item['button_url'])) {
                                    $link = $item['button_url'];
                                    $url = $link['url'];
                                    $target = $link['is_external'] ? 'target="_blank"' : '';
                                }
                                $is_active = '';
                                if ($item['is_active']== 'yes') {
                                    $is_active = 'active';
                                }
                                ?>
                                <div class="col-lg-4 col-md-4 col-sm-6">
                                    <div class="price-table <?php echo esc_attr($is_active);?>">
                                        <h3>
                                            <?php
                                            echo wp_kses_post($item['title_1']);
                                            ?>
                                        </h3>
                                        <h2>  <?php
                                            echo wp_kses_post($item['price']);
                                            ?></h2>
                                        <?php
                                        echo wp_kses_post($item['duration']);
                                        ?>
                                        <ul>
                                            <?php
                                            echo wp_kses_post($item['content']);
                                            ?>
                                        </ul>
                                        <?php if (!empty($item['button_text'])) { ?>
                                            <a href="<?php echo esc_url($url); ?>" <?php echo esc_url($target); ?> class="apt_form_btn"><?php
                                                echo wp_kses_post($item['button_text']);
                                                ?></a>
                                        <?php }
                                        ?>

                                        <?php if (!empty($item['choice_plan'])) { ?>
                                            <h5 class="pc-text">
                                                <?php
                                                echo wp_kses_post($item['choice_plan']);
                                                ?>
                                            </h5>

                                        <?php }
                                        ?>

                                    </div><!--price-table end-->
                                </div>
                                <?php
                            }
                        }
                        ?>
                    </div>
                </div>
            </div><!--price-table-sec end-->
        </div><!--tb-details end-->
        <div class="tbb-details" id="price_heating">
            <div class="price-table-sec">
                <div class="row">
                    <?php
                    if (!empty($settings['item_list_1'])) {
                        foreach ($settings['item_list_1'] as $key => $item) {
                            $url = '#';
                            $target = '';
                            if (!empty($item['button_url'])) {
                                $link = $item['button_url'];
                                $url = $link['url'];
                                $target = $link['is_external'] ? 'target="_blank"' : '';
                            }
                            $is_active = '';
                                if ($item['is_active']== 'yes') {
                                    $is_active = 'active';
                            }
                            ?>
                            <div class="col-lg-4 col-md-4 col-sm-6">
                                <div class="price-table <?php echo esc_attr($is_active);?>">
                                    <h3>
                                        <?php
                                        echo wp_kses_post($item['title_1']);
                                        ?>
                                    </h3>
                                    <h2>  <?php
                                        echo wp_kses_post($item['price']);
                                        ?></h2>
                                    <?php
                                    echo wp_kses_post($item['duration']);
                                    ?>
                                    <ul>
                                        <?php
                                        echo wp_kses_post($item['content']);
                                        ?>
                                    </ul>
                                    <?php if (!empty($item['button_text'])) { ?>
                                        <a href="<?php echo esc_url($url); ?>" <?php echo esc_url($target); ?> class="apt_form_btn"> <?php
                                            echo wp_kses_post($item['button_text']);
                                            ?></a>
                                    <?php }
                                    ?>
                                    <?php if (!empty($item['choice_plan'])) { ?>
                                            <h5 class="pc-text">
                                                <?php
                                                echo wp_kses_post($item['choice_plan']);
                                                ?>
                                            </h5>
                                        <?php }
                                        ?>
                                </div><!--price-table end-->
                            </div>
                            <?php
                        }
                    }
                    ?>
                </div>
            </div><!--price-table-sec end-->
        </div><!--tb-details end-->
        <?php
    }

}
