<?php

namespace HeacoolAddons\Widgets;

if (!defined('ABSPATH')) {
    exit;
}

use Elementor\Widget_Base;

class Elec_Our_Advantage_2 extends Widget_Base {

    public function get_name() {
        return 'elec_our_advantage_2';
    }

    public function get_title() {
        return __('Our Advantage', 'heacool-core');
    }

    public function get_icon() {
        return 'eicon-banner';
    }

    public function get_categories() {
        return ['heacool'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'bg_section', [
                'label' => __('Background', 'heacool-core'),
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'label' => __('Background Image', 'heacool-core'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .fixed-bg.bg6']
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'content_section', [
                'label' => __('Content', 'heacool-core'),
            ]
        );

        $this->add_control(
            'title_1', [
                'label' => __('Title 1', 'heacool-core'),
                'label_block' => true,
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Our experts are ready to help today!', 'heacool-core'),
                'placeholder' => __('Type your title here', 'heacool-core'),
            ]
        );

        $this->add_control(
            'title_2', [
                'label' => __('Title 2', 'heacool-core'),
                'label_block' => true,
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Our Advantages', 'heacool-core'),
                'placeholder' => __('Type your title here', 'heacool-core'),
            ]
        );

        $this->add_control(
            'content', [
                'label' => __('Content', 'heacool-core'),
                'label_block' => true,
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Heating & Cooling Services is your single source for a complete range of high-quality services, including design/build, engineering, construction, start-up, commissioning, operation, and maintenance.', 'heacool-core'),
            ]
        );

        $repeater = new \Elementor\Repeater();

        /*$repeater->add_control(
        'image', [
        'label' => __('Image', 'heacool-core'),
        'type' => \Elementor\Controls_Manager::ICONS
        ]
        );*/

        $repeater->add_control(
            'svg_text', [
                'label' => __('SVG Text', 'heacool-core'),
                'label_block' => true,
                'description' => __('If Not Use SVG Icon', 'heacool-core'),
                'rows' => 12,
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Type your title here', 'heacool-core'),
            ]
        );

        $repeater->add_control(
            'svg_icons',
            [
                'label' => __('SVG Icons', 'text-domain'),
                'description' => __('If Not Use SVG Text', 'heacool-core'),
                'type' => \Elementor\Controls_Manager::ICONS,

            ]
        );

        $repeater->add_control(
            'title_1', [
                'label' => __('Title', 'heacool-core'),
                'label_block' => true,
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Type your title here', 'heacool-core'),
            ]
        );

        $this->add_control(
            'item_list', [
                'label' => __('Item List', 'heacool-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'title_1' => __('24/7 Emergency Services', 'heacool-core'),
                    ],
                    [
                        'title_1' => __('Free <br />Estimates', 'heacool-core'),
                    ],
                    [
                        'title_1' => __('Low Price Guarantee', 'heacool-core'),
                    ],
                    [
                        'title_1' => __('Licensed & Insured Experts', 'heacool-core'),
                    ],
                    [
                        'title_1' => __('Fast & Reliable Response Times', 'heacool-core'),
                    ],
                ],
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
<section class="block">
  <div class="fixed-bg bg6"></div>
  <div class="container">
    <div class="sec-title">
      <h4><?php
echo wp_kses_post($settings['title_1']);
        ?></h4>
      <h2><?php
echo wp_kses_post($settings['title_2']);
        ?>
      </h2>
    </div>
    <!--sec-title end-->
    <div class="advs_para">
      <p>
        <?php
echo wp_kses_post($settings['content']);
        ?>
      </p>
    </div>
    <!--advs_para end-->
    <div class="advgs-list">
      <?php
if (!empty($settings['item_list'])) {
            foreach ($settings['item_list'] as $item) {
                ?>
      <div class="advgs-info">
        <span class="advgs-icon">
          <?php
if (!empty($item['svg_text'])) {
                    echo $item['svg_text'];
                } else {
                    if (!empty($item['svg_icons']['value']['url'])) {
                        $image_url = $item['svg_icons']['value']['url'];
                        echo '<img class="our_advantage_svg" width="34px" height="37px" style="margin-bottom: 26px;" src="' . $image_url . '">';
                    }
                }
                ?>
        </span>
        <h3><?php echo wp_kses_post($item['title_1']); ?></h3>
      </div>
      <!--advgs-info end-->
      <?php
}
        }
        ?>
    </div>
    <!--advgs-list end-->
    <div class="clearfix"></div>
  </div>
</section>
<!--our-advantages sec end-->
<?php
}
}