<?php

namespace HeacoolAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

/**
 *  Main Slider
 *
 *  widget for Main Slider.
 *
 * @since 1.0.0
 */

class Main_Slider extends Widget_Base {

    public $slick_default = array('navigation' => true, 'arrow' => false);

    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'electrician-main-slider';
    }

    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __('Main Slider', 'heacool-core');
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-posts-ticker';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories() {
        return ['heacool'];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
                'section_content', [
            'label' => __('Content', 'heacool-core'),
                ]
        );

        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
                'slider_image', [
            'label' => __('Slider image', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::MEDIA,
            'default' => [
                'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
                ]
        );

        $repeater->add_control(
                'title_1', [
            'label' => __('Title one', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXTAREA
                ]
        );
        $repeater->add_control(
                'title_2', [
            'label' => __('Title two', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXTAREA
                ]
        );

        $this->add_control(
                'slider_list', [
            'label' => __('Slider List', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'title_1' => __('Bringing Comfort to', 'heacool-core'),
                    'title_2' => __('Your Home 24/7!', 'heacool-core'),
                ],
                [
                    'title_1' => __('High-Quality Heating', 'heacool-core'),
                    'title_2' => __('Installation & Repair', 'heacool-core'),
                ],
                [
                    'title_1' => __('Bringing Comfort to', 'heacool-core'),
                    'title_2' => __('Your Home 24/7!', 'heacool-core'),
                ],
                [
                    'title_1' => __('High-Quality Heating', 'heacool-core'),
                    'title_2' => __('Installation & Repair', 'heacool-core'),
                ],
            ]
                ]
        );


        $this->add_control(
                'footer_logo_img', [
            'label' => __('Logo image', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::MEDIA,
            'default' => [
                'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
                ]
        );

        $this->end_controls_section();



        $this->start_controls_section(
                'slider_options', [
            'label' => __('Slider Settings', 'heacool-core'),
                ]
        );

        $this->add_control(
                'dots', [
            'label' => __('Dots', 'heacool-core'),
            'type' => Controls_Manager::SWITCHER,
            'default' => 'yes'
                ]
        );

        $this->add_control(
                'autoplay', [
            'label' => __('Autoplay', 'heacool-core'),
            'type' => Controls_Manager::SWITCHER,
            'default' => 'yes'
                ]
        );

        $this->add_control(
                'autoplay_speed', [
            'label' => __('Autoplay Speed', 'heacool-core'),
            'type' => Controls_Manager::NUMBER,
            'default' => 4000,
            'frontend_available' => true,
                ]
        );

        $this->add_control(
                'fade', [
            'label' => __('Fading', 'heacool-core'),
            'type' => Controls_Manager::SWITCHER,
            'default' => 'yes'
                ]
        );

        $this->add_control(
                'speed', [
            'label' => __('Speed', 'heacool-core'),
            'type' => Controls_Manager::NUMBER,
            'default' => 700,
            'frontend_available' => true,
                ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
                'section_style', [
            'label' => __('Style', 'heacool-core'),
            'tab' => Controls_Manager::TAB_STYLE,
                ]
        );

        $this->add_control(
                'title_1_color', [
            'label' => __('Title 1', 'heacool-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .content-text-cursive' => 'color: {{VALUE}};',
            ],
                ]
        );

        $this->add_control(
                'title_2_color', [
            'label' => __('Title 2', 'heacool-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .content-head' => 'color: {{VALUE}};',
            ],
                ]
        );

        $this->end_controls_section();
    }

    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();

        if ($settings['dots'] == 'yes') {
            $dots = true;
        } else {
            $dots = false;
        }

        $autoplay_speed = $settings['autoplay_speed'];

        if ($settings['autoplay'] == 'yes') {
            $autoplay = true;
        } else {
            $autoplay = false;
        }

        if ($settings['fade'] == 'yes') {
            $fade = true;
        } else {
            $fade = false;
        }

        $speed = $settings['speed'];

        $slick_atts = array(
            'arrows' => false,
            'dots' => $dots,
            'autoplay' => $autoplay,
            'autoplay_speed' => $autoplay_speed,
            'fade' => $fade,
            'speed' => $speed
        );
        ?>
        <div class="banner-section">
            <div class="banner-slider">
                <?php
                $image_logo_alt = get_post_meta($settings['footer_logo_img']['id'], '_wp_attachment_image_alt', TRUE);
                $footer_logo_img = ( $settings['footer_logo_img']['id'] != '' ) ? wp_get_attachment_url($settings['footer_logo_img']['id']) : $settings['footer_logo_img']['url'];
                if (!empty($settings['slider_list'])) {
                    foreach ($settings['slider_list'] as $item) {
                        $image_alt = get_post_meta($item['slider_image']['id'], '_wp_attachment_image_alt', TRUE);
                        $image_url = ( $item['slider_image']['id'] != '' ) ? wp_get_attachment_url($item['slider_image']['id']) : $item['slider_image']['url'];
                        ?>
                        <div class="banner-slide">
                            <img src="<?php echo esc_url($image_url); ?>" alt="<?php esc_attr($image_alt); ?>">
                            <div class="fig_text">
                                <h3><?php echo wp_kses_post($item['title_1']); ?></h3>
                                <h2><?php echo wp_kses_post($item['title_2']); ?></h2>
                            </div><!--fig_text end-->
                        </div><!--banner-slide end-->
                        <?php
                    }
                }
                ?>
            </div><!--banner-slider end-->
            <div class="fgt-logo">
                <img src="<?php echo esc_url($footer_logo_img); ?>" alt="<?php esc_attr($image_logo_alt); ?>">
            </div><!--fgt-logo end-->
            <div class="fig_sec" style="display: none;">
            </div><!--fig_sec end-->
        </div><!--banner-section end-->
        <?php
    }

}
