<?php

namespace HeacoolAddons\Widgets;

if (!defined('ABSPATH')) {
    exit;
}

use Elementor\Controls_Manager;
use Elementor\Widget_Base;

class Heacool_specialize extends Widget_Base {

    public function get_name() {
        return 'heacool_specialize';
    }

    public function get_title() {
        return __('Specialize', 'heacool-core');
    }

    public function get_icon() {
        return 'eicon-banner';
    }

    public function get_categories() {
        return ['heacool'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
                'content_section', [
            'label' => __('Content 1', 'heacool-core'),
                ]
        );

        $this->add_control(
                'title', [
            'label' => __('Title', 'heacool-core'),
            'label_block' => true,
            'type' => Controls_Manager::TEXT,
            'default' => __('We <span>Specialize</span> In', 'heacool-core')
                ]
        );

        $this->add_control(
                'content', [
            'label' => __('Content', 'heacool-core'),
            'type' => Controls_Manager::TEXTAREA,
            'default' => ''
                ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
                'content_section_1', [
            'label' => __('Content 2', 'heacool-core'),
                ]
        );

        $this->add_control(
                'title_1', [
            'label' => __('Title', 'heacool-core'),
            'label_block' => true,
            'type' => Controls_Manager::TEXT,
            'default' => __('Our <span>Cooling &amp; Heating</span> Technicians are:', 'heacool-core')
                ]
        );

        $this->add_control(
                'content_2', [
            'label' => __('Content', 'heacool-core'),
            'type' => Controls_Manager::TEXTAREA,
            'default' => ''
                ]
        );

        $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
        <section class="block">
            <div class="container">
                <div class="spacial_sec">
                    <h3 class="sc-title"> <?php
                    echo wp_kses_post($settings['title']);
                    ?></h3>
                    <div class="row spz_links">
                     <?php
                     echo $settings['content'];
                     ?>
                     </div>
             </div><!--spacial_sec end-->
             <div class="tech_ssec">
                <h3 class="sc-title"> <?php
                echo wp_kses_post($settings['title_1']);
                ?></h3>
                <?php
                echo $settings['content_2'];
                ?>
            </div><!--tech_ssec end-->
        </div>
    </section>
        <?php
    }
}