<?php

namespace HeacoolAddons\Widgets;

if (!defined('ABSPATH')) {
    exit;
}

use Elementor\Controls_Manager;
use Elementor\Widget_Base;

class Heacool_financing extends Widget_Base {

    public function get_name() {
        return 'heacool_financing';
    }

    public function get_title() {
        return __('Financing', 'heacool-core');
    }

    public function get_icon() {
        return 'eicon-banner';
    }

    public function get_categories() {
        return ['heacool'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
                'content_section', [
            'label' => __('Content', 'heacool-core'),
                ]
        );

        $this->add_control(
                'image', [
            'label' => __('Image', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::MEDIA,
            'default' => [
                'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
                ]
        );

        $this->add_control(
                'title', [
            'label' => __('Title', 'heacool-core'),
            'label_block' => true,
            'type' => Controls_Manager::TEXTAREA,
            'default' => __('Heating & Cooling Service credit card is an easy and convenient way pay for your Heating & Cooling Service purchases.', 'heacool-core')
                ]
        );

        $this->add_control(
                'title_1', [
            'label' => __('Title 1', 'heacool-core'),
            'label_block' => true,
            'type' => Controls_Manager::TEXT,
            'default' => __('Reasons To Finance', 'heacool-core')
                ]
        );

        $this->add_control(
                'content', [
            'label' => __('Content', 'heacool-core'),
            'type' => Controls_Manager::TEXTAREA,
            'default' => ''
                ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $image_alt = get_post_meta($settings['image']['id'], '_wp_attachment_image_alt', TRUE);
        $image_url = ( $settings['image']['id'] != '' ) ? wp_get_attachment_url($settings['image']['id']) : $settings['image']['url'];
        ?>
               <div class="container">
                        <div class="financ_tab_content">
                            <div class="row">
                                <div class="col-lg-6 fin-img-col">
                                    <div class="finan_img">
                                    <img src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_attr($image_alt); ?>">
                                    </div><!--finan_img end-->
                                </div>
                                <div class="col-lg-6 fin-text-col">
                                    <div class="finan_text">
                                        <p>
                                        <?php
                                        echo wp_kses_post($settings['title']);
                                        ?>
                                        </p>
                                        <h3>
                                            <?php
                                        echo wp_kses_post($settings['title_1']);
                                        ?>
                                        </h3>
                                    <?php
                                    echo wp_kses_post($settings['content']);
                                    ?>
                                    </div><!--finan_text end-->
                                </div>
                            </div>
                        </div><!--financ_tab_content end-->
                    </div>
        <?php
    }
}