<?php

namespace HeacoolAddons\Widgets;

if (!defined('ABSPATH')) {
    exit;
}

use Elementor\Controls_Manager;

class HeacoolContactSection extends \Elementor\Widget_Base {   
    public function get_name() {
        return 'heacool_contact_section';
    }

    public function get_title() {
        return esc_html__('Contact Section', 'heacool-core');
    }

    public function get_icon() {
        return 'eicon-mail';
    }

    public function get_categories() {
        return ['heacool'];
    }
    protected function _register_controls() {

        $this->start_controls_section(
                'cotnact_content', [
            'label' => esc_html__('Content', 'heacool-core'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                ]
        );

        $this->add_control(
                'title_1', [
            'label' => __('Title', 'heacool-core'),
            'type' => Controls_Manager::TEXT,
            'label_block' => true,
            'default' => __('Have More Questions?', 'heacool-core')
                ]
        );

        $this->add_control(
                'content', [
            'label' => __('Content', 'heacool-core'),
            'type' => Controls_Manager::TEXTAREA,
            'default' => __('If you have a question about heating, cooling or air quality matters, just ask our experts. We\'re here to help! Please fill the form to ask your question.', 'heacool-core')
                ]
        );

        $this->add_control(
                'cf7', [
            'label' => esc_html__('Select Contact Form', 'heacool-core'),
            'description' => esc_html__('Contact form 7 - plugin must be installed and there must be some contact forms made with the contact form 7', 'electriciancore'),
            'type' => Controls_Manager::SELECT2,
            'multiple' => false,
            'label_block' => 1,
            'options' => get_contact_form_7_posts(),
                ]
        );

        $this->end_controls_section();
    }

    protected function render() {  //to show on the fontend 
        $settings = $this->get_settings_for_display();
        ?>
        <section class="block qzz-sec">
            <div class="container">
                <div class="sec-title">
                    <h2><?php
                    echo wp_kses_post($settings['title_1']);
                    ?></h2>
                </div><!--sec-title end-->
                <div class="quz_sec">
                    <p>
                    <?php
                    echo wp_kses_post($settings['content']);
                    ?>
                    </p>
                    <div class="question_sec">
                        <?php
                        if (!empty($settings['cf7'])) {
                            echo'<div class="elementor-shortcode electriciancore-cf7">';
                            echo do_shortcode('[contact-form-7 id="' . $settings['cf7'] . '"]');
                            echo '</div>';
                        }
                        ?>
                    </div><!--question-sec end-->
                </div><!--quz_sec end-->
            </div>
        </section>
        <?php
    }
}