<?php

namespace HeacoolAddons\Widgets;

if (!defined('ABSPATH')) {
    exit;
}

use Elementor\Controls_Manager;

class HeacoolContactPage extends \Elementor\Widget_Base {   
    public function get_name() {
        return 'heacool_contact_page';
    }

    public function get_title() {
        return esc_html__('Contact Page', 'heacool-core');
    }

    public function get_icon() {
        return 'eicon-mail';
    }

    public function get_categories() {
        return ['heacool'];
    }
    protected function _register_controls() {

        $this->start_controls_section(
                'cotnact_content', [
            'label' => esc_html__('Content', 'heacool-core'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                ]
        );

        $this->add_control(
                'design_style', [
            'label' => __('Style', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => '1',
            'options' => [
                '1' => __('Style 1', 'heacool-core'),
                '2' => __('Style 2', 'heacool-core'),
                '3' => __('Style 3', 'heacool-core')
            ],
                ]
        );

        $this->add_control(
                'title_1', [
            'label' => __('Title 1', 'heacool-core'),
            'type' => Controls_Manager::TEXT,
            'label_block' => true,
            'default' => __('Get In <span>Touch</span>', 'heacool-core')
                ]
        );

        $this->add_control(
                'content', [
            'label' => __('Content', 'heacool-core'),
            'type' => Controls_Manager::TEXTAREA,
            'default' => __('Contact us if you have any questions about some of our HVAC services. You can also call if you need help with a heating, cooling or air quality issues. We provide free quotes for any new heating or AC equipment installation. Whether you need residential or commercial services, our experienced HVAC specialists are ready to serve you. ', 'heacool-core')
                ]
        );

        $this->add_control(
                'social_links', [
            'label' => __('Social Links', 'heacool-core'),
            'type' => Controls_Manager::TEXTAREA,
            'condition' => ['design_style' => '1']
                ]
        );

        $this->add_control(
                'cf7', [
            'label' => esc_html__('Select Contact Form', 'heacool-core'),
            'description' => esc_html__('Contact form 7 - plugin must be installed and there must be some contact forms made with the contact form 7', 'electriciancore'),
            'type' => Controls_Manager::SELECT2,
            'multiple' => false,
            'label_block' => 1,
            'options' => get_contact_form_7_posts(),
                ]
        );

        $this->end_controls_section();
    }

    protected function render() {  //to show on the fontend 
        $settings = $this->get_settings_for_display();
        if ($settings['design_style'] == '1') {
            ?>
            <div class="page-content p-0">
                <div class="container">
                    <section class="getin_touch block">
                        <div class="row">
                            <div class="col-lg-4 col-md-4">
                                <div class="gettouch_text">
                                    <h3 class="sc-title">
                                        <?php
                                        echo wp_kses_post($settings['title_1']);
                                        ?></h3>
                                        <p><?php
                                        echo wp_kses_post($settings['content']);
                                        ?></p>
                                        <?php
                                        echo wp_kses_post($settings['social_links']);
                                        ?>
                                    </div><!--gettouch_text end-->
                                </div>
                                <div class="col-lg-8 col-md-8">
                                    <div class="question_sec">
                                     <?php
                                     if (!empty($settings['cf7'])) {
                                        echo'<div class="elementor-shortcode electriciancore-cf7">';
                                        echo do_shortcode('[contact-form-7 id="' . $settings['cf7'] . '"]');
                                        echo '</div>';
                                    }
                                    ?>
                                </div><!--question-sec end-->
                            </div>
                        </div>
                    </section><!--getin_touch end-->
                </div>
            </div>
            <?php
        } elseif ($settings['design_style'] == '2') { ?>
        <section class="block qzz-sec">
            <div class="container">
                <div class="sec-title">
                    <h2><?php
                    echo wp_kses_post($settings['title_1']);
                    ?></h2>
                </div><!--sec-title end-->
                <div class="quz_sec">
                    <p>
                        <?php
                        echo wp_kses_post($settings['content']);
                        ?>
                    </p>
                    <div class="question_sec">
                        <?php
                        if (!empty($settings['cf7'])) {
                            echo'<div class="elementor-shortcode electriciancore-cf7">';
                            echo do_shortcode('[contact-form-7 id="' . $settings['cf7'] . '"]');
                            echo '</div>';
                        }
                        ?>
                    </div><!--question-sec end-->
                </div><!--quz_sec end-->
            </div>
        </section>
        <?php
         }else{ ?>
        <div class="request_form">
            <p>
                <?php
                echo wp_kses_post($settings['content']);
                ?>
            </p>
            <?php
            if (!empty($settings['cf7'])) {
                echo'<div class="elementor-shortcode electriciancore-cf7">';
                echo do_shortcode('[contact-form-7 id="' . $settings['cf7'] . '"]');
                echo '</div>';
            }
            ?>
        </div><!--request_form end-->
        <?php
         }
    }
}