<?php

namespace HeacoolAddons\Widgets;

use Elementor\Widget_Base;

if (!defined('ABSPATH')) {
    exit;
}
// Exit if accessed directly

/**
 *  Testimonials Slider
 *
 *  widget for Testimonials Slider.
 *
 * @since 1.0.0
 */

class Elec_Testimonials_Two extends Widget_Base {

    public $slick_default = array('navigation' => true, 'arrow' => false);

    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'electrician-testimonials-2';
    }

    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __('Testimonials', 'heacool-core');
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-posts-ticker';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories() {
        return ['heacool'];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'bg_content', [
                'label' => __('Background', 'heacool-core'),
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'label' => __('Background Image', 'heacool-core'),
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .fixed-bg.bg5',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_content', [
                'label' => __('Content', 'heacool-core'),
            ]
        );

        $this->add_control(
            'title_1', [
                'label' => __('Title 1 && 2', 'heacool-core'),
                'label_block' => true,
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Company reviews', 'heacool-core'),
            ]
        );

        $this->add_control(
            'title_2', [
                'label' => false,
                'label_block' => true,
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Customer <span>Testimonials</span>', 'heacool-core'),
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'content', [
                'label' => __('Review Text', 'heacool-core'),
                'label_block' => true,
                'type' => \Elementor\Controls_Manager::TEXTAREA,
            ]
        );
        $repeater->add_control(
            'username', [
                'label' => __('Reviewer Name', 'heacool-core'),
                'label_block' => true,
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'slider_list', [
                'label' => __('Slider List', 'heacool-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'content' => __('All work was explained and we were shown where and what was to be done. Price was very fair. Workers were on time and ready to work. Job finished on time. Everything was cleaned and vacuumed. System worked properly. It was very nice to work with a company that had very polite and helpful employees at the job and in the office.', 'heacool-core'),
                        'username' => __('<strong>– Wilson Trayer,</strong> customer', 'heacool-core'),
                    ],
                    [
                        'content' => __('All work was explained and we were shown where and what was to be done. Price was very fair. Workers were on time and ready to work. Job finished on time. Everything was cleaned and vacuumed. System worked properly. It was very nice to work with a company that had very polite and helpful employees at the job and in the office.', 'heacool-core'),
                        'username' => __('<strong>– Wilson Trayer,</strong> customer', 'heacool-core'),
                    ],
                    [
                        'content' => __('All work was explained and we were shown where and what was to be done. Price was very fair. Workers were on time and ready to work. Job finished on time. Everything was cleaned and vacuumed. System worked properly. It was very nice to work with a company that had very polite and helpful employees at the job and in the office.', 'heacool-core'),
                        'username' => __('<strong>– Wilson Trayer,</strong> customer', 'heacool-core'),
                    ],
                ],
            ]
        );

        $this->end_controls_section();
    }

    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
<section class="block testi-sec  why-chose-nes nres-test">
  <div class="fixed-bg bg5"></div>
  <div class="container">
    <div class="row">
      <div class="col-lg-6"></div>
      <div class="col-lg-6">
        <div class="testimonial">
          <h4><?php echo esc_html($settings['title_1']); ?></h4>
          <h3><?php echo wp_kses_post($settings['title_2']); ?></h3>
          <div class="testi_carousel">
            <?php
if (!empty($settings['slider_list'])) {
            foreach ($settings['slider_list'] as $item) {
                ?>
            <div class="testi_slide">
              <p><?php echo wp_kses_post($item['content']); ?></p>
              <h4><?php echo wp_kses_post($item['username']); ?></h4>
            </div>
            <!--testi_slide end-->
            <?php
}
        }
        ?>
          </div>
          <!--testi_carousel end-->
        </div>
        <!--testimonial end-->
      </div>
    </div>
  </div>
</section>
<?php
}

}