<?php

namespace HeacoolAddons\Widgets;

use Elementor\Widget_Base;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

/**
 *  Main Slider
 *
 *  widget for Main Slider.
 *
 * @since 1.0.0
 */

class Elec_Team_2 extends Widget_Base {

    public $slick_default = array('navigation' => true, 'arrow' => false);

    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'electrician-team-2';
    }

    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __('Heacool Team', 'heacool-core');
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-posts-ticker';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories() {
        return ['heacool'];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
                'section_content', [
            'label' => __('Content', 'heacool-core'),
                ]
        );

       $this->add_control(
                'title_1', [
            'label' => __('Title one', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('Get to know the great people', 'heacool-core'),
                ]
        );

        $this->add_control(
                'title_2', [
            'label' => __('Title two', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('Installation Team', 'heacool-core'),
                ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
                'slider_image', [
            'label' => __('Slider image', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::MEDIA,
            'default' => [
                'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
                ]
        );

        $repeater->add_control(
                'title_1', [
            'label' => __('Title one', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXTAREA
                ]
        );

        $repeater->add_control(
                'title_2', [
            'label' => __('Title two', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXTAREA
                ]
        );

        $repeater->add_control(
                'content', [
            'label' => __('Content', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXTAREA
                ]
        );

        $this->add_control(
                'slider_list', [
            'label' => __('Slider List', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'title_1' => __('Jonathan Bradley', 'heacool-core'),
                    'title_2' => __('Installation Manager', 'heacool-core'),
                    'content' => __('Worked as an installer for 10 years and in 2015 became the Installation Manager.', 'heacool-core'),
                ],
                [
                    'title_1' => __('Roger Erickson', 'heacool-core'),
                    'title_2' => __('Installation', 'heacool-core'),
                    'content' => __('Creative problem solver and have a very "can do" attitude despite a difficult job.', 'heacool-core'),
                ],
                [
                    'title_1' => __('Roger Erickson', 'heacool-core'),
                    'title_2' => __('Service Manager', 'heacool-core'),
                    'content' => __('joel have been involved with the HVAC trade for nearly a decade and love it.', 'heacool-core'),
                ],
            ]
                ]
        );

        $this->end_controls_section();
    }

    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
        <section class="block team_sec">
            <div class="container">
                <div class="sec-title">
                    <h4><?php
                    echo wp_kses_post($settings['title_1']);
                    ?></h4>
                    <h2><?php
                    echo wp_kses_post($settings['title_2']);
                    ?></h2>
                </div><!--sec-title end-->
                <div class="team-sec">
                    <div class="row team_carousel">
                       <?php
                       if (!empty($settings['slider_list'])) {
                        foreach ($settings['slider_list'] as $item) {
                            $image_alt = get_post_meta($item['slider_image']['id'], '_wp_attachment_image_alt', TRUE);
                            $image_url = ( $item['slider_image']['id'] != '' ) ? wp_get_attachment_url($item['slider_image']['id']) : $item['slider_image']['url'];
                            ?>
                            <div class="col-lg-4">
                                <div class="team">
                                    <div class="team_img">
                                        <img src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_url($image_alt);?>">
                                    </div><!--team_img end-->
                                    <h3><?php echo wp_kses_post($item['title_1']); ?></h3>
                                    <h4><?php echo wp_kses_post($item['title_2']); ?></h4>
                                    <p><?php echo wp_kses_post($item['content']); ?> </p>
                                </div><!--team end-->
                            </div>
                            <?php
                        }
                    }
                    ?>
                </div>
            </div><!--team-sec end-->
        </div>
    </section><!--team-sec end-->
        <?php
    }
}
