<?php

namespace HeacoolAddons\Widgets;

use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) {
    exit;
}
// Exit if accessed directly

class Elec_Services extends Widget_Base {

    public function get_name() {
        return 'electrician_services';
    }

    public function get_title() {
        return esc_html__('Services', 'heacool-core');
    }

    public function get_icon() {
        return 'eicon-banner';
    }

    public function get_categories() {
        return ['heacool'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'image_section', [
                'label' => esc_html__('Images', 'heacool-core'),
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'label' => __('Background Image', 'heacool-core'),
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .qck-sec',
            ]
        );

        $this->add_control(
            'image', [
                'label' => esc_html__('Image 1', 'heacool-core'),
                'type' => Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'image_1', [
                'label' => esc_html__('Image 2', 'heacool-core'),
                'type' => Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'image_2', [
                'label' => esc_html__('Image 3', 'heacool-core'),
                'type' => Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'introduction_section', [
                'label' => esc_html__('Content', 'heacool-core'),
            ]
        );
        $this->add_control(
            'title_1', [
                'label' => esc_html__('Title 1', 'heacool-core'),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
                'default' => __('Your home comfort experts', 'heacool-core'),
            ]
        );

        $this->add_control(
            'title_2', [
                'label' => esc_html__('Title 2', 'heacool-core'),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
                'default' => __('<span>Quality</span> Heating & Cooling Services', 'heacool-core'),
            ]
        );

        $this->add_control(
            'content', [
                'label' => esc_html__('Content 1', 'heacool-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('We provide customers with an industry leading 10-year installation warranty and a two-year service and repair warranty. With most companies, you will get a standard manufacturers warranty on installations and a one-year warranty on service and repair work. ', 'heacool-core'),
            ]
        );

        $this->add_control(
            'content_1', [
                'label' => esc_html__('Content 2', 'heacool-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('We believe our warranties set us apart from our competitors and show our commitment to quality work and service.', 'heacool-core'),
            ]
        );

        $this->add_control(
            'button_text', [
                'label' => esc_html__('Button Text', 'heacool-core'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Read More', 'heacool-core'),
            ]
        );

        $this->add_control(
            'action_link', [
                'label' => __('Action Button', 'heacool-core'),
                'type' => Controls_Manager::URL,
                'default' => [
                    'url' => '#',
                    'is_external' => '',
                ],
                'show_external' => true,
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $url = '#';
        $target = '';
        if (!empty($settings['action_link'])) {
            $link = $settings['action_link'];
            $url = $link['url'];
            $target = $link['is_external'] ? 'target="_blank"' : '';
        }
        $image_url = ($settings['image']['id'] != '') ? wp_get_attachment_url($settings['image']['id']) : $settings['image']['url'];
        $image_alt = get_post_meta($settings['image']['id'], '_wp_attachment_image_alt', true);
        $image_url_1 = ($settings['image_1']['id'] != '') ? wp_get_attachment_url($settings['image_1']['id']) : $settings['image_1']['url'];
        $image_alt_1 = get_post_meta($settings['image_1']['id'], '_wp_attachment_image_alt', true);
        $image_url_2 = ($settings['image_2']['id'] != '') ? wp_get_attachment_url($settings['image_2']['id']) : $settings['image_2']['url'];
        $image_alt_2 = get_post_meta($settings['image_2']['id'], '_wp_attachment_image_alt', true);
        ?>

<section class="qck-sec">
  <div class="container">
    <div class="qck-sec-details">
      <div class="row">
        <div class="col-lg-6 col-md-6 col-sm-6">
          <div class="qck-imgs">
            <div class="row">
              <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6">
                <div class="qck-img mgt--24">
                  <img src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_attr($image_alt); ?>">
                </div>
                <!--qck-img end-->
              </div>
              <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6">
                <div class="qck-img mgb-30">
                  <img src="<?php echo esc_url($image_url_1); ?>" alt="<?php echo esc_attr($image_alt_1); ?>">
                </div>
                <!--qck-img end-->
                <div class="qck-img">
                  <img src="<?php echo esc_url($image_url_2); ?>" alt="<?php echo esc_attr($image_alt_2); ?>">
                </div>
                <!--qck-img end-->
              </div>
            </div>
          </div>
          <!--qck-imgs end-->
        </div>
        <div class="col-lg-6 col-md-6 col-sm-6">
          <div class="qck-services">
            <h4>
              <?php
echo heacool_kses_intermediate($settings['title_1']);
        ?>
            </h4>
            <h2>
              <?php
echo heacool_kses_intermediate($settings['title_2']);
        ?>
            </h2>
            <p>
              <?php
echo wp_kses_post($settings['content']);
        ?>
            </p>
            <p>
              <?php
echo wp_kses_post($settings['content_1']);
        ?>
            </p>
            <?php if (!empty($settings['button_text'])) {?>
            <a href="<?php echo esc_url($url); ?>" <?php echo $target; ?> class="lnk-default"><?php
echo esc_html($settings['button_text']);
            ?></a>
            <?php
}
        ?>
          </div>
          <!---qck-services end-->
        </div>
      </div>
    </div>
    <!--qck-sec-details end-->
  </div>
</section>
<!---qck-sec end-->
<?php
}

}