<?php

namespace HeacoolAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class Elec_Sevices_Tabs extends Widget_Base {

    public function get_name() {
        return 'centre-sevices_tabs';
    }

    public function get_title() {
        return __('Sevices Tabs', 'heacool-core');
    }

    public function get_icon() {
        return 'eicon-banner';
    }

    public function get_categories() {
        return ['heacool'];
    }

    /**
     * Retrieve the list of scripts the widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    public function get_script_depends() {
        return ['centre-information'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
                'title_section', [
            'label' => __('Title', 'heacool-core'),
                ]
        );

        $this->add_control(
                'title_1', [
            'label' => __('Title 1, 2 and 3', 'heacool-core'),
            'label_block' => true,
            'label_block' => true,
            'type' => Controls_Manager::TEXT,
            'default' => __('Open 24/7 with office staff', 'heacool-core')
                ]
        );

        $this->add_control(
                'title_2', [
            'label' => false,
            'label_block' => true,
            'type' => Controls_Manager::TEXT,
            'default' => __('How Can We Help You?', 'heacool-core'),
                ]
        );

        $this->add_control(
                'title_3', [
            'label' => false,
            'label_block' => true,
            'type' => Controls_Manager::TEXT,
            'default' => __('Choose your service', 'heacool-core'),
                ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
                'tab_section', [
            'label' => __('First Tab', 'heacool-core'),
                ]
        );

        $this->add_control(
                'tab_title', [
            'label' => __('Title', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('Cooling Services', 'heacool-core'),
                ]
        );
        $this->add_control(
            'limage', [
        'label' => __('Left service Icon', 'heacool-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        
            ]
        );      

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
                'title_1', [
            'label' => __('Title one', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'placeholder' => __('Type your title here', 'heacool-core'),
                ]
        );

        $repeater->add_control(
                'content', [
            'label' => __('Content', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'placeholder' => __('Type your title here', 'heacool-core'),
                ]
        );

        $repeater->add_control(
                'image', [
            'label' => __('Image', 'childit-core'),
            'type' => \Elementor\Controls_Manager::MEDIA,
            'default' => [
                'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
                ]
        );

        $repeater->add_control(
                'action_link', [
            'label' => __('Action', 'childit-core'),
            'type' => Controls_Manager::URL,
            'default' => [
                'url' => '#',
                'is_external' => '',
            ],
            'show_external' => true,
                ]
        );
        $this->add_control(
                'item_list', [
            'label' => __('Item List', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'title_1' => __('Air Conditioning', 'heacool-core'),
                    'content' => __('Air conditioning is a fairly simple matter. An outside air conditioning unit, working in conjunction with the home’s furnace and air ducts, provides cool air to every room.', 'heacool-core'),
                ],
                [
                    'title_1' => __('Air Conditioning', 'heacool-core'),
                    'content' => __('Air conditioning is a fairly simple matter. An outside air conditioning unit, working in conjunction with the home’s furnace and air ducts, provides cool air to every room.', 'heacool-core'),
                ],
                [
                    'title_1' => __('Air Conditioning', 'heacool-core'),
                    'content' => __('Air conditioning is a fairly simple matter. An outside air conditioning unit, working in conjunction with the home’s furnace and air ducts, provides cool air to every room.', 'heacool-core'),
                ],
            ]
                ]
        );
        $this->end_controls_section();


        $this->start_controls_section(
                'tab_section_1', [
            'label' => __('Second Tab', 'heacool-core'),
                ]
        );

        $this->add_control(
                'tab_title_1', [
            'label' => __('Title', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('Heating Services', 'heacool-core'),
                ]
        );
        $this->add_control(
            'rimage', [
        'label' => __('Right service Icon', 'heacool-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );


        $repeater_1 = new \Elementor\Repeater();

        $repeater_1->add_control(
                'title_1', [
            'label' => __('Title one', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'placeholder' => __('Type your title here', 'heacool-core'),
                ]
        );

        $repeater_1->add_control(
                'content', [
            'label' => __('Content', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'placeholder' => __('Type your title here', 'heacool-core'),
                ]
        );

        $repeater_1->add_control(
                'image', [
            'label' => __('Image', 'childit-core'),
            'type' => \Elementor\Controls_Manager::MEDIA,
            'default' => [
                'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
                ]
        );

        $repeater_1->add_control(
                'action_link', [
            'label' => __('Action', 'childit-core'),
            'type' => Controls_Manager::URL,
            'default' => [
                'url' => '#',
                'is_external' => '',
            ],
            'show_external' => true,
                ]
        );
        $this->add_control(
                'item_list_1', [
            'label' => __('Item List', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'title_1' => __('Air Conditioning', 'heacool-core'),
                    'content' => __('Air conditioning is a fairly simple matter. An outside air conditioning unit, working in conjunction with the home’s furnace and air ducts, provides cool air to every room.', 'heacool-core'),
                ],
                [
                    'title_1' => __('Air Conditioning', 'heacool-core'),
                    'content' => __('Air conditioning is a fairly simple matter. An outside air conditioning unit, working in conjunction with the home’s furnace and air ducts, provides cool air to every room.', 'heacool-core'),
                ],
                [
                    'title_1' => __('Air Conditioning', 'heacool-core'),
                    'content' => __('Air conditioning is a fairly simple matter. An outside air conditioning unit, working in conjunction with the home’s furnace and air ducts, provides cool air to every room.', 'heacool-core'),
                ],
            ]
                ]
        );

        


        

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
        <section class="block service-block">
            <div class="container">
                <div class="sec-title">
                    <h4><?php
                        echo heacool_kses_basic($settings['title_1']);
                        ?></h4>
                    <h2><?php
                        echo heacool_kses_basic($settings['title_2']);
                        ?></h2>
                </div><!--sec-title end-->
            </div>
            <div class="choose_services_sec">
                <h5><?php
                    echo heacool_kses_basic($settings['title_3']);
                    ?></h5>
                <ul class="tabs_list">
                    <li class="active" data-tab="cooling_sli">
                        <span class="tc_icon">
                        <?php
          if (!empty($settings['limage']['url'])){ 
               echo '<img src="' . $settings['limage']['url'] . '">';  
            }else{ 
          ?>
                            <svg version="1.1" id="Capa_7" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                                 viewBox="0 0 333.316 333.316" xml:space="preserve">
                                <path d="M315.797,224.574l-5.557-20.818l-39.684,10.592l-33.572-19.441l41.764-18.377v-19.75l-41.767-18.377l33.572-19.439
                                      l39.689,10.59l5.557-20.818l-18.861-5.025l19.361-11.197l-10.82-18.645l-19.324,11.188l5.029-18.855l-20.818-5.551l-10.588,39.674
                                      l-33.473,19.338l4.918-45.148l-17.061-9.877l-36.758,26.892V52.824l29.045-29.018L191.221,8.539l-13.816,13.807V0h-21.531v22.346
                                      L142.064,8.539l-15.236,15.268l29.045,29.018v38.703l-36.756-26.892l-17.061,9.877l4.924,45.148l-33.477-19.336l-10.59-39.676
                                      l-20.816,5.553l5.027,18.854l-19.32-11.188L17.018,92.512l19.322,11.197l-18.857,5.025l5.557,20.818l39.684-10.59l33.576,19.439
                                      l-41.771,18.377v19.75l41.768,18.377l-33.576,19.441l-39.678-10.592l-5.557,20.818l18.853,5.025l-19.32,11.195l10.787,18.652
                                      l19.318-11.18l-5.029,18.84l20.818,5.559l10.59-39.682l33.479-19.338l-4.924,45.15l17.061,9.879l36.756-26.893V280.5l-29.045,29.004
                                      l15.236,15.266l13.809-13.805v22.352h21.531v-22.352l13.816,13.805l15.229-15.266L177.404,280.5v-38.717l36.758,26.893l17.061-9.879
                                      l-4.92-45.15l33.475,19.338l10.59,39.682l20.818-5.559l-5.029-18.838l19.322,11.178l10.82-18.652l-19.361-11.193L315.797,224.574z
                                      M247.668,166.654l-33.779,14.885l-25.75-14.887l25.746-14.877L247.668,166.654z M207.148,96.471l-3.975,36.578l-25.77,14.93
                                      v-29.721L207.148,96.471z M126.129,96.471l29.744,21.787v29.721l-25.771-14.93L126.129,96.471z M85.609,166.654l33.783-14.879
                                      l25.748,14.877l-25.752,14.887L85.609,166.654z M126.129,236.84l3.973-36.582l25.771-14.924v29.717L126.129,236.84z M207.148,236.84
                                      l-29.744-21.789v-29.717l25.77,14.924L207.148,236.84z"/>
                            </svg>
                            <?php } ?>
                        </span>
                        <span class="svs"><?php
                            echo heacool_kses_basic($settings['tab_title']);
                            ?>
                        </span>
                    </li>
                    <li class="heating" data-tab="heating_sli">
                        <span class="svs"><?php
                            echo heacool_kses_basic($settings['tab_title_1']);
                            ?></span>
                        <span class="tc_icon">
                        <?php
          if (!empty($settings['rimage']['url'])){
            echo '<img src="' . $settings['rimage']['url'] . '">';
          }else{
          ?>
                            <svg version="1.1" id="Capa_8" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                                 width="45.16px" height="45.16px" viewBox="0 0 45.16 45.16"  xml:space="preserve"
                                 >
                                <g>
                                    <g>
                                        <path d="M22.58,11.269c-6.237,0-11.311,5.075-11.311,11.312s5.074,11.312,11.311,11.312c6.236,0,11.311-5.074,11.311-11.312
                                              S28.816,11.269,22.58,11.269z"/>
                                        <g>
                                            <g>
                                                <path d="M22.58,7.944c-1.219,0-2.207-0.988-2.207-2.206V2.207C20.373,0.988,21.361,0,22.58,0c1.219,0,2.207,0.988,2.207,2.207
                                                      v3.531C24.787,6.956,23.798,7.944,22.58,7.944z"/>
                                            </g>
                                            <g>
                                                <path d="M22.58,37.215c-1.219,0-2.207,0.988-2.207,2.207v3.53c0,1.22,0.988,2.208,2.207,2.208c1.219,0,2.207-0.988,2.207-2.208
                                                      v-3.53C24.787,38.203,23.798,37.215,22.58,37.215z"/>
                                            </g>
                                            <g>
                                                <path d="M32.928,12.231c-0.861-0.862-0.861-2.259,0-3.121l2.497-2.497c0.861-0.861,2.259-0.861,3.121,0
                                                      c0.862,0.862,0.862,2.26,0,3.121l-2.497,2.497C35.188,13.093,33.791,13.093,32.928,12.231z"/>
                                            </g>
                                            <g>
                                                <path d="M12.231,32.93c-0.862-0.863-2.259-0.863-3.121,0l-2.497,2.496c-0.861,0.861-0.862,2.26,0,3.121
                                                      c0.862,0.861,2.26,0.861,3.121,0l2.497-2.498C13.093,35.188,13.093,33.79,12.231,32.93z"/>
                                            </g>
                                            <g>
                                                <path d="M37.215,22.58c0-1.219,0.988-2.207,2.207-2.207h3.531c1.219,0,2.207,0.988,2.207,2.207c0,1.219-0.988,2.206-2.207,2.206
                                                      h-3.531C38.203,24.786,37.215,23.799,37.215,22.58z"/>
                                            </g>
                                            <g>
                                                <path d="M7.944,22.58c0-1.219-0.988-2.207-2.207-2.207h-3.53C0.988,20.373,0,21.361,0,22.58c0,1.219,0.988,2.206,2.207,2.206
                                                      h3.531C6.956,24.786,7.944,23.799,7.944,22.58z"/>
                                            </g>
                                            <g>
                                                <path d="M32.928,32.93c0.862-0.861,2.26-0.861,3.121,0l2.497,2.497c0.862,0.86,0.862,2.259,0,3.12s-2.259,0.861-3.121,0
                                                      l-2.497-2.497C32.066,35.188,32.066,33.791,32.928,32.93z"/>
                                            </g>
                                            <g>
                                                <path d="M12.231,12.231c0.862-0.862,0.862-2.259,0-3.121L9.734,6.614c-0.862-0.862-2.259-0.862-3.121,0
                                                      c-0.862,0.861-0.862,2.259,0,3.12l2.497,2.497C9.972,13.094,11.369,13.094,12.231,12.231z"/>
                                            </g>
                                        </g>
                                    </g>
                                </g>
                            </svg>
                            <?php } ?>
                        </span>
                    </li>
                </ul><!--tabs_list end-->
                <div class="srvs_slider active" id="cooling_sli">
                    <?php
                    if (!empty($settings['item_list'])) {
                        foreach ($settings['item_list'] as $item) {
                            $image_alt = get_post_meta($item['image']['id'], '_wp_attachment_image_alt', TRUE);
                            $image_url = ( $item['image']['id'] != '' ) ? wp_get_attachment_url($item['image']['id']) : $item['image']['url'];
                            ?>
                            <div class="srvs_dv">
                                <img src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_attr($image_alt); ?>">
                                    <h2 class="srvs_heading"><?php echo esc_html($item['title_1']); ?></h2>
                                    <div class="srvs_details">
                                        <h3><?php echo esc_html($item['title_1']); ?></h3>
                                        <p><?php echo heacool_kses_intermediate($item['content']); ?></p>
                                        <?php if (!empty($item['action_link']['url'])) { ?>
                                            <a href="<?php echo esc_url($item['action_link']['url']); ?>" title="" class="play_icon"><i class="fa fa-play-circle"></i></a>
                                            <?php
                                        }
                                        ?>
                                    </div>
                            </div><!--srvs_dv end-->
                            <?php
                        }
                    }
                    ?>
                </div><!--srvs_slider end-->
                <div class="srvs_slider" id="heating_sli">
                    <?php
                    if (!empty($settings['item_list_1'])) {
                        foreach ($settings['item_list_1'] as $item) {
                            $image_url = ( $item['image']['id'] != '' ) ? wp_get_attachment_url($item['image']['id']) : $item['image']['url'];
                            ?>
                            <div class="srvs_dv">
                                <img src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_attr($image_alt); ?>">
                                    <h2 class="srvs_heading"><?php echo esc_html($item['title_1']); ?></h2>
                                    <div class="srvs_details">
                                        <h3><?php echo esc_html($item['title_1']); ?></h3>
                                        <p><?php echo heacool_kses_intermediate($item['content']); ?></p>
                                        <?php if (!empty($item['action_link']['url'])) { ?>
                                            <a href="<?php echo esc_url($item['action_link']['url']); ?>" title="" class="play_icon"><i class="fa fa-play-circle"></i></a>
                                                <?php
                                            }
                                            ?>
                                    </div>
                            </div><!--srvs_dv end-->
                            <?php
                        }
                    }
                    ?>
                </div><!--srvs_slider end-->
            </div><!--choose_services_sec end-->
        </section>

        <?php
    }

}
