<?php

namespace HeacoolAddons\Widgets;

if (!defined('ABSPATH')) {
    exit;
}

use Elementor\Widget_Base;

class Elec_Services_Icons extends Widget_Base {

    public function get_name() {
        return 'elec_adds_services';
    }

    public function get_title() {
        return __('Services Icons', 'heacool-core');
    }

    public function get_icon() {
        return 'eicon-banner';
    }

    public function get_categories() {
        return ['heacool'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'content_section', [
                'label' => __('Content', 'heacool-core'),
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'svg_text', [
                'label' => __('SVG Text', 'heacool-core'),
                'description' => __('If Not Use SVG Icons', 'heacool-core'),
                'label_block' => true,
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Type your title here', 'heacool-core'),
            ]
        );

        $repeater->add_control(
            'svg_icons',
            [
                'label' => __('SVG Icons', 'text-domain'),
                'description' => __('If Not Use SVG Text', 'heacool-core'),
                'type' => \Elementor\Controls_Manager::ICONS,

            ]
        );

        $repeater->add_control(
            'title_1', [
                'label' => __('Title', 'heacool-core'),
                'label_block' => true,
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Type your title here', 'heacool-core'),
            ]
        );
        $repeater->add_control(
            'title_2', [
                'label' => __('Content', 'heacool-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Type your title here', 'heacool-core'),
            ]
        );

        $this->add_control(
            'item_list', [
                'label' => __('Item List', 'heacool-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'title_1' => __('Certified Dealer', 'heacool-core'),
                        'title_2' => __('Whether you are looking for quality service our company has you covered.', 'heacool-core'),
                    ],
                    [
                        'title_1' => __('Certified Dealer', 'heacool-core'),
                        'title_2' => __('Whether you are looking for quality service our company has you covered.', 'heacool-core'),
                    ],
                    [
                        'title_1' => __('Certified Dealer', 'heacool-core'),
                        'title_2' => __('Whether you are looking for quality service our company has you covered.', 'heacool-core'),
                    ],
                ],
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
<section class="serices_sec">
  <div class="container">
    <div class="service_sec_details">
      <div class="row">
        <?php
if (!empty($settings['item_list'])) {
            foreach ($settings['item_list'] as $item) {
                ?>
        <div class="col-lg-4 col-md-4 col-sm-4 col-xs-6 hlf-wdth full_wdth">
          <div class="service_details">
            <?php //echo $item['icon']['value']['url']; ?>
            <div class="svc_img">
              <span class="svg_icon">
                <?php
if (!empty($item['svg_text'])) {
                    echo $item['svg_text'];
                } else {
                    if (!empty($item['svg_icons']['value']['url'])) {
                        $image_url = $item['svg_icons']['value']['url'];
                        echo '<img class="serices_sec_svg" width="35px" height="35" style="margin-bottom: 25px;" src="' . $image_url . '">';
                    }
                }
                ?>
              </span>
            </div>
            <div class="svss_info">
              <h3><?php echo wp_kses_post($item['title_1']); ?></h3>
              <p><?php echo wp_kses_post($item['title_2']); ?></p>
            </div>
          </div>
          <!--service_details end-->
        </div>
        <?php
}
        }
        ?>
      </div>
    </div>
    <!--service_sec_details end-->
  </div>
</section>
<!--serices_sec end-->
<!-- End statements -->
<?php
}
}