<?php

namespace HeacoolAddons\Widgets;

if (!defined('ABSPATH')) {
    exit;
}

use Elementor\Widget_Base;

class Elec_Price_table_2 extends Widget_Base {

    public function get_name() {
        return 'elec_price_table_2';
    }

    public function get_title() {
        return __('Price Table 2', 'heacool-core');
    }

    public function get_icon() {
        return 'eicon-banner';
    }

    public function get_categories() {
        return ['heacool'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
                'title_section', [
            'label' => __('Content', 'heacool-core'),
                ]
        );

        $this->add_control(
                'title_1', [
            'label' => __('Title 1', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('Fees and Repair Costs', 'heacool-core'),
                ]
        );

        $this->add_control(
                'title_2', [
            'label' => __('Title 2', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('Our Prices Table', 'heacool-core'),
                ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
                'table_1_section', [
            'label' => __('Tab One', 'heacool-core'),
                ]
        );

        $this->add_control(
                'tab_name_1', [
            'label' => __('Tab Name', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('Cooling Services', 'heacool-core'),
                ]
        );
        $this->add_control(
                'tab_title_1', [
            'label' => __('Title 1', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('Common HVAC Repair Costs for Furnaces and Cooling Systems', 'heacool-core'),
                ]
        );

        $this->add_control(
                'tab_title_2', [
            'label' => __('Content', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'default' => __('Furnaces are complex mechanical systems, and there are a number of sensitive components that may fail or malfunction, causing the need for repairs. On average, homeowners pay about $300 for a furnace repair. Below are average HVAC repair costs for furnaces and heating systems:', 'heacool-core'),
                ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
                'title_1', [
            'label' => __('Title', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'placeholder' => __('Type your title here', 'heacool-core'),
                ]
        );

        $repeater->add_control(
                'price', [
            'label' => __('Price', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT
                ]
        );

        $this->add_control(
                'item_list', [
            'label' => __('Item List', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'title_1' => __('Repair blower motor', 'heacool-core'),
                    'price' => __('$150.00', 'heacool-core'),
                ],
                [
                    'title_1' => __('Repair blower motor', 'heacool-core'),
                    'price' => __('$450.00', 'heacool-core'),
                ],
                [
                    'title_1' => __('Thermostat replacement', 'heacool-core'),
                    'price' => __('$50.00 to $200.00+', 'heacool-core'),
                ],
                [
                    'title_1' => __('Replace ignitor', 'heacool-core'),
                    'price' => __('$300.00 to $400.00', 'heacool-core'),
                ],
                [
                    'title_1' => __('Repair flame sensor', 'heacool-core'),
                    'price' => __('$80.00', 'heacool-core'),
                ],
                [
                    'title_1' => __('Repair flame sensor', 'heacool-core'),
                    'price' => __('$250.00', 'heacool-core'),
                ],
                [
                    'title_1' => __('Repair heat exchanger', 'heacool-core'),
                    'price' => __('$100.00', 'heacool-core'),
                ],
                [
                    'title_1' => __('Replace heat exchanger', 'heacool-core'),
                    'price' => __('$500.00 to $1,200.00', 'heacool-core'),
                ],
                [
                    'title_1' => __('Repair pressure sensor/circuit board', 'heacool-core'),
                    'price' => __('$50.00', 'heacool-core'),
                ],
                [
                    'title_1' => __('Replace pressure sensor/circuit board', 'heacool-core'),
                    'price' => __('$350.00', 'heacool-core'),
                ],
                [
                    'title_1' => __('Replace gas valve', 'heacool-core'),
                    'price' => __('$150.00', 'heacool-core'),
                ],
                [
                    'title_1' => __('Replace smart valve', 'heacool-core'),
                    'price' => __('$750.00', 'heacool-core'),
                ],
                [
                    'title_1' => __('Replace draft inducer', 'heacool-core'),
                    'price' => __('$150.00 to $450.00', 'heacool-core'),
                ],
            ]
                ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
                'table_2_section', [
            'label' => __('Tab Two', 'heacool-core'),
                ]
        );

        $this->add_control(
                'tab_name_2', [
            'label' => __('Tab Name', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('Heating Services', 'heacool-core'),
                ]
        );

        $this->add_control(
                'tab_title_3', [
            'label' => __('Title 1', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('Common HVAC Repair Costs for Furnaces and Cooling Systems', 'heacool-core'),
                ]
        );

        $this->add_control(
                'tab_title_4', [
            'label' => __('Content', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'default' => __('Furnaces are complex mechanical systems, and there are a number of sensitive components that may fail or malfunction, causing the need for repairs. On average, homeowners pay about $300 for a furnace repair. Below are average HVAC repair costs for furnaces and heating systems:', 'heacool-core'),
                ]
        );


        $repeater_1 = new \Elementor\Repeater();

        $repeater_1->add_control(
                'title_1', [
            'label' => __('Title', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'placeholder' => __('Type your title here', 'heacool-core'),
                ]
        );

        $repeater_1->add_control(
                'price', [
            'label' => __('Price', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT
                ]
        );

        $this->add_control(
                'item_list_1', [
            'label' => __('Item List', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'title_1' => __('Repair blower motor', 'heacool-core'),
                    'price' => __('$150.00', 'heacool-core'),
                ],
                [
                    'title_1' => __('Repair blower motor', 'heacool-core'),
                    'price' => __('$450.00', 'heacool-core'),
                ],
                [
                    'title_1' => __('Thermostat replacement', 'heacool-core'),
                    'price' => __('$50.00 to $200.00+', 'heacool-core'),
                ],
                [
                    'title_1' => __('Replace ignitor', 'heacool-core'),
                    'price' => __('$300.00 to $400.00', 'heacool-core'),
                ],
                [
                    'title_1' => __('Repair flame sensor', 'heacool-core'),
                    'price' => __('$80.00', 'heacool-core'),
                ],
                [
                    'title_1' => __('Repair flame sensor', 'heacool-core'),
                    'price' => __('$250.00', 'heacool-core'),
                ],
                [
                    'title_1' => __('Repair heat exchanger', 'heacool-core'),
                    'price' => __('$100.00', 'heacool-core'),
                ],
                [
                    'title_1' => __('Replace heat exchanger', 'heacool-core'),
                    'price' => __('$500.00 to $1,200.00', 'heacool-core'),
                ],
                [
                    'title_1' => __('Repair pressure sensor/circuit board', 'heacool-core'),
                    'price' => __('$50.00', 'heacool-core'),
                ],
                [
                    'title_1' => __('Replace pressure sensor/circuit board', 'heacool-core'),
                    'price' => __('$350.00', 'heacool-core'),
                ],
                [
                    'title_1' => __('Replace gas valve', 'heacool-core'),
                    'price' => __('$150.00', 'heacool-core'),
                ],
                [
                    'title_1' => __('Replace smart valve', 'heacool-core'),
                    'price' => __('$750.00', 'heacool-core'),
                ],
                [
                    'title_1' => __('Replace draft inducer', 'heacool-core'),
                    'price' => __('$150.00 to $450.00', 'heacool-core'),
                ],
            ]
                ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
        <section class="block less-top-gap price-sec">
            <div class="container">
                <div class="sec-title">
                    <h4><?php
                        echo wp_kses_post($settings['title_1']);
                        ?></h4>
                    <h2><?php
                        echo wp_kses_post($settings['title_2']);
                        ?></h2>
                </div><!--sec-title end-->
                <ul class="tabs_list">
                    <li class="active" data-tab="price-coolling">
                        <span class="tc_icon">
                            <svg version="1.1" id="Capa_1491" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                                 viewBox="0 0 333.316 333.316"  xml:space="preserve">
                                <path d="M315.797,224.574l-5.557-20.818l-39.684,10.592l-33.572-19.441l41.764-18.377v-19.75l-41.767-18.377l33.572-19.439
                                      l39.689,10.59l5.557-20.818l-18.861-5.025l19.361-11.197l-10.82-18.645l-19.324,11.188l5.029-18.855l-20.818-5.551l-10.588,39.674
                                      l-33.473,19.338l4.918-45.148l-17.061-9.877l-36.758,26.892V52.824l29.045-29.018L191.221,8.539l-13.816,13.807V0h-21.531v22.346
                                      L142.064,8.539l-15.236,15.268l29.045,29.018v38.703l-36.756-26.892l-17.061,9.877l4.924,45.148l-33.477-19.336l-10.59-39.676
                                      l-20.816,5.553l5.027,18.854l-19.32-11.188L17.018,92.512l19.322,11.197l-18.857,5.025l5.557,20.818l39.684-10.59l33.576,19.439
                                      l-41.771,18.377v19.75l41.768,18.377l-33.576,19.441l-39.678-10.592l-5.557,20.818l18.853,5.025l-19.32,11.195l10.787,18.652
                                      l19.318-11.18l-5.029,18.84l20.818,5.559l10.59-39.682l33.479-19.338l-4.924,45.15l17.061,9.879l36.756-26.893V280.5l-29.045,29.004
                                      l15.236,15.266l13.809-13.805v22.352h21.531v-22.352l13.816,13.805l15.229-15.266L177.404,280.5v-38.717l36.758,26.893l17.061-9.879
                                      l-4.92-45.15l33.475,19.338l10.59,39.682l20.818-5.559l-5.029-18.838l19.322,11.178l10.82-18.652l-19.361-11.193L315.797,224.574z
                                      M247.668,166.654l-33.779,14.885l-25.75-14.887l25.746-14.877L247.668,166.654z M207.148,96.471l-3.975,36.578l-25.77,14.93
                                      v-29.721L207.148,96.471z M126.129,96.471l29.744,21.787v29.721l-25.771-14.93L126.129,96.471z M85.609,166.654l33.783-14.879
                                      l25.748,14.877l-25.752,14.887L85.609,166.654z M126.129,236.84l3.973-36.582l25.771-14.924v29.717L126.129,236.84z M207.148,236.84
                                      l-29.744-21.789v-29.717l25.77,14.924L207.148,236.84z"/>
                            </svg>
                        </span>
                        <span class="svs"> <?php
                                            echo esc_html($settings['tab_name_1']);
                                            ?></span>
                    </li>
                    <li data-tab="price-heating" class="heating">
                        <span class="svs"><?php
                                            echo esc_html($settings['tab_name_2']);
                                            ?></span>
                        <span class="tc_icon">
                            <svg version="1.1" id="Capa_12" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                                 width="45.16px" height="45.16px" viewBox="0 0 45.16 45.16"  xml:space="preserve"
                                 >
                                <g>
                                    <g>
                                        <path d="M22.58,11.269c-6.237,0-11.311,5.075-11.311,11.312s5.074,11.312,11.311,11.312c6.236,0,11.311-5.074,11.311-11.312
                                              S28.816,11.269,22.58,11.269z"/>
                                        <g>
                                            <g>
                                                <path d="M22.58,7.944c-1.219,0-2.207-0.988-2.207-2.206V2.207C20.373,0.988,21.361,0,22.58,0c1.219,0,2.207,0.988,2.207,2.207
                                                      v3.531C24.787,6.956,23.798,7.944,22.58,7.944z"/>
                                            </g>
                                            <g>
                                                <path d="M22.58,37.215c-1.219,0-2.207,0.988-2.207,2.207v3.53c0,1.22,0.988,2.208,2.207,2.208c1.219,0,2.207-0.988,2.207-2.208
                                                      v-3.53C24.787,38.203,23.798,37.215,22.58,37.215z"/>
                                            </g>
                                            <g>
                                                <path d="M32.928,12.231c-0.861-0.862-0.861-2.259,0-3.121l2.497-2.497c0.861-0.861,2.259-0.861,3.121,0
                                                      c0.862,0.862,0.862,2.26,0,3.121l-2.497,2.497C35.188,13.093,33.791,13.093,32.928,12.231z"/>
                                            </g>
                                            <g>
                                                <path d="M12.231,32.93c-0.862-0.863-2.259-0.863-3.121,0l-2.497,2.496c-0.861,0.861-0.862,2.26,0,3.121
                                                      c0.862,0.861,2.26,0.861,3.121,0l2.497-2.498C13.093,35.188,13.093,33.79,12.231,32.93z"/>
                                            </g>
                                            <g>
                                                <path d="M37.215,22.58c0-1.219,0.988-2.207,2.207-2.207h3.531c1.219,0,2.207,0.988,2.207,2.207c0,1.219-0.988,2.206-2.207,2.206
                                                      h-3.531C38.203,24.786,37.215,23.799,37.215,22.58z"/>
                                            </g>
                                            <g>
                                                <path d="M7.944,22.58c0-1.219-0.988-2.207-2.207-2.207h-3.53C0.988,20.373,0,21.361,0,22.58c0,1.219,0.988,2.206,2.207,2.206
                                                      h3.531C6.956,24.786,7.944,23.799,7.944,22.58z"/>
                                            </g>
                                            <g>
                                                <path d="M32.928,32.93c0.862-0.861,2.26-0.861,3.121,0l2.497,2.497c0.862,0.86,0.862,2.259,0,3.12s-2.259,0.861-3.121,0
                                                      l-2.497-2.497C32.066,35.188,32.066,33.791,32.928,32.93z"/>
                                            </g>
                                            <g>
                                                <path d="M12.231,12.231c0.862-0.862,0.862-2.259,0-3.121L9.734,6.614c-0.862-0.862-2.259-0.862-3.121,0
                                                      c-0.862,0.861-0.862,2.259,0,3.12l2.497,2.497C9.972,13.094,11.369,13.094,12.231,12.231z"/>
                                            </g>
                                        </g>
                                    </g>
                                </g>
                            </svg>
                        </span>
                    </li>
                </ul><!--tabs_list end-->

                <div class="price_sec_text active" id="price-coolling">
                    <h3> <?php
                        echo wp_kses_post($settings['tab_title_1']);
                        ?></h3>
                    <p> <?php
                        echo wp_kses_post($settings['tab_title_2']);
                        ?></p>
                    <table>
                        <thead>
                            <tr>
                                <th><?php echo esc_html__('Service', 'heacool-core') ?></th>
                                <th><?php echo esc_html__('Price', 'heacool-core') ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            if (!empty($settings['item_list'])) {
                                foreach ($settings['item_list'] as $item) {
                                    ?>
                                    <tr>
                                        <td>
                                            <?php
                                            echo esc_html($item['title_1']);
                                            ?>
                                        </td>
                                        <td>
                                            <?php
                                            echo wp_kses_post($item['price']);
                                            ?>
                                        </td>
                                    </tr>
                                    <?php
                                }
                            }
                            ?>
                        </tbody>
                    </table>
                </div><!--price_sec_text end-->
                <div class="price_sec_text" id="price-heating">
                    <h3>
                        <?php
                        echo wp_kses_post($settings['tab_title_3']);
                        ?>
                    </h3>
                    <p>
                        <?php
                        echo wp_kses_post($settings['tab_title_4']);
                        ?>
                    </p> 
                    <table>
                        <thead>
                            <tr>
                                <th><?php echo esc_html__('Service', 'heacool-core') ?></th>
                                <th><?php echo esc_html__('Price', 'heacool-core') ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            if (!empty($settings['item_list_1'])) {
                                foreach ($settings['item_list_1'] as $item) {
                                    ?>
                                    <tr>
                                        <td>
                                            <?php
                                            echo esc_html($item['title_1']);
                                            ?>
                                        </td>
                                        <td>
                                            <?php
                                            echo wp_kses_post($item['price']);
                                            ?>
                                        </td>
                                    </tr>
                                    <?php
                                }
                            }
                            ?>
                        </tbody>
                    </table>
                </div><!--price_sec_text end-->
            </div>
        </section>
        <?php
    }

}
