<?php

namespace HeacoolAddons\Widgets;

if (!defined('ABSPATH')) {
    exit;
}

use Elementor\Widget_Base;

class Elec_Our_Services extends Widget_Base {

    public function get_name() {
        return 'elec_our_services';
    }

    public function get_title() {
        return __('Our Services', 'heacool-core');
    }

    public function get_icon() {
        return 'eicon-banner';
    }

    public function get_categories() {
        return ['heacool'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'content_section', [
                'label' => __('Content', 'heacool-core'),
            ]
        );
        $this->add_control(
            'title_1', [
                'label' => __('Title 1', 'heacool-core'),
                'label_block' => true,
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Our <b>Services</b>', 'heacool-core'),
                'placeholder' => __('Type your title here', 'heacool-core'),
            ]
        );

        $this->add_control(
            'phone', [
                'label' => __('Phone', 'heacool-core'),
                'label_block' => true,
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('1 (800) 765-43-21', 'heacool-core'),
            ]
        );

        $this->add_control(
            'title_2', [
                'label' => __('Title 2', 'heacool-core'),
                'label_block' => true,
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Never hesitate when it comes to potential electrical problems. Electrical issues can quickly develop into major catastrophes.', 'heacool-core'),
                'placeholder' => __('Type your title here', 'heacool-core'),
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'icon', [
                'label' => __('Icon', 'heacool-core'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => array(
                    'value' => 'icon-light',
                ),
            ]
        );

        $repeater->add_control(
            'title_1', [
                'label' => __('Title', 'heacool-core'),
                'label_block' => true,
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Type your title here', 'heacool-core'),
            ]
        );

        $repeater->add_control(
            'title_2', [
                'label' => __('Content', 'heacool-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Type your title here', 'heacool-core'),
            ]
        );

        $this->add_control(
            'item_list', [
                'label' => __('Item List', 'heacool-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'title_1' => __('Electrical', 'heacool-core'),
                        'title_2' => __('Wiring, Remodels and Additions, Heat detectors', 'heacool-core'),
                    ],
                    [
                        'title_1' => __('Heating', 'heacool-core'),
                        'title_2' => __('Trust our professionals to listen to your needs and problems', 'heacool-core'),
                    ],
                    [
                        'title_1' => __('Air Conditioning', 'heacool-core'),
                        'title_2' => __('Then present you with options that fit your budget and designs', 'heacool-core'),
                    ],
                    [
                        'title_1' => __('Security Systems', 'heacool-core'),
                        'title_2' => __('You can view events over a monitor in our home', 'heacool-core'),
                    ],
                    [
                        'title_1' => __('Panels Changes', 'heacool-core'),
                        'title_2' => __('IPrices that meet your needs and budget', 'heacool-core'),
                    ],
                    [
                        'title_1' => __('Trouble Shooting', 'heacool-core'),
                        'title_2' => __('We think before we start working to save you money', 'heacool-core'),
                    ],
                ],
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
<!-- Services Block -->
<div class="block bottom-sm">
  <div class="container">
    <h2 class="text-center"><?php
echo wp_kses_post($settings['title_1']);
        ?>
    </h2>
    <?php if (!empty($settings['phone'])) {?>
    <h4 class="text-center subtitle"><i class="icon icon-telephone"></i><?php echo wp_kses_post($settings['phone']); ?>
    </h4>
    <?php }
        ?>
    <p class="font24 text-center">
      <?php
echo wp_kses_post($settings['title_2']);
        ?>
    </p>
    <div class="row text-icon-grid">
      <?php
if (!empty($settings['item_list'])) {
            foreach ($settings['item_list'] as $item) {
                ?>
      <div class="col-sm-6 col-md-4">
        <div class="text-icon">
          <div class="text-icon-icon"><span><i class="icon <?php echo $item['icon']['value']; ?>"></i><span
                class="icon-hover"></span></span>
          </div>
          <h5 class="text-icon-title"><?php echo wp_kses_post($item['title_1']); ?></h5>
          <div class="text-icon-text"><?php echo wp_kses_post($item['title_2']); ?></div>
        </div>
      </div>
      <?php
}
        }
        ?>
    </div>
  </div>
</div>
<!-- //Services Block -->
<?php
}
}