<?php

namespace HeacoolAddons\Widgets;

if (!defined('ABSPATH')) {
    exit;
}

use Elementor\Widget_Base;

class Elec_our_Coupons extends Widget_Base {

    public function get_name() {
        return 'elec-our-couponss';
    }

    public function get_title() {
        return __('Coupons', 'heacool-core');
    }

    public function get_icon() {
        return 'eicon-banner';
    }

    public function get_categories() {
        return ['heacool'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
                'content_section', [
            'label' => __('First Tab', 'heacool-core'),
                ]
        );

        $this->add_control(
                'tab_title', [
            'label' => __('Tab Title', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => 'Cooling Services',
            'placeholder' => __('Type your title here', 'heacool-core'),
                ]
        );
        $this->add_control(
            'limage', [
            'label' => __('Left service Icon', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::MEDIA,
            
                ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
                'price', [
            'label' => __('Price', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'placeholder' => __('Type your title here', 'heacool-core'),
                ]
        );

        $repeater->add_control(
                'title', [
            'label' => __('Title', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'placeholder' => __('Type your title here', 'heacool-core'),
                ]
        );

        $repeater->add_control(
                'content', [
            'label' => __('Content', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'placeholder' => __('Type your title here', 'heacool-core'),
                ]
        );

        $repeater->add_control(
                'validity', [
            'label' => __('Validity', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('Valid Through 12/31/2020', 'heacool-core')
                ]
        );
        
        $this->add_control(
                'item_list', [
            'label' => __('Item List', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'price' => __('<small>$</small>25 OFF', 'heacool-core'),
                    'title' => __('Any Repair', 'heacool-core'),
                    'content' => __('Must present coupon at time of repair, cannot be combined with any other offer.', 'heacool-core'),
                ],
                [
                    'price' => __('<small>$</small>25 OFF', 'heacool-core'),
                    'title' => __('Any Repair', 'heacool-core'),
                    'content' => __('Must present coupon at time of repair, cannot be combined with any other offer.', 'heacool-core'),
                ],
                [
                    'price' => __('<small>$</small>25 OFF', 'heacool-core'),
                    'title' => __('Any Repair', 'heacool-core'),
                    'content' => __('Must present coupon at time of repair, cannot be combined with any other offer.', 'heacool-core'),
                ],
                [
                    'price' => __('<small>$</small>25 OFF', 'heacool-core'),
                    'title' => __('Any Repair', 'heacool-core'),
                    'content' => __('Must present coupon at time of repair, cannot be combined with any other offer.', 'heacool-core'),
                ],
                [
                    'price' => __('<small>$</small>25 OFF', 'heacool-core'),
                    'title' => __('Any Repair', 'heacool-core'),
                    'content' => __('Must present coupon at time of repair, cannot be combined with any other offer.', 'heacool-core'),
                ],
                [
                    'price' => __('<small>$</small>25 OFF', 'heacool-core'),
                    'title' => __('Any Repair', 'heacool-core'),
                    'content' => __('Must present coupon at time of repair, cannot be combined with any other offer.', 'heacool-core'),
                ],
            ]
                ]
        );
        $this->end_controls_section();


        $this->start_controls_section(
                'content_section_1', [
            'label' => __('Second Tab', 'heacool-core'),
                ]
        );

        $this->add_control(
                'tab_title_1', [
            'label' => __('Tab Title', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => 'Cooling Services',
            'placeholder' => __('Type your title here', 'heacool-core'),
                ]
        );
        $this->add_control(
            'rimage', [
            'label' => __('Right service Icon', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::MEDIA,
                ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
                'price', [
            'label' => __('Price', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'placeholder' => __('Type your title here', 'heacool-core'),
                ]
        );

        $repeater->add_control(
                'title', [
            'label' => __('Title', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'placeholder' => __('Type your title here', 'heacool-core'),
                ]
        );

        $repeater->add_control(
                'content', [
            'label' => __('Content', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'placeholder' => __('Type your title here', 'heacool-core'),
                ]
        );
        $repeater->add_control(
                'validity', [
            'label' => __('Validity', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('Valid Through 12/31/2020', 'heacool-core')
                ]
        );

        $this->add_control(
                'item_list_1', [
            'label' => __('Item List', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'price' => __('<small>$</small>25 OFF', 'heacool-core'),
                    'title' => __('Any Repair', 'heacool-core'),
                    'content' => __('Must present coupon at time of repair, cannot be combined with any other offer.', 'heacool-core'),
                ],
                [
                    'price' => __('<small>$</small>25 OFF', 'heacool-core'),
                    'title' => __('Any Repair', 'heacool-core'),
                    'content' => __('Must present coupon at time of repair, cannot be combined with any other offer.', 'heacool-core'),
                ],
                [
                    'price' => __('<small>$</small>25 OFF', 'heacool-core'),
                    'title' => __('Any Repair', 'heacool-core'),
                    'content' => __('Must present coupon at time of repair, cannot be combined with any other offer.', 'heacool-core'),
                ],
                [
                    'price' => __('<small>$</small>25 OFF', 'heacool-core'),
                    'title' => __('Any Repair', 'heacool-core'),
                    'content' => __('Must present coupon at time of repair, cannot be combined with any other offer.', 'heacool-core'),
                ],
                [
                    'price' => __('<small>$</small>25 OFF', 'heacool-core'),
                    'title' => __('Any Repair', 'heacool-core'),
                    'content' => __('Must present coupon at time of repair, cannot be combined with any other offer.', 'heacool-core'),
                ],
                [
                    'price' => __('<small>$</small>25 OFF', 'heacool-core'),
                    'title' => __('Any Repair', 'heacool-core'),
                    'content' => __('Must present coupon at time of repair, cannot be combined with any other offer.', 'heacool-core'),
                ],
            ]
                ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
        <ul class="tbs-list">
            <li class="active" data-tab="cooling_services">
                <span class="vx-icon">
                <?php
                if (!empty($settings['limage']['url'])){
                    echo '<img src="' . $settings['limage']['url'] . '">';
                }else{ 
                ?>
                
                    <svg version="1.1" id="Capa_5" x="0px" y="0px" viewBox="0 0 333.316 333.316" xml:space="preserve">
                    <path d="M315.797,224.574l-5.557-20.818l-39.684,10.592l-33.572-19.441l41.764-18.377v-19.75l-41.767-18.377l33.572-19.439
                                                                l39.689,10.59l5.557-20.818l-18.861-5.025l19.361-11.197l-10.82-18.645l-19.324,11.188l5.029-18.855l-20.818-5.551l-10.588,39.674
                                                                l-33.473,19.338l4.918-45.148l-17.061-9.877l-36.758,26.892V52.824l29.045-29.018L191.221,8.539l-13.816,13.807V0h-21.531v22.346
                                                                L142.064,8.539l-15.236,15.268l29.045,29.018v38.703l-36.756-26.892l-17.061,9.877l4.924,45.148l-33.477-19.336l-10.59-39.676
                                                                l-20.816,5.553l5.027,18.854l-19.32-11.188L17.018,92.512l19.322,11.197l-18.857,5.025l5.557,20.818l39.684-10.59l33.576,19.439
                                                                l-41.771,18.377v19.75l41.768,18.377l-33.576,19.441l-39.678-10.592l-5.557,20.818l18.853,5.025l-19.32,11.195l10.787,18.652
                                                                l19.318-11.18l-5.029,18.84l20.818,5.559l10.59-39.682l33.479-19.338l-4.924,45.15l17.061,9.879l36.756-26.893V280.5l-29.045,29.004
                                                                l15.236,15.266l13.809-13.805v22.352h21.531v-22.352l13.816,13.805l15.229-15.266L177.404,280.5v-38.717l36.758,26.893l17.061-9.879
                                                                l-4.92-45.15l33.475,19.338l10.59,39.682l20.818-5.559l-5.029-18.838l19.322,11.178l10.82-18.652l-19.361-11.193L315.797,224.574z
                                                                M247.668,166.654l-33.779,14.885l-25.75-14.887l25.746-14.877L247.668,166.654z M207.148,96.471l-3.975,36.578l-25.77,14.93
                                                                v-29.721L207.148,96.471z M126.129,96.471l29.744,21.787v29.721l-25.771-14.93L126.129,96.471z M85.609,166.654l33.783-14.879
                                                                l25.748,14.877l-25.752,14.887L85.609,166.654z M126.129,236.84l3.973-36.582l25.771-14.924v29.717L126.129,236.84z M207.148,236.84
                                                                l-29.744-21.789v-29.717l25.77,14.924L207.148,236.84z" />
                    </svg> 
                <?php } ?>
                </span>
                <?php
                echo wp_kses_post($settings['tab_title']);
                ?>
            </li>
            <li data-tab="heating_services" class="heating">
                <span class="vx-icon">
                <?php
                if (!empty($settings['rimage']['url'])){
                    echo '<img src="' . $settings['rimage']['url'] . '">';
                }else{
                ?>
                    <svg version="1.1" id="Capa_18834" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                         width="45.16px" height="45.16px" viewBox="0 0 45.16 45.16" xml:space="preserve"
                         >
                        <g>
                            <g>
                                <path d="M22.58,11.269c-6.237,0-11.311,5.075-11.311,11.312s5.074,11.312,11.311,11.312c6.236,0,11.311-5.074,11.311-11.312
                                      S28.816,11.269,22.58,11.269z"/>
                                <g>
                                    <g>
                                        <path d="M22.58,7.944c-1.219,0-2.207-0.988-2.207-2.206V2.207C20.373,0.988,21.361,0,22.58,0c1.219,0,2.207,0.988,2.207,2.207
                                              v3.531C24.787,6.956,23.798,7.944,22.58,7.944z"/>
                                    </g>
                                    <g>
                                        <path d="M22.58,37.215c-1.219,0-2.207,0.988-2.207,2.207v3.53c0,1.22,0.988,2.208,2.207,2.208c1.219,0,2.207-0.988,2.207-2.208
                                              v-3.53C24.787,38.203,23.798,37.215,22.58,37.215z"/>
                                    </g>
                                    <g>
                                        <path d="M32.928,12.231c-0.861-0.862-0.861-2.259,0-3.121l2.497-2.497c0.861-0.861,2.259-0.861,3.121,0
                                              c0.862,0.862,0.862,2.26,0,3.121l-2.497,2.497C35.188,13.093,33.791,13.093,32.928,12.231z"/>
                                    </g>
                                    <g>
                                        <path d="M12.231,32.93c-0.862-0.863-2.259-0.863-3.121,0l-2.497,2.496c-0.861,0.861-0.862,2.26,0,3.121
                                              c0.862,0.861,2.26,0.861,3.121,0l2.497-2.498C13.093,35.188,13.093,33.79,12.231,32.93z"/>
                                    </g>
                                    <g>
                                        <path d="M37.215,22.58c0-1.219,0.988-2.207,2.207-2.207h3.531c1.219,0,2.207,0.988,2.207,2.207c0,1.219-0.988,2.206-2.207,2.206
                                              h-3.531C38.203,24.786,37.215,23.799,37.215,22.58z"/>
                                    </g>
                                    <g>
                                        <path d="M7.944,22.58c0-1.219-0.988-2.207-2.207-2.207h-3.53C0.988,20.373,0,21.361,0,22.58c0,1.219,0.988,2.206,2.207,2.206
                                              h3.531C6.956,24.786,7.944,23.799,7.944,22.58z"/>
                                    </g>
                                    <g>
                                        <path d="M32.928,32.93c0.862-0.861,2.26-0.861,3.121,0l2.497,2.497c0.862,0.86,0.862,2.259,0,3.12s-2.259,0.861-3.121,0
                                              l-2.497-2.497C32.066,35.188,32.066,33.791,32.928,32.93z"/>
                                    </g>
                                    <g>
                                        <path d="M12.231,12.231c0.862-0.862,0.862-2.259,0-3.121L9.734,6.614c-0.862-0.862-2.259-0.862-3.121,0
                                              c-0.862,0.861-0.862,2.259,0,3.12l2.497,2.497C9.972,13.094,11.369,13.094,12.231,12.231z"/>
                                    </g>
                                </g>
                            </g>
                        </g>
                    </svg>
                    <?php } ?>
                </span>
                <?php
                echo wp_kses_post($settings['tab_title_1']);
                ?>
            </li>
        </ul><!--tbs-list end-->
        <div class="tbb_content">

            <div class="tb-details active" id="cooling_services">
                <div class="row">
                    <?php
                    if (!empty($settings['item_list'])) {
                        foreach ($settings['item_list'] as $key => $item) {
                            ?>
                            <div class="col-lg-4 col-md-4 col-sm-6 col-xs-6 full_wdth">
                                <div class="tb-info">
                                    <h3><?php echo wp_kses_post($item['price']); ?></h3>
                                    <h2><?php echo wp_kses_post($item['title']); ?></h2>
                                    <p><?php echo wp_kses_post($item['content']); ?></p>
                                    <div class="validity">
                                        <h5><?php echo wp_kses_post($item['validity']); ?></h5>
                                        <span class="zz_icon">
                                            <svg version="1.1" id="cooling_services_cop_<?php echo $key; ?>" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                                                 width="475.078px" height="475.077px" viewBox="0 0 475.078 475.077" xml:space="preserve">
                                                <g>
                                                    <path d="M458.959,217.124c-10.759-10.758-23.654-16.134-38.69-16.134h-18.268v-73.089c0-7.611-1.91-15.99-5.719-25.122
                                                          c-3.806-9.136-8.371-16.368-13.699-21.698L339.18,37.683c-5.328-5.325-12.56-9.895-21.692-13.704
                                                          c-9.138-3.805-17.508-5.708-25.126-5.708H100.5c-7.614,0-14.087,2.663-19.417,7.993c-5.327,5.327-7.994,11.799-7.994,19.414V200.99
                                                          H54.818c-15.037,0-27.932,5.379-38.688,16.134C5.376,227.876,0,240.772,0,255.81v118.773c0,2.478,0.905,4.609,2.712,6.426
                                                          c1.809,1.804,3.951,2.707,6.423,2.707h63.954v45.68c0,7.617,2.664,14.089,7.994,19.417c5.33,5.325,11.803,7.994,19.417,7.994
                                                          h274.083c7.611,0,14.093-2.669,19.418-7.994c5.328-5.332,7.994-11.8,7.994-19.417v-45.68h63.953c2.471,0,4.613-0.903,6.42-2.707
                                                          c1.807-1.816,2.71-3.948,2.71-6.426V255.81C475.082,240.772,469.708,227.876,458.959,217.124z M365.449,420.262H109.636v-73.087
                                                          h255.813V420.262z M365.449,237.537H109.636V54.816h182.726v45.679c0,7.614,2.669,14.083,7.991,19.414
                                                          c5.328,5.33,11.799,7.993,19.417,7.993h45.679V237.537z M433.116,268.656c-3.614,3.614-7.898,5.428-12.847,5.428
                                                          c-4.949,0-9.233-1.813-12.848-5.428c-3.613-3.61-5.42-7.898-5.42-12.847s1.807-9.232,5.42-12.847
                                                          c3.614-3.617,7.898-5.426,12.848-5.426c4.948,0,9.232,1.809,12.847,5.426c3.613,3.614,5.427,7.898,5.427,12.847
                                                          S436.733,265.046,433.116,268.656z"/>
                                                </g>
                                            </svg>
                                        </span>
                                        <div class="clearfix"></div>
                                    </div>
                                    <span class="bfr-shape">
                                        <svg version="1.1" id="coo_ser_cop_bfr_<?php echo $key; ?>" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                                             viewBox="0 0 512 512" xml:space="preserve">
                                            <g>
                                                <g>
                                                    <path d="M512,107.275c-23.658-33.787-70.696-42.691-104.489-19.033L233.753,209.907l-63.183-44.246
                                                          c23.526-40.618,12.46-93.179-26.71-120.603c-41.364-28.954-98.355-18.906-127.321,22.45
                                                          c-28.953,41.358-18.913,98.361,22.452,127.327c28.384,19.874,64.137,21.364,93.129,6.982l77.388,54.185l-77.381,54.179
                                                          c-28.992-14.375-64.743-12.885-93.129,6.982c-41.363,28.966-51.404,85.963-22.452,127.32
                                                          c28.966,41.363,85.963,51.411,127.32,22.457c39.165-27.424,50.229-79.985,26.71-120.603l63.183-44.246l173.751,121.658
                                                          c33.793,23.665,80.831,14.755,104.489-19.033l-212.41-148.715L512,107.275z M91.627,167.539
                                                          c-26.173,0-47.392-21.219-47.392-47.392s21.22-47.392,47.392-47.392c26.179,0,47.392,21.219,47.392,47.392
                                                          S117.806,167.539,91.627,167.539z M91.627,439.253c-26.173,0-47.392-21.219-47.392-47.392c0-26.173,21.219-47.392,47.392-47.392
                                                          c26.179,0,47.392,21.219,47.392,47.392C139.019,418.033,117.806,439.253,91.627,439.253z"/>
                                                </g>
                                            </g>
                                        </svg>
                                    </span>
                                </div><!--tb-info end-->
                            </div>
                            <?php
                        }
                    }
                    ?>
                </div>
            </div><!--tb-details end-->
            <div class="tb-details" id="heating_services">
                <div class="row">
                    <?php
                    if (!empty($settings['item_list_1'])) {
                        foreach ($settings['item_list_1'] as $key => $item) {
                            ?>
                            <div class="col-lg-4 col-md-4 col-sm-6 col-xs-6 full_wdth">
                                <div class="tb-info">
                                    <h3><?php echo wp_kses_post($item['price']); ?></h3>
                                    <h2><?php echo wp_kses_post($item['title']); ?></h2>
                                    <p><?php echo wp_kses_post($item['content']); ?></p>
                                    <div class="validity">
                                        <h5><?php echo wp_kses_post($item['validity']); ?></h5>
                                        <span class="zz_icon">
                                            <svg version="1.1" id="heating_services_cop_<?php echo $key; ?>" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                                                 width="475.078px" height="475.077px" viewBox="0 0 475.078 475.077" xml:space="preserve">
                                                <g>
                                                    <path d="M458.959,217.124c-10.759-10.758-23.654-16.134-38.69-16.134h-18.268v-73.089c0-7.611-1.91-15.99-5.719-25.122
                                                          c-3.806-9.136-8.371-16.368-13.699-21.698L339.18,37.683c-5.328-5.325-12.56-9.895-21.692-13.704
                                                          c-9.138-3.805-17.508-5.708-25.126-5.708H100.5c-7.614,0-14.087,2.663-19.417,7.993c-5.327,5.327-7.994,11.799-7.994,19.414V200.99
                                                          H54.818c-15.037,0-27.932,5.379-38.688,16.134C5.376,227.876,0,240.772,0,255.81v118.773c0,2.478,0.905,4.609,2.712,6.426
                                                          c1.809,1.804,3.951,2.707,6.423,2.707h63.954v45.68c0,7.617,2.664,14.089,7.994,19.417c5.33,5.325,11.803,7.994,19.417,7.994
                                                          h274.083c7.611,0,14.093-2.669,19.418-7.994c5.328-5.332,7.994-11.8,7.994-19.417v-45.68h63.953c2.471,0,4.613-0.903,6.42-2.707
                                                          c1.807-1.816,2.71-3.948,2.71-6.426V255.81C475.082,240.772,469.708,227.876,458.959,217.124z M365.449,420.262H109.636v-73.087
                                                          h255.813V420.262z M365.449,237.537H109.636V54.816h182.726v45.679c0,7.614,2.669,14.083,7.991,19.414
                                                          c5.328,5.33,11.799,7.993,19.417,7.993h45.679V237.537z M433.116,268.656c-3.614,3.614-7.898,5.428-12.847,5.428
                                                          c-4.949,0-9.233-1.813-12.848-5.428c-3.613-3.61-5.42-7.898-5.42-12.847s1.807-9.232,5.42-12.847
                                                          c3.614-3.617,7.898-5.426,12.848-5.426c4.948,0,9.232,1.809,12.847,5.426c3.613,3.614,5.427,7.898,5.427,12.847
                                                          S436.733,265.046,433.116,268.656z"/>
                                                </g>
                                            </svg>
                                        </span>
                                        <div class="clearfix"></div>
                                    </div>
                                    <span class="bfr-shape">
                                        <svg version="1.1" id="heating_services_cop_bfr-shape_<?php echo $key; ?>" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                                             viewBox="0 0 512 512" xml:space="preserve">
                                            <g>
                                                <g>
                                                    <path d="M512,107.275c-23.658-33.787-70.696-42.691-104.489-19.033L233.753,209.907l-63.183-44.246
                                                          c23.526-40.618,12.46-93.179-26.71-120.603c-41.364-28.954-98.355-18.906-127.321,22.45
                                                          c-28.953,41.358-18.913,98.361,22.452,127.327c28.384,19.874,64.137,21.364,93.129,6.982l77.388,54.185l-77.381,54.179
                                                          c-28.992-14.375-64.743-12.885-93.129,6.982c-41.363,28.966-51.404,85.963-22.452,127.32
                                                          c28.966,41.363,85.963,51.411,127.32,22.457c39.165-27.424,50.229-79.985,26.71-120.603l63.183-44.246l173.751,121.658
                                                          c33.793,23.665,80.831,14.755,104.489-19.033l-212.41-148.715L512,107.275z M91.627,167.539
                                                          c-26.173,0-47.392-21.219-47.392-47.392s21.22-47.392,47.392-47.392c26.179,0,47.392,21.219,47.392,47.392
                                                          S117.806,167.539,91.627,167.539z M91.627,439.253c-26.173,0-47.392-21.219-47.392-47.392c0-26.173,21.219-47.392,47.392-47.392
                                                          c26.179,0,47.392,21.219,47.392,47.392C139.019,418.033,117.806,439.253,91.627,439.253z"/>
                                                </g>
                                            </g>
                                        </svg>
                                    </span>
                                </div><!--tb-info end-->
                            </div>
                            <?php
                        }
                    }
                    ?>
                </div>
            </div><!--tb-details end-->
        </div><!--tbb_content end-->
        <?php
    }
}