<?php

namespace HeacoolAddons\Widgets;

use Elementor\Widget_Base;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

/**
 *  Main Slider
 *
 *  widget for Main Slider.
 *
 * @since 1.0.0
 */

class Elec_Newsletter extends Widget_Base {

    public $slick_default = array('navigation' => true, 'arrow' => false);

    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'elec-newletter';
    }

    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __('Footer Newsletter', 'heacool-core');
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-posts-ticker';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories() {
        return ['heacool'];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
                'section_content', [
            'label' => __('Content', 'heacool-core'),
                ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
                'title', [
            'label' => __('Title', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::TEXTAREA
                ]
        );

        $this->add_control(
                'item_list', [
            'label' => __('List', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'title' => __('<span>24/Hour</span> Emergency Service', 'heacool-core'),
                ],
                [
                    'title' => __('<span>Free</span> Consultations', 'heacool-core'),
                ],
                [
                    'title' => __('Newsletter Subscribe', 'heacool-core'),
                ],
            ]
                ]
        );

        $this->add_control(
                'newsletter_shortcode', [
            'label' => __('Newsletter Shortcode', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::TEXTAREA
                ]
        );
        $this->end_controls_section();
    }

    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
        <section class="newsletter-sec">
            <div  class="container">
                <ul class="nss_list">
                    <?php
                    if (!empty($settings['item_list'])) {
                        foreach ($settings['item_list'] as $item) {
                            ?>
                            <li>
                                <?php echo wp_kses_post($item['title']); ?>
                            </li>
                            <?php
                        }
                    }
                    ?>
                </ul><!--nss_list end-->
                <?php echo do_shortcode($settings['newsletter_shortcode']); ?>
            </div>
        </section><!--newsletter-sec end-->
        <?php
    }
}