<?php

namespace HeacoolAddons\Widgets;

if (!defined('ABSPATH')) {
    exit;
}

use Elementor\Controls_Manager;
use Elementor\Widget_Base;

class Elec_maintanaince_Sec extends Widget_Base {

    public function get_name() {
        return 'elec_maintanaince_eec';
    }

    public function get_title() {
        return __('Maintanaince', 'heacool-core');
    }

    public function get_icon() {
        return 'eicon-banner';
    }

    public function get_categories() {
        return ['heacool'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
                'title_section', [
            'label' => __('Title', 'heacool-core'),
                ]
        );

        $this->add_control(
                'title_1', [
            'label' => __('Title 1', 'heacool-core'),
            'label_block' => true,
            'type' => Controls_Manager::TEXT,
            'default' => __('We do it with pleasure', 'heacool-core')
                ]
        );

        $this->add_control(
                'title_2', [
            'label' => __('Title 2', 'heacool-core'),
            'label_block' => true,
            'type' => Controls_Manager::TEXT,
            'default' => __('Our Maintenance Includes', 'heacool-core'),
                ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
                'tab_section', [
            'label' => __('Content', 'heacool-core'),
                ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
                'title_1', [
            'label' => __('Title one', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'placeholder' => __('Type your title here', 'heacool-core'),
                ]
        );
        $repeater->add_control(
                'content', [
            'label' => __('Content', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => get_elementor_library(),
                ]
        );

        $this->add_control(
                'item_list', [
            'label' => __('Item List', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'title_1' => __('Our Coupons', 'heacool-core'),
                ],
                [
                    'title_1' => __('Protection Plans', 'heacool-core'),
                ],
                [
                    'title_1' => __('Request Form', 'heacool-core'),
                ],
                [
                    'title_1' => __('Financing', 'heacool-core'),
                ],
            ]
                ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        $electrician_pluginElementor = \Elementor\Plugin::instance();
        ?>

        <section class="block">
            <div class="container">
                <div class="sec-title">
                    <h4>
                        <?php
                        echo wp_kses_post($settings['title_1']);
                        ?>
                    </h4>
                    <h2>
                        <?php
                        echo wp_kses_post($settings['title_2']);
                        ?>
                    </h2>
                </div><!--sec-title end-->
                <div class="maintaince_sec">
                    <ul class="svss_list">

                        <?php
                        if (!empty($settings['item_list'])) {
                            $i = 1;
                            foreach ($settings['item_list'] as $key => $item) {
                                $active = '';
                                if ($i == 1) {
                                    $active = 'active';
                                }
                                ?>
                                <li class="<?php echo $active; ?>" data-tab="<?php echo $key . '_tab_id'; ?>"><?php echo $item['title_1']; ?></li>
                                <?php
                                $i++;
                            }
                            
                        }
                        ?>
                    </ul><!--svss_list end-->
                    <div class="clearfix"></div>
                    <?php
                    if (!empty($settings['item_list'])) {
                        $i = 1;
                        foreach ($settings['item_list'] as $key => $item) {
                            $active = '';
                            if ($key == 0) {
                                $active = 'active';
                            }
                            ?>
                            <div class="tab_content <?php echo $active; ?>" id="<?php echo $key . '_tab_id'; ?>">
                                <?php
                                echo $electrician_pluginElementor->frontend->get_builder_content($item['content']);
                                ?>
                            </div>
                            <?php
                            $i++;
                        }
                        
                    }
                    ?>
                </div><!--maintaince_sec end-->
            </div>
        </section>
        <?php
    }

}
