<?php

namespace HeacoolAddons\Widgets;

if (!defined('ABSPATH')) {
    exit;
}

use Elementor\Controls_Manager;
use Elementor\Widget_Base;

class Elec_Latst_news_2 extends Widget_Base {

    public function get_name() {
        return 'elec_latest_news_2';
    }

    public function get_title() {
        return __('Latest News 2', 'heacool-core');
    }

    public function get_icon() {
        return 'eicon-post';
    }

    public function get_categories() {
        return ['heacool'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
                'section_blogs', [
            'label' => __('Content', 'heacool-core'),
                ]
        );

        $this->add_control(
                'title_1', [
            'label' => __('Title 1', 'heacool-core'),
            'label_block' => true,
            'type' => Controls_Manager::TEXT,
            'default' => __("Read our latest articles", 'heacool-core')
                ]
        );

        $this->add_control(
                'title_2', [
            'label' => __('Title 2', 'heacool-core'),
            'label_block' => true,
            'type' => Controls_Manager::TEXT,
            'default' => __('Company News', 'heacool-core')
                ]
        );

        $this->add_control(
                'number', [
            'label' => __('Number of Post', 'heacool-core'),
            'type' => Controls_Manager::TEXT,
            'default' => 4
                ]
        );

        $this->add_control(
                'order_by', [
            'label' => __('Order By', 'heacool-core'),
            'type' => Controls_Manager::SELECT,
            'default' => 'date',
            'options' => [
                'date' => __('Date', 'heacool-core'),
                'ID' => __('ID', 'heacool-core'),
                'author' => __('Author', 'heacool-core'),
                'title' => __('Title', 'heacool-core'),
                'modified' => __('Modified', 'heacool-core'),
                'rand' => __('Random', 'heacool-core'),
                'comment_count' => __('Comment count', 'heacool-core'),
                'menu_order' => __('Menu order', 'heacool-core')
            ]
                ]
        );

        $this->add_control(
                'order', [
            'label' => __('Order', 'heacool-core'),
            'type' => Controls_Manager::SELECT,
            'default' => 'desc',
            'options' => [
                'desc' => __('DESC', 'heacool-core'),
                'asc' => __('ASC', 'heacool-core')
            ]
                ]
        );
        
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $posts_per_page = $settings['number'];
        $order_by = $settings['order_by'];
        $order = $settings['order'];
        $pg_num = get_query_var('paged') ? get_query_var('paged') : 1;
        $args = array(
            'post_type' => array('post'),
            'post_status' => array('publish'),
            'nopaging' => false,
            'paged' => $pg_num,
            'posts_per_page' => $posts_per_page,
            'orderby' => $order_by,
            'order' => $order,
        );
        $query = new \WP_Query($args);
        ?>
        <section class="block">
            <div class="container">
                <div class="sec-title">
                    <h4> <?php
                        echo wp_kses_post($settings['title_1']);
                        ?>
                    </h4>
                    <h2><?php
                        echo wp_kses_post($settings['title_2']);
                        ?>
                    </h2>
                </div><!--sec-title end-->
                <div class="blog-posts">
                    <div class="row blog_carousel">
                        <?php
                        if ($query->have_posts()) {
                            $i = 1;
                            while ($query->have_posts()) {
                                $query->the_post();
                                ?>
                                <div class="col-lg-4">
                                    <div class="blog-post">
                                        <?php
                                        if (has_post_thumbnail()) {
                                            $heacool_featured_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'heacool_blog_post_section_image');
                                            ?>
                                            <div class="blog-img">
                                                <img src="<?php echo esc_url($heacool_featured_image[0]); ?>" alt="<?php esc_attr_e('Img', 'heacool-core'); ?>">
                                            </div>
                                        <?php }
                                        ?>
                                        <div class="blog-info">
                                            <ul class="meta">
                                                <li>
                                                    <span class="posted_date">
                                                        <?php echo get_the_date('d'); ?>
                                                        <b><?php echo get_the_date('M'); ?></b>
                                                    </span>
                                                </li>
                                                <li><?php heacool_comments_count(); ?></li>
                                            </ul><!--meta end-->
                                            <h2 class="post-title"><a href="<?php the_permalink(); ?>" title=""><?php the_title(); ?></a></h2>
                                            <a href="<?php the_permalink(); ?>" title=""><i class="fa fa-play"></i><?php echo esc_html__('Continue Reading', 'heacool-core'); ?></a>
                                        </div><!--blog-info end-->
                                    </div><!--blog-post end-->
                                </div>
                                <?php
                                $i++;
                            }
                            wp_reset_postdata();
                        }
                        ?>
                    </div>
                </div><!--blog-posts end-->
            </div>
        </section><!--latest-articles end-->
        <?php
    }

}
