<?php

namespace HeacoolAddons\Widgets;

if (!defined('ABSPATH')) {
    exit;
}

use Elementor\Widget_Base;

class Elec_Faqs_Tabs extends Widget_Base {

    public function get_name() {
        return 'elec_faq_tab';
    }

    public function get_title() {
        return __('Faqs Tabs', 'heacool-core');
    }

    public function get_icon() {
        return 'eicon-banner';
    }

    public function get_categories() {
        return ['heacool'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
                'title_section', [
            'label' => __('Title', 'heacool-core'),
                ]
        );

        $this->add_control(
                'title_1', [
            'label' => __('Title', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('Answers from the experts!', 'heacool-core'),
            'placeholder' => __('Type your title here', 'heacool-core')
                ]
        );
         $this->add_control(
                'title_2', [
            'label' => __('Title', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('Frequently Asked Questions', 'heacool-core'),
            'placeholder' => __('Type your title here', 'heacool-core')
                ]
        );
        $this->add_control(
                'content', [
            'label' => __('Content', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('These are the most frequently asked questions about HVAC, Sizing, and More. Please feel free to contact us if you don’t see your question answered below.', 'heacool-core')
                ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_1', [
            'label' => __('Content Tab 1', 'heacool-core'),
                ]
        );

        $this->add_control(
                'tab_name_1', [
            'label' => __('Tab Name', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('General Questions', 'heacool-core')
                ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
                'title_1', [
            'label' => __('Question', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'placeholder' => __('Type your title here', 'heacool-core'),
                ]
        );

        $repeater->add_control(
                'title_2', [
            'label' => __('Answere', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'placeholder' => __('Type your title here', 'heacool-core'),
                ]
        );

        $this->add_control(
                'item_list', [
            'label' => __('Item List', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'title_1' => __('What is the life expectancy of my HVAC system?', 'heacool-core'),
                    'title_2' => __('How often you run your system, the system’s age, its make and model, and whether or not it was serviced regularly over the course of its life can all play a significant role in how long your system will last you.d/or air conditioner to last approximately 15 years. ', 'heacool-core'),
                ],
                [
                    'title_1' => __('What is the life expectancy of my HVAC system?', 'heacool-core'),
                    'title_2' => __('How often you run your system, the system’s age, its make and model, and whether or not it was serviced regularly over the course of its life can all play a significant role in how long your system will last you.d/or air conditioner to last approximately 15 years. ', 'heacool-core'),
                ],
                [
                    'title_1' => __('What is the life expectancy of my HVAC system?', 'heacool-core'),
                    'title_2' => __('How often you run your system, the system’s age, its make and model, and whether or not it was serviced regularly over the course of its life can all play a significant role in how long your system will last you.d/or air conditioner to last approximately 15 years. ', 'heacool-core'),
                ],
                [
                    'title_1' => __('What is the life expectancy of my HVAC system?', 'heacool-core'),
                    'title_2' => __('How often you run your system, the system’s age, its make and model, and whether or not it was serviced regularly over the course of its life can all play a significant role in how long your system will last you.d/or air conditioner to last approximately 15 years. ', 'heacool-core'),
                ],
              
            ]
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_tab_2', [
            'label' => __('Content Tab 1', 'heacool-core'),
                ]
        );

        $this->add_control(
                'tab_name_2', [
            'label' => __('Tab Name', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('Mechanical Questions', 'heacool-core')
                ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
                'title_1', [
            'label' => __('Question', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'placeholder' => __('Type your title here', 'heacool-core'),
                ]
        );

        $repeater->add_control(
                'title_2', [
            'label' => __('Answere', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'placeholder' => __('Type your title here', 'heacool-core'),
                ]
        );

        $this->add_control(
                'item_list_1', [
            'label' => __('Item List', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'title_1' => __('What is the life expectancy of my HVAC system?', 'heacool-core'),
                    'title_2' => __('How often you run your system, the system’s age, its make and model, and whether or not it was serviced regularly over the course of its life can all play a significant role in how long your system will last you.d/or air conditioner to last approximately 15 years. ', 'heacool-core'),
                ],
                [
                    'title_1' => __('What is the life expectancy of my HVAC system?', 'heacool-core'),
                    'title_2' => __('How often you run your system, the system’s age, its make and model, and whether or not it was serviced regularly over the course of its life can all play a significant role in how long your system will last you.d/or air conditioner to last approximately 15 years. ', 'heacool-core'),
                ],
                [
                    'title_1' => __('What is the life expectancy of my HVAC system?', 'heacool-core'),
                    'title_2' => __('How often you run your system, the system’s age, its make and model, and whether or not it was serviced regularly over the course of its life can all play a significant role in how long your system will last you.d/or air conditioner to last approximately 15 years. ', 'heacool-core'),
                ],
                [
                    'title_1' => __('What is the life expectancy of my HVAC system?', 'heacool-core'),
                    'title_2' => __('How often you run your system, the system’s age, its make and model, and whether or not it was serviced regularly over the course of its life can all play a significant role in how long your system will last you.d/or air conditioner to last approximately 15 years. ', 'heacool-core'),
                ],
              
            ]
                ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
        <section class="block p-100">
            <div class="container">
                <div class="sec-title">
                    <h4><?php echo $settings['title_1']; ?></h4>
                    <h2><?php echo $settings['title_2']; ?></h2>
                </div><!--sec-title end-->
                <div class="faqs_sec">
                    <p><?php echo $settings['content']; ?></p>
                    <ul class="faqs_tab">
                        <li class="active" data-tab="ques_accordion"><?php echo $settings['tab_name_1']; ?></li>     
                        <li data-tab="mech_accordion"><?php echo $settings['tab_name_2']; ?></li>     
                    </ul><!--faqs_tab end-->
                    <div class="ht-accordion active toggle" id="ques_accordion">
                        <?php
                        if (!empty($settings['item_list'])) {
                            $i = 1;
                            foreach ($settings['item_list'] as $key => $item) {
                                $isActive = '';
                                $isActive_1 = '';
                                if ($key == 0) {
                                    $isActive = 'activate';
                                    $isActive_1 = 'active';
                                }
                                ?>
                                <div class="toggle-item">
                                    <h2><?php echo wp_kses_post($item['title_1']); ?></h2>
                                    <div class="content">
                                        <p><?php echo wp_kses_post($item['title_2']); ?></p>
                                    </div>
                                </div><!-- Toggle Item -->
                                <?php
                                $i++;
                            }
                        }
                        ?>

                    </div><!-- ht-accordion Accordion -->

                    <div class="ht-accordion toggle" id="mech_accordion">
                        <?php
                        if (!empty($settings['item_list_1'])) {
                            $i = 1;
                            foreach ($settings['item_list_1'] as $key => $item) {
                                $isActive = '';
                                $isActive_1 = '';
                                if ($key == 0) {
                                    $isActive = 'activate';
                                    $isActive_1 = 'active';

                                }
                                ?>
                                <div class="toggle-item">
                                    <h2><?php echo wp_kses_post($item['title_1']); ?></h2>
                                    <div class="content">
                                        <p><?php echo wp_kses_post($item['title_2']); ?></p>
                                    </div>
                                </div><!-- Toggle Item -->

                                <?php
                                $i++;
                            }
                        }
                        ?>
                    </div><!-- ht-accordion Accordion -->
                </div><!--faqs_sec end-->
            </div>
        </section>
        <?php
    }

}
