<?php

namespace HeacoolAddons\Widgets;

if (!defined('ABSPATH')) {
    exit;
}

use Elementor\Widget_Base;

class Elec_Faqs_One extends Widget_Base {

    public function get_name() {
        return 'elec_faq_one';
    }

    public function get_title() {
        return __('Faqs', 'heacool-core');
    }

    public function get_icon() {
        return 'eicon-banner';
    }

    public function get_categories() {
        return ['heacool'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
                'content_section', [
            'label' => __('FAQ List', 'heacool-core'),
                ]
        );

        $this->add_control(
                'design_style', [
            'label' => __('Skin', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => '1',
            'options' => [
                '1' => __('Skin 1', 'heacool-core'),
                '2' => __('Skin 2', 'heacool-core')
            ],
                ]
        );

        $this->add_control(
                'title_1', [
            'label' => __('Title', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('Heating & Cooling <span>FAQ</span>', 'heacool-core'),
            'placeholder' => __('Type your title here', 'heacool-core')
                ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
                'title_1', [
            'label' => __('Question', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'placeholder' => __('Type your title here', 'heacool-core'),
                ]
        );
        $repeater->add_control(
                'title_2', [
            'label' => __('Answere', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'placeholder' => __('Type your title here', 'heacool-core'),
                ]
        );

        $this->add_control(
                'item_list', [
            'label' => __('Item List', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'title_1' => __('What is the life expectancy of my HVAC system?', 'heacool-core'),
                    'title_2' => __('How often you run your system, the system’s age, its make and model, and whether or not it was serviced regularly over the course of its life can all play a significant role in how long your system will last you.d/or air conditioner to last approximately 15 years. ', 'heacool-core'),
                ],
                [
                    'title_1' => __('What is the life expectancy of my HVAC system?', 'heacool-core'),
                    'title_2' => __('How often you run your system, the system’s age, its make and model, and whether or not it was serviced regularly over the course of its life can all play a significant role in how long your system will last you.d/or air conditioner to last approximately 15 years. ', 'heacool-core'),
                ],
                [
                    'title_1' => __('What is the life expectancy of my HVAC system?', 'heacool-core'),
                    'title_2' => __('How often you run your system, the system’s age, its make and model, and whether or not it was serviced regularly over the course of its life can all play a significant role in how long your system will last you.d/or air conditioner to last approximately 15 years. ', 'heacool-core'),
                ],
                [
                    'title_1' => __('What is the life expectancy of my HVAC system?', 'heacool-core'),
                    'title_2' => __('How often you run your system, the system’s age, its make and model, and whether or not it was serviced regularly over the course of its life can all play a significant role in how long your system will last you.d/or air conditioner to last approximately 15 years. ', 'heacool-core'),
                ],
              
            ]
                ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
                'section_form', [
            'label' => __('Content Section', 'heacool-core'),
                ]
        );

        $this->add_control(
                'title', [
            'label' => __('Title', 'heacool-core'),
            'label_block' => true,
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('Ask <span>Question</span>', 'heacool-core')
                ]
        );

        $this->add_control(
                'testi_cf7', [
            'label' => __('CF7 Shortcode/Content', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::TEXTAREA
                ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        if ($settings['design_style'] == '1') {
        ?>
        <section class="block">
            <div class="container">
                <div class="faqs_qs_sec">
                    <div class="row">
                        <div class="col-lg-6 col-md-6">
                            <div class="faqs-sec">
                                <h3 class="sc-title"><?php echo $settings['title_1']; ?></h3>
                                <div class="ht-accordion toggle">
                                     <?php
                                    if (!empty($settings['item_list'])) {
                                        $i = 1;
                                        foreach ($settings['item_list'] as $key => $item) {
                                            $isActive = '';
                                            $isActive_1 = '';
                                            if ($key == 0) {
                                                $isActive = 'activate';
                                                 $isActive_1 = 'active';

                                            }
                                            ?>
                                            <div class="toggle-item <?php echo $isActive;?>">
                                                <h2 class="<?php echo $isActive_1;?>"><?php echo wp_kses_post($item['title_1']); ?></h2>
                                                <div class="content">
                                                    <p><?php echo wp_kses_post($item['title_2']); ?></p>
                                                </div>
                                            </div><!-- Toggle Item -->
                                                <?php
                                            $i++;
                                        }
                                    }
                                    ?>
                                </div><!-- ht-accordion Accordion -->
                            </div><!--faqs-sec end-->
                        </div>
                        <div class="col-lg-6 col-md-6">
                            <div class="question_sec">
                                <h3 class="sc-title"><?php echo $settings['title']; ?></h3>
                               <?php echo do_shortcode(shortcode_unautop($settings['testi_cf7'])); ?>
                            </div><!--question_sec end-->
                        </div>
                    </div>
                </div><!--faqs_qs_sec end-->
            </div>
        </section>
        <?php

    } else{ ?>
        <section class="block">
            <div class="container">
                <div class="more_featz_sec">
                    <div class="row">
                        <div class="col-lg-6 col-md-6">
                            <div class="ht_info">
                                <h3 class="sc-title"><?php echo $settings['title']; ?></h3>
                                <?php echo do_shortcode(shortcode_unautop($settings['testi_cf7'])); ?>
                            </div><!--ht_info end-->
                        </div>
                        <div class="col-lg-6 col-md-6">
                            <div class="faqs-sec company_vision">
                                <h3 class="sc-title"><?php echo $settings['title_1']; ?></h3>
                                <div class="ht-accordion toggle">
                                <?php
                                    if (!empty($settings['item_list'])) {
                                        $i = 1;
                                        foreach ($settings['item_list'] as $key => $item) {
                                            $isActive = '';
                                            $isActive_1 = '';
                                            if ($key == 0) {
                                                $isActive = 'activate';
                                                 $isActive_1 = 'active';
                                            }
                                            ?>
                                            <div class="toggle-item">
                                                <h2><?php echo wp_kses_post($item['title_1']); ?></h2>
                                                <div class="content">
                                                    <p><?php echo wp_kses_post($item['title_2']); ?></p>
                                                </div>
                                            </div><!-- Toggle Item -->
                                         <?php
                                            $i++;
                                        }
                                    }
                                    ?>
    
                            </div><!--faqs-sec end-->
                        </div>
                    </div>
                </div><!--more_featz_sec end-->
            </div>
            </div>
        </section><!--company-mission sec end-->
 <?php
}
}
}
