<?php

namespace HeacoolAddons\Widgets;

use Elementor\Widget_Base;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

/**
 *  Main Slider
 *
 *  widget for Main Slider.
 *
 * @since 1.0.0
 */

class Elec_Brands_2 extends Widget_Base {

    public $slick_default = array('navigation' => true, 'arrow' => false);

    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'electrician-brands-2';
    }

    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __('Brands 2', 'heacool-core');
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-posts-ticker';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories() {
        return ['heacool'];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function _register_controls() {
        $this->start_controls_section(
                'section_content', [
            'label' => __('Content', 'heacool-core'),
                ]
        );

        $this->add_control(
                'title', [
            'label' => __('Title', 'heacool-core'),
            'label_block' => true,
            'default'  => __('Quality brands we trust', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::TEXT
                ]
        );

        $this->add_control(
                'title_1', [
            'label' => __('Title 1', 'heacool-core'),
            'label_block' => true,
            'default'  => __('Our Partners', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::TEXT
                ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
                'slider_image', [
            'label' => __('Brand image', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::MEDIA,
            'default' => [
                'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
                ]
        );

        $this->add_control(
                'slider_list', [
            'label' => __('Brand List', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
                ]
        );

        $this->end_controls_section();
    }

    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
        <section class="block partners-sec">
            <div class="container">
                <div class="sec-title">
                    <h4><?php echo $settings['title'];?></h4>
                    <h2><?php echo $settings['title_1'];?></h2>
                </div><!--sec-title end-->
                <div class="pt_carousel">
                    <?php
                    if (!empty($settings['slider_list'])) {
                        foreach ($settings['slider_list'] as $item) {
                            $url = '#';
                            $target = '';
                            if (!empty($item['action_link'])) {
                                $link = $item['action_link'];
                                $url = $link['url'];
                                $target = $link['is_external'] ? 'target="_blank"' : '';
                            }
                            $image_alt = get_post_meta($item['slider_image']['id'], '_wp_attachment_image_alt', TRUE);
                            $image_url = ( $item['slider_image']['id'] != '' ) ? wp_get_attachment_url($item['slider_image']['id']) : $item['slider_image']['url'];
                            ?>
                            <div class="pt-logo">
                                <img src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_url($image_alt);?>">
                            </div><!--pt-logo end-->
                            <?php
                        }
                    }
                    ?>
                </div><!--pt_carousel end-->
            </div>
        </section><!--partners-sec end-->
        <?php
    }
}