<?php

namespace HeacoolAddons\Widgets;

if (!defined('ABSPATH')) {
    exit;
}

use Elementor\Controls_Manager;
use Elementor\Widget_Base;

class Elec_Banner_2 extends Widget_Base {

    public function get_name() {
        return 'elec_banner_2';
    }

    public function get_title() {
        return __('Banner', 'heacool-core');
    }

    public function get_icon() {
        return 'eicon-banner';
    }

    public function get_categories() {
        return ['heacool'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'bg_section', [
                'label' => __('Background', 'heacool-core'),
            ]
        );

        $this->add_control(
            'design_style', [
                'label' => __('Layout Style', 'heacool-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1' => __('Style 1', 'heacool-core'),
                    '2' => __('Style 2', 'heacool-core'),
                    '3' => __('Style 3', 'heacool-core'),
                    '4' => __('Style 4', 'heacool-core'),
                    '5' => __('Style 5', 'heacool-core'),
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'label' => __('Background Image', 'heacool-core'),
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .fixed-bg.bg4',
                'condition' => ['design_style' => '1'],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background_1',
                'label' => __('Background Image', 'heacool-core'),
                'types' => ['classic'],
                'selector' => '{{WRAPPER}} .fixed-bg.bg7',
                'condition' => ['design_style' => '2'],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background_3',
                'label' => __('Background Image', 'heacool-core'),
                'types' => ['classic'],
                'selector' => '{{WRAPPER}} .fixed-bg.bg8',
                'condition' => ['design_style' => '3'],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background_4',
                'label' => __('Background Image', 'heacool-core'),
                'types' => ['classic'],
                'selector' => '{{WRAPPER}} .fixed-bg.bg10',
                'condition' => ['design_style' => '4'],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background_5',
                'label' => __('Background Image', 'heacool-core'),
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .fixed-bg.bg9',
                'condition' => ['design_style' => '5'],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_section', [
                'label' => __('Content', 'heacool-core'),
            ]
        );

        $this->add_control(
            'title_1', [
                'label' => __('Title 1', 'heacool-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('<span>Air Conditioning & Heating</span> Services Repair & Maintenance', 'heacool-core'),
            ]
        );

        $this->add_control(
            'title_tab', [
                'label' => __('Title for Tab', 'heacool-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => '',
            ]
        );

        $this->add_control(
            'content', [
                'label' => __('Content', 'heacool-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('Too hot? Too cold? Middle of the night? Give us a call anytime. We\'re ready.', 'heacool-core'),
            ]
        );

        $this->add_control(
            'content_tab', [
                'label' => __('Content Tab', 'heacool-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => '',
            ]
        );

        $this->add_control(
            'button_text', [
                'label' => __('Button Text', 'heacool-core'),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
                'default' => __('Make an Appointment', 'heacool-core'),
            ]
        );

        $this->add_control(
            'action_link', [
                'label' => __('Action Button', 'heacool-core'),
                'type' => Controls_Manager::URL,
                'default' => [
                    'url' => '#',
                    'is_external' => '',
                ],
                'show_external' => true,
            ]
        );

        $this->add_control(
            'phone', [
                'label' => __('Phone', 'heacool-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('<i class="fa fa-phone"></i> 609-123-4567', 'heacool-core'),
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $url = '#';
        $target = '';
        if (!empty($settings['action_link'])) {
            $link = $settings['action_link'];
            $url = $link['url'];
            $target = $link['is_external'] ? 'target="_blank"' : '';
        }

        $bgClass = '';
        if ($settings['design_style'] == '1') {
            $bgClass = 'bg4';
            ?>
<section class="block sap-sec air_sec">
  <div class="fixed-bg <?php echo $bgClass; ?>"></div>
  <div class="container">
    <div class="sep-text">
      <h2> <?php
echo wp_kses_post($settings['title_1']);
            ?></h2>
      <p> <?php
echo wp_kses_post($settings['content']);
            ?></p>
      <?php if ($settings['action_link']['url']) {?>
      <a href="<?php echo esc_url($settings['action_link']['url']); ?>" <?php echo $target; ?>
        class="lnk_default apt_form_btn"><?php echo esc_html($settings['button_text']); ?></a>
      <?php }?>
    </div>
    <!--sep-text end-->
  </div>
</section>
<!--sap-sec end-->
<?php } elseif ($settings['design_style'] == '2') {
            $bgClass = 'bg7';
            ?>
<section class="block gap-less overlay-light rifat-div-tab rifat-div-pho">
  <div class="fixed-bg bg7"></div>
  <div class="container">
    <div class="help_text">
      <h2 class="visible-lg visible-md">
        <?php
echo wp_kses_post($settings['title_1']);
            ?>
      </h2>
      <h2 class="visible-sm visible-xs">
        <?php
echo wp_kses_post($settings['title_tab']);
            ?>
      </h2>
      <p class="visible-lg visible-md">
        <?php
echo wp_kses_post($settings['content']);
            ?>
      </p>

      <p class="visible-sm visible-xs">
        <?php
echo wp_kses_post($settings['content_tab']);
            ?>
      </p>
      <ul class="hlp">
        <li>
          <?php if ($settings['action_link']['url']) {?>
          <a href="<?php echo esc_url($settings['action_link']['url']); ?>" <?php echo $target; ?>
            class="lnk-default"><?php echo esc_html($settings['button_text']); ?></a>
          <?php }?>
        </li>
        <?php if (!empty($settings['phone'])) {?>
        <li class="phone">
          <?php
echo wp_kses_post($settings['phone']);
                ?>
        </li>
        <?php }?>
      </ul>
      <!--hlp end-->
    </div>
    <!--help_text end-->
  </div>
</section>
<?php } elseif ($settings['design_style'] == '3') {
            ?>
<section class="block p-100 new-bg-8">
  <div class="fixed-bg bg8"></div>
  <div class="container">
    <div class="sep-text fl-right fq">
      <h2 class="visible-lg visible-md"><?php
echo wp_kses_post($settings['title_1']);
            ?>
      </h2>
      <h2 class="visible-sm visible-xs">
        <?php
echo wp_kses_post($settings['title_tab']);
            ?>
      </h2>
      <p class="visible-lg visible-md">
        <?php
echo wp_kses_post($settings['content']);
            ?>
      </p>

      <p class="visible-sm visible-xs">
        <?php
echo wp_kses_post($settings['content_tab']);
            ?>
      </p>
      <?php if ($settings['action_link']['url']) {?>
      <a href="<?php echo esc_url($settings['action_link']['url']); ?>" <?php echo $target; ?>
        class="lnk_default apt_form_btn"><?php echo esc_html($settings['button_text']); ?></a>
      <?php }?>
    </div>
    <!--sep-text end-->
  </div>
</section>
<?php
} elseif ($settings['design_style'] == '4') {
            ?>
<section class="block p-100">
  <div class="fixed-bg bg10"></div>
  <div class="container">
    <div class="sep-text fl-right">
      <h2 class="visible-lg visible-md"><?php
echo wp_kses_post($settings['title_1']);
            ?>
      </h2>
      <h2 class="visible-sm visible-xs">
        <?php
echo wp_kses_post($settings['title_tab']);
            ?>
      </h2>
      <p class="visible-lg visible-md">
        <?php
echo wp_kses_post($settings['content']);
            ?>
      </p>
      <p class="visible-sm visible-xs">
        <?php
echo wp_kses_post($settings['content_tab']);
            ?>
      </p>
      <?php if (!empty($settings['phone'])) {
                echo wp_kses_post($settings['phone']);
            }
            ?>
    </div>
    <!--sep-text end-->
  </div>
</section>
<?php } else {?>
<section class="block sap-sec">
  <div class="fixed-bg bg9"></div>
  <div class="container">
    <div class="sep-text">
      <h2 class="visible-lg visible-md"><?php
echo wp_kses_post($settings['title_1']);
            ?>
      </h2>
      <h2 class="visible-sm visible-xs">
        <?php
echo wp_kses_post($settings['title_tab']);
            ?>
      </h2>
      <p class="visible-lg visible-md">
        <?php
echo wp_kses_post($settings['content']);
            ?>
      </p>

      <p class="visible-sm visible-xs">
        <?php
echo wp_kses_post($settings['content_tab']);
            ?>
      </p>
      <?php if ($settings['action_link']['url']) {?>
      <a href="<?php echo esc_url($settings['action_link']['url']); ?>" <?php echo $target; ?>
        class="lnk_default apt_form_btn"><?php echo esc_html($settings['button_text']); ?></a>
      <?php }?>
    </div>
    <!--sep-text end-->
  </div>
</section>
<?php }
    }
}