<?php

namespace HeacoolAddons\Widgets;

if (!defined('ABSPATH')) {
    exit;
}

use Elementor\Controls_Manager;
use Elementor\Widget_Base;

class Elec_About_Us_2 extends Widget_Base {

    public function get_name() {
        return 'ele_about_us_2';
    }

    public function get_title() {
        return __('About Us', 'heacool-core');
    }

    public function get_icon() {
        return 'eicon-banner';
    }

    public function get_categories() {
        return ['heacool'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
                'content_section', [
            'label' => __('Content', 'heacool-core'),
                ]
        );

        $this->add_control(
                'design_style', [
            'label' => __('Style', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'default' => '1',
            'options' => [
                '1' => __('Style 1', 'heacool-core'),
                '2' => __('Style 2', 'heacool-core'),
            ],
                ]
        );

        $this->add_control(
                'image', [
            'label' => __('Image', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::MEDIA,
            'default' => [
                'url' => \Elementor\Utils::get_placeholder_image_src(),
            ],
                ]
        );

        $this->add_control(
                'video_url', [
            'label' => __('Ifram URL', 'heacool-core'),
            'label_block' => true,
            'type' => Controls_Manager::TEXT,
            'default' => 'https://www.youtube.com/watch?v=qPhVZExcGXg',
            'condition' => ['design_style' => '2']
                ]
        );


        $this->add_control(
                'title_1', [
            'label' => __('Title 1', 'heacool-core'),
            'label_block' => true,
            'type' => Controls_Manager::TEXTAREA,
            'default' => __('Excellence has been our hallmark since 2010', 'heacool-core')
                ]
        );

        $this->add_control(
                'title_2', [
            'label' => __('Title 2', 'heacool-core'),
            'label_block' => true,
            'type' => Controls_Manager::TEXTAREA,
            'default' => __('<span>History</span> of Our Company', 'heacool-core')
                ]
        );


        $this->add_control(
                'content', [
            'label' => __('Content', 'heacool-core'),
            'type' => Controls_Manager::TEXTAREA,
            'default' => __('<p>In 2010, brothers Sam and John went business together to fix their friends’ and family members’ conditioners. Two years later, Sam and John moved into their first building, forming Heating and Cooling. Over the next two decades, the business continued to grow; in 2012, we moved into our current location on Front Street in City.</p>', 'heacool-core')
                ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $image_alt = get_post_meta($settings['image']['id'], '_wp_attachment_image_alt', TRUE);
        $image_url = ( $settings['image']['id'] != '' ) ? wp_get_attachment_url($settings['image']['id']) : $settings['image']['url'];

        if ($settings['design_style'] == '1') {
            
            ?>
            <section class="block about_sec">
                <div class="container">
                    <div class="about_us_sec">
                        <div class="row">
                            <div class="col-lg-6 col-md-6 abt">
                                <div class="abt-img">
                                    <img src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_attr($image_alt); ?>">
                                </div><!--abt-img end-->
                            </div>
                            <div class="col-lg-6 col-md-6 inf">
                                <div class="abt-info">
                                    <h4>
                                        <?php
                                        echo wp_kses_post($settings['title_1']);
                                        ?>
                                    </h4>
                                    <h2>  <?php
                                        echo wp_kses_post($settings['title_2']);
                                        ?></h2>
                                    <?php
                                    echo wp_kses_post($settings['content']);
                                    ?>
                                </div><!--abt-info end-->
                            </div>
                        </div>
                    </div><!--about_us_sec end-->
                </div>
            </section><!--about-us end-->
        <?php } else {
            ?>
            <section class="block">
                <div class="container">
                    <div class="quality-sec">
                        <div class="row">
                            <div class="col-lg-7 col-md-7">
                                <div class="quality_info">
                                    <h3 class="sc-title"><?php
                                        echo wp_kses_post($settings['title_1']);
                                        ?>
                                    </h3>
                                    <?php
                                    echo wp_kses_post($settings['title_2']);
                                    ?>
                                    <?php
                                    echo wp_kses_post($settings['content']);
                                    ?>
                                </div><!--quality_info end-->
                            </div>
                            <div class="col-lg-5 col-md-5">
                                <div class="vide-sec">
                                    <img src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_attr($image_alt); ?>">
                                    <?php if (!empty($settings['video_url'])) { ?>
                                        <a href="<?php echo esc_url($settings['video_url']); ?>" title="" class="vid_play html5lightbox"><i class="fa fa-play"></i></a>
                                        <?php }
                                        ?>

                                </div><!--vide-sec end-->
                            </div>
                        </div>
                    </div><!--quality-sec end-->
                </div>
            </section>
            <?php
        }
    }

}
