<?php

namespace HeacoolAddons\Widgets;

if (!defined('ABSPATH')) {
    exit;
}

use Elementor\Widget_Base;

class Elec_Adds_Services extends Widget_Base {

    public function get_name() {
        return 'elec_adds_services_2';
    }

    public function get_title() {
        return __('Our Services 2', 'heacool-core');
    }

    public function get_icon() {
        return 'eicon-banner';
    }

    public function get_categories() {
        return array('heacool');
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'bg_image_section',
            array(
                'label' => __('BG Image', 'heacool-core'),
            )
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            array(
                'name' => 'background',
                'label' => __('Background Image', 'heacool-core'),
                'types' => array('classic', 'video'),
                'selector' => '{{WRAPPER}} .fixed-bg.bg2',
            )
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'content_section',
            array(
                'label' => __('Content', 'heacool-core'),
            )
        );
        $this->add_control(
            'title_1',
            array(
                'label' => __('Title 1 and 2', 'heacool-core'),
                'label_block' => true,
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('What we\'re do else', 'heacool-core'),
                'placeholder' => __('Type your title here', 'heacool-core'),
            )
        );
        $this->add_control(
            'title_2',
            array(
                'label' => __('Title 2', 'heacool-core'),
                'label_block' => true,
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Additional Services', 'heacool-core'),
                'placeholder' => __('Type your title here', 'heacool-core'),
            )
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'svg_text',
            array(
                'label' => __('SVG Text', 'heacool-core'),
                'label_block' => true,
                'description' => __('If Not Use SVG Image', 'heacool-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Type your title here', 'heacool-core'),
            )
        );

        $repeater->add_control(
            'svg_icons',
            [
                'label' => __('SVG Icons', 'text-domain'),
                'description' => __('If Not Use SVG Text', 'heacool-core'),
                'type' => \Elementor\Controls_Manager::ICONS,

            ]
        );

        $repeater->add_control(
            'title_1',
            array(
                'label' => __('Title', 'heacool-core'),
                'label_block' => true,
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Type your title here', 'heacool-core'),
            )
        );
        $repeater->add_control(
            'title_2',
            array(
                'label' => __('Content', 'heacool-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Type your title here', 'heacool-core'),
            )
        );

        $this->add_control(
            'item_list',
            array(
                'label' => __('Item List', 'heacool-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => array(
                    array(
                        'title_1' => __('Split Systems Service', 'heacool-core'),
                        'title_2' => __('An air conditioner that is regularly maintained will run better and last longer.', 'heacool-core'),
                    ),
                    array(
                        'title_1' => __('Hot Water Heater', 'heacool-core'),
                        'title_2' => __('Demand-type heaters provide hot water only as it is needed.', 'heacool-core'),
                    ),
                    array(
                        'title_1' => __('On Demand Heater', 'heacool-core'),
                        'title_2' => __('Demand-type heaters provide hot water only as it is needed.', 'heacool-core'),
                    ),
                    array(
                        'title_1' => __('Duct Cleaning Services', 'heacool-core'),
                        'title_2' => __('Ventilation systems are often the biggest culprit in poor indoor air quality.', 'heacool-core'),
                    ),
                    array(
                        'title_1' => __('Hot Water Heaters', 'heacool-core'),
                        'title_2' => __('Radiant floor heating can be an economical and convenient for your home.', 'heacool-core'),
                    ),
                    array(
                        'title_1' => __('Humidifiers', 'heacool-core'),
                        'title_2' => __('If your home is not humidified enough, your skin will always feel dry.', 'heacool-core'),
                    ),
                ),
            )
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
<section class="block">
  <div class="fixed-bg bg2"></div>
  <div class="container">
    <div class="sec-title">
      <h4>
        <?php
echo wp_kses_post($settings['title_1']);
        ?>
      </h4>
      <h2>
        <?php
echo wp_kses_post($settings['title_2']);
        ?>
      </h2>
    </div>
    <!--sec-title end-->
    <div class="adds_services">
      <div class="row">
        <?php
if (!empty($settings['item_list'])) {
            foreach ($settings['item_list'] as $item) {
                ?>
        <div class="col-lg-4 col-md-4 col-sm-4 col-xs-6 full_wdth">
          <div class="ads_service">
            <?php
if (isset($item['svg_icons']['value']['url']) && !empty($item['svg_icons']['value']['url'])) {
                    $image_url = $item['svg_icons']['value']['url'];
                    echo '<img class="adds_services_svg" width="48px" height="40px" style="margin-bottom: 15px;" src="' . $image_url . '">';
                } else {?>
            <span class="ads_icon">
              <?php
if (!empty($item['svg_text'])) {
                    echo $item['svg_text'];
                }}
                ?>
            </span>
            <h3><?php echo wp_kses_post($item['title_1']); ?></h3>
            <p><?php echo wp_kses_post($item['title_2']); ?></p>
          </div>
          <!--ads_service end-->
        </div>
        <?php
}
        }
        ?>

      </div>
    </div>
    <!--adds_services end-->
  </div>
</section>
<!--additional-services end-->
<!-- Begin statements -->
<!-- End statements -->
<?php
}

}