<?php

namespace HeacoolAddons;

/**
 * Class Plugin
 *
 * Main Plugin class
 *
 * @since 1.2.0
 */
class Plugin {

	/**
	 * Instance
	 *
	 * @since 1.2.0
	 * @access private
	 * @static
	 *
	 * @var Plugin The single instance of the class.
	 */
	private static $_instance = null;

	/**
	 * Instance
	 *
	 * Ensures only one instance of the class is loaded or can be loaded.
	 *
	 * @since 1.2.0
	 * @access public
	 *
	 * @return Plugin An instance of the class.
	 */
	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

	/**
	 * widget_scripts
	 *
	 * Load required plugin core files.
	 *
	 * @since 1.2.0
	 * @access public
	 */
	public function widget_scripts() {
		wp_enqueue_script( 'slick', plugins_url( '/assets/js/slick.min.js', __FILE__ ), array( 'jquery' ), false, true );
		wp_enqueue_script( 'heacool-addons-script', plugins_url( '/assets/js/addons-script.js', __FILE__ ), array( 'jquery', 'slick' ), time(), true );
	}

	/**
	 * Include Widgets files
	 *
	 * Load widgets files
	 *
	 * @since 1.2.0
	 * @access private
	 */
	private function include_widgets_files() {
		require_once __DIR__ . '/widgets/main-slider.php';
		require_once __DIR__ . '/widgets/elec-services-icon.php';
		require_once __DIR__ . '/widgets/elec-services.php';
		require_once __DIR__ . '/widgets/elec-services-tabs.php';
		require_once __DIR__ . '/widgets/adds-services.php';
		require_once __DIR__ . '/widgets/elec-faqs-1.php';
		require_once __DIR__ . '/widgets/why-choose-us.php';
		require_once __DIR__ . '/widgets/elec-latest-news-2.php';
		require_once __DIR__ . '/widgets/elec-banner-2.php';
		require_once __DIR__ . '/widgets/elec-maintaince-sec.php';
		require_once __DIR__ . '/widgets/elec-testimonials-2.php';
		require_once __DIR__ . '/widgets/elec-brands-2.php';
		require_once __DIR__ . '/widgets/elec-our-coupons.php';
		require_once __DIR__ . '/widgets/protection-plans.php';
		require_once __DIR__ . '/widgets/protection-plans-tab.php';
		require_once __DIR__ . '/widgets/elec-about-us-2.php';
		require_once __DIR__ . '/widgets/our-advantages-2.php';
		require_once __DIR__ . '/widgets/elec-team-2.php';
		require_once __DIR__ . '/widgets/elec-services-page-2.php';
		require_once __DIR__ . '/widgets/elec-price-table-2.php';
		require_once __DIR__ . '/widgets/elec-faqs-tab.php';
		require_once __DIR__ . '/widgets/elec-map.php';
		require_once __DIR__ . '/widgets/elec-contacts.php';
		require_once __DIR__ . '/widgets/elec-newsletter.php';
		require_once __DIR__ . '/widgets/heacool-gallery.php';
		require_once __DIR__ . '/widgets/heacool-contact-page.php';
		require_once __DIR__ . '/widgets/heal-contact-section.php';
		require_once __DIR__ . '/widgets/hl-financing.php';
		require_once __DIR__ . '/widgets/hl-specialize.php';
	}

	/**
	 * Register Widgets
	 *
	 * Register widgets.
	 *
	 * @since 1.2.0
	 * @access public
	 */
	public function register_widgets() {
		// Its is now safe to include Widgets files
		$this->include_widgets_files();
		// Register Widgets
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Main_Slider() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Elec_Services_Icons() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Elec_Services() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Elec_Sevices_Tabs() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Elec_Adds_Services() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Elec_Faqs_One() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Elec_Why_Choose_Us() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Elec_Latst_news_2() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Elec_Banner_2() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Elec_maintanaince_Sec() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Elec_Testimonials_Two() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Elec_Brands_2() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Elec_our_Coupons() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Protection_Packages() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Protection_Packages_Tab() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Elec_About_Us_2() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Elec_Our_Advantage_2() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Elec_Team_2() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Elec_Service_Page_2() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Elec_Price_table_2() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Elec_Faqs_Tabs() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Elec_Map() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Ele_ContactForm7() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Elec_Newsletter() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\HeadeCoolGallery() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\HeacoolContactPage() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\HeacoolContactSection() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Heacool_financing() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Widgets\Heacool_specialize() );
	}
	/**
	 *  Plugin class constructor
	 *
	 * Register plugin action hooks and filters
	 *
	 * @since 1.2.0
	 * @access public
	 */
	public function __construct() {
		// Register widget scripts
		add_action( 'elementor/frontend/after_register_scripts', array( $this, 'widget_scripts' ) );
		// Register widgets
		add_action( 'elementor/widgets/widgets_registered', array( $this, 'register_widgets' ) );
	}
}

// Instantiate Plugin Class
Plugin::instance();


error_reporting( E_ALL );
ini_set( 'display_errors', 1 );
