<?php
// Silence is golden.
add_action(
        'elementor/init', function() {
    \Elementor\Plugin::$instance->elements_manager->add_category(
            'heacool', [
        'title' => __('Heacool', 'heacool-core'),
        'icon' => 'fa fa-plug',
            ], 1
    );
}
);

function heacool_post_thumbnail_image($size = 'full') {
    $heacool_featured_image_url = get_the_post_thumbnail_url(get_the_ID(), 'heacool_galleries_home');
    ?>
    <picture>
        <source type="image/jpeg" srcset="<?php echo esc_url($heacool_featured_image_url); ?>">
        <img src="<?php echo esc_url($heacool_featured_image_url); ?>" alt="<?php esc_attr_e('Img', 'heacool-core'); ?>">
    </picture>
    <?php
}

if (!function_exists('heacool_custom_icon')) {

    function heacool_custom_icon($array) {

        $plugin_url = plugins_url();

        return array('custom-icon' => Array(
                'name' => 'custom-icon',
                'label' => 'Heacool Icon',
                'url' => '',
                'enqueue' => Array
                    (
                    $plugin_url . '/heacool-core/heacool-addons/icon/style.css',
                ),
                'prefix' => '',
                'displayPrefix' => '',
                'labelIcon' => 'fab fa-font-awesome-alt',
                'ver' => '5.9.0',
                'fetchJson' => $plugin_url . '/heacool-core/heacool-addons/assets/js/regular.js',
                'native' => 1,
        ));
    }

}
add_filter('elementor/icons_manager/additional_tabs', 'heacool_custom_icon');

function heacool_get_allowed_html_tags($level = 'basic') {
    $allowed_html = [
        'b' => [],
        'i' => [],
        'u' => [],
        'em' => [],
        'br' => [],
        'abbr' => [
            'title' => [],
        ],
        'span' => [
            'class' => [],
        ],
        'strong' => [],
    ];

    if ($level === 'intermediate') {
        $allowed_html['a'] = [
            'href' => [],
            'title' => [],
            'class' => [],
            'id' => [],
        ];
    }

    return $allowed_html;
}

/**
 * Strip all the tags except allowed html tags
 *
 * The name is based on inline editing toolbar name
 *
 * @param string $string
 * @return string
 */
function heacool_kses_intermediate($string = '') {
    return wp_kses($string, heacool_get_allowed_html_tags('intermediate'));
}

/**
 * Strip all the tags except allowed html tags
 *
 * The name is based on inline editing toolbar name
 *
 * @param string $string
 * @return string
 */
function heacool_kses_basic($string = '') {
    return wp_kses($string, heacool_get_allowed_html_tags('basic'));
}

function heacool_get_allowed_html_desc($level = 'basic') {
    if (!in_array($level, ['basic', 'intermediate'])) {
        $level = 'basic';
    }

    $tags_str = '<' . implode('>,<', array_keys(heacool_get_allowed_html_tags($level))) . '>';
    return sprintf(__('This input field has support for the following HTML tags: %1$s', 'heacool-core'), '<code>' . esc_html($tags_str) . '</code>');
}

function get_elementor_library() {
    $pageslist = get_posts(
            array(
                'post_type' => 'elementor_library',
                'posts_per_page' => -1,
            )
    );
    $pagearray = array();
    if (!empty($pageslist)) {
        foreach ($pageslist as $page) {
            $pagearray[$page->ID] = $page->post_title;
        }
    }
    return $pagearray;
}

if (!function_exists('heacool_comments_count')) :

    /**
     * Displays an optional post thumbnail.
     *
     * Wraps the post thumbnail in an anchor element on index views, or a div
     * element when on single views.
     */
    function heacool_comments_count() {

        if (get_comments_number(get_the_ID()) > 1) {
            $comments_count = sprintf(
                    /* translators: %s: post date. */
                    esc_html('%s'), get_comments_number(get_the_ID()) . " comments");
        } else {
            $comments_count = sprintf(
                    /* translators: %s: post date. */
                    esc_html('%s'), get_comments_number(get_the_ID()) . " comment");
        }
        echo ' ' . $comments_count;
    }

endif;


if (!function_exists('heacool_posted_on')) :

    /**
     * Prints HTML with meta information for the current post-date/time.
     */
    function heacool_posted_on() {
        $time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
        if (get_the_time('U') !== get_the_modified_time('U')) {
            $time_string = '<time class="updated" datetime="%3$s">%4$s</time>';
        }
        $time_string = sprintf($time_string, esc_attr(get_the_date(DATE_W3C)), esc_html(get_the_date()), esc_attr(get_the_modified_date(DATE_W3C)), esc_html(get_the_modified_date())
        );
        $posted_on = sprintf(
                /* translators: %s: post date. */
                esc_html('%s'), '<a href="' . esc_url(get_permalink()) . '" rel="bookmark">' . $time_string . '</a>'
        );
        echo $posted_on; // WPCS: XSS OK.
    }

endif;


if (!function_exists('heacool_slider_controls')) {

    function heacool_slider_controls($obj, $slidesToShow = 3, $slidesToScroll = 1, $infinite = 'yes', $autoplay = 'yes', $autoplaySpeed = 6000, $arrows = 'no', $dots = 'yes') {

        $obj->start_controls_section(
                'slider_options', [
            'label' => __('Slider Settings', 'heacool-core'),
                ]
        );

        $obj->add_control(
                'slidesToShow', [
            'label' => __('Slides To Show', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'default' => $slidesToShow
                ]
        );

        $obj->add_control(
                'slidesToScroll', [
            'label' => __('Slides To Show', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'default' => $slidesToScroll
                ]
        );

        $obj->add_control(
                'infinite', [
            'label' => __('Infinite', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'default' => $infinite
                ]
        );

        $obj->add_control(
                'autoplay', [
            'label' => __('Autoplay', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'default' => $autoplay
                ]
        );

        $obj->add_control(
                'autoplaySpeed', [
            'label' => __('Autoplay Speed', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'default' => $autoplaySpeed,
                ]
        );

        $obj->add_control(
                'arrows', [
            'label' => __('Array', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'default' => $arrows
                ]
        );

        $obj->add_control(
                'dots', [
            'label' => __('Dots', 'heacool-core'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'default' => $dots
                ]
        );

        $obj->end_controls_section();
    }

}


if (!function_exists('heacool_slider_controls_settings')) {

    function heacool_slider_controls_settings($settings) {

        $slides_to_show = $settings['slidesToShow'];
        $slides_to_scroll = $settings['slidesToScroll'];

        if ($settings['infinite'] == 'yes') {
            $infinite = 'true';
        } else {
            $infinite = 'false';
        }

        if ($settings['autoplay'] == 'yes') {
            $autoplay = 'true';
        } else {
            $autoplay = 'false';
        }

        $autoplay_speed = $settings['autoplaySpeed'];

        if ($settings['arrows'] == 'yes') {
            $arrows = 'true';
        } else {
            $arrows = 'false';
        }

        if ($settings['dots'] == 'yes') {
            $dots = 'true';
        } else {
            $dots = 'false';
        }
        
        return array(
            'mobile_first' => 'false',
            'slides_to_show' => $slides_to_show,
            'slides_to_scroll' => $slides_to_scroll,
            'infinite' => $autoplay,
            'autoplay' => $autoplay,
            'autoplay_speed' => $autoplay_speed,
            'arrows' => $arrows,
            'dots' => $dots
        );
    }

}

function heacool_query_vars($qvars) {
    $qvars[] = 'pageid';
    return $qvars;
}

add_filter('query_vars', 'heacool_query_vars');


