(function($) {
    "use strict";


    // Lazyload Images
    var mainSlider = function($scope, $) {
        if(!$('.banner-slider').hasClass('slick-initialized')){
        if ($('.banner-slider').length > 0) {
            $('.banner-slider').slick({
                slidesToShow: 2,
                slidesToScroll: 2,
                autoplay: true,
                dots: false,
                arrows: false,
                autoplaySpeed: 4000,
                infinite: true,
                responsive: [{
                        breakpoint: 1200,
                        settings: {
                            slidesToShow: 2,
                            slidesToScroll: 2
                        }
                    },
                    {
                        breakpoint: 991,
                        settings: {
                            slidesToShow: 2,
                            slidesToScroll: 2
                        }
                    },
                    {
                        breakpoint: 768,
                        settings: {
                            slidesToShow: 2,
                            slidesToScroll: 2
                        }
                    },
                    {
                        breakpoint: 576,
                        settings: {
                            slidesToShow: 2,
                            slidesToScroll: 2
                        }
                    },
                    {
                        breakpoint: 480,
                        settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1
                        }
                    }
                    // You can unslick at a given breakpoint now by adding:
                    // settings: "unslick"
                    // instead of a settings object
                ]
            });
            }
        }
    };

    var serviceTabSlider = function($scope, $) {
        if(!$('.srvs_slider').hasClass('slick-initialized')){
        if ($('.srvs_slider').length) {
            $('.srvs_slider').slick({
                slidesToShow: 5,
                slidesToScroll: 2,
                autoplay: false,
                dots: true,
                arrows: false,
                autoplay: true,
                autoplaySpeed: 5000,
                infinite: true,
                responsive: [{
                        breakpoint: 1366,
                        settings: {
                            slidesToShow: 4,
                            slidesToScroll: 3
                        }
                    },
                    {
                        breakpoint: 1200,
                        settings: {
                            slidesToShow: 3,
                            slidesToScroll: 3
                        }
                    },
                    {
                        breakpoint: 991,
                        settings: {
                            slidesToShow: 3,
                            slidesToScroll: 3,
                            arrows: false
                        }
                    },
                    {
                        breakpoint: 768,
                        settings: {
                            slidesToShow: 2,
                            slidesToScroll: 2,
                            dots: true
                        }
                    },
                    {
                        breakpoint: 576,
                        settings: {
                            slidesToShow: 2,
                            slidesToScroll: 2,
                            dots: true
                        }
                    },
                    {
                        breakpoint: 480,
                        settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1,
                            dots: true,
                            vertical: false,
                            autoplay: false,
                            draggable: false,
                            swipeToSlide: false
                        }
                    }
                    // You can unslick at a given breakpoint now by adding:
                    // settings: "unslick"
                    // instead of a settings object
                ]
            });
        }
        }
    };

    var blogCarousel = function($scope, $) {
        if(!$('.blog_carousel').hasClass('slick-initialized')){
        if ($('.blog_carousel').length) {
            $('.blog_carousel').slick({
                slidesToShow: 3,
                slidesToScroll: 3,
                autoplay: true,
                dots: true,
                arrows: true,
                autoplaySpeed: 2000,
                infinite: true,
                responsive: [{
                        breakpoint: 1200,
                        settings: {
                            slidesToShow: 3,
                            slidesToScroll: 3
                        }
                    },
                    {
                        breakpoint: 991,
                        settings: {
                            slidesToShow: 2,
                            slidesToScroll: 2,
                            arrows: false
                        }
                    },
                    {
                        breakpoint: 768,
                        settings: {
                            slidesToShow: 2,
                            slidesToScroll: 2,
                            dots: true
                        }
                    },
                    {
                        breakpoint: 576,
                        settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1,
                            dots: true
                        }
                    },
                    {
                        breakpoint: 480,
                        settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1,
                            dots: true
                        }
                    }
                    // You can unslick at a given breakpoint now by adding:
                    // settings: "unslick"
                    // instead of a settings object
                ]
            });
        }
        }
    };



    var testiCarousel = function($scope, $) {
        if(!$('.testi_carousel').hasClass('slick-initialized')){
        if ($('.testi_carousel').length) {
            $('.testi_carousel').slick({
                slidesToShow: 1,
                slidesToScroll: 1,
                autoplay: false,
                dots: true,
                arrows: false,
                autoplay: true,
                autoplaySpeed: 2000,
                infinite: true,
                responsive: [{
                        breakpoint: 1200,
                        settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1
                        }
                    },
                    {
                        breakpoint: 991,
                        settings: {
                            slidesToShow: 1,
                            slidesToScroll: 2,
                            arrows: false
                        }
                    },
                    {
                        breakpoint: 768,
                        settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1,
                            dots: true,
                            arrows: false
                        }
                    },
                    {
                        breakpoint: 576,
                        settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1,
                            dots: true,
                            arrows: false
                        }
                    },
                    {
                        breakpoint: 480,
                        settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1,
                            dots: true,
                            arrows: false
                        }
                    }
                    // You can unslick at a given breakpoint now by adding:
                    // settings: "unslick"
                    // instead of a settings object
                ]
            });
        }
        }
    };



    var ptCarousel = function($scope, $) {
        if(!$('.pt_carousel').hasClass('slick-initialized')){
        if ($('.pt_carousel').length) {
            $('.pt_carousel').slick({
                slidesToShow: 6,
                slidesToScroll: 2,
                autoplay: false,
                dots: true,
                arrows: true,
                autoplay: true,
                variableWidth: true,
                autoplaySpeed: 2000,
                infinite: true,
                responsive: [{
                        breakpoint: 1200,
                        settings: {
                            slidesToShow: 6,
                            slidesToScroll: 1
                        }
                    },
                    {
                        breakpoint: 991,
                        settings: {
                            slidesToShow: 6,
                            slidesToScroll: 3,
                            arrows: false
                        }
                    },
                    {
                        breakpoint: 768,
                        settings: {
                            slidesToShow: 3,
                            slidesToScroll: 1,
                            dots: true
                        }
                    },
                    {
                        breakpoint: 576,
                        settings: {
                            slidesToShow: 2,
                            slidesToScroll: 1,
                            dots: true
                        }
                    },
                    {
                        breakpoint: 480,
                        settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1,
                            dots: true
                        }
                    }
                    // You can unslick at a given breakpoint now by adding:
                    // settings: "unslick"
                    // instead of a settings object
                ]
            });
        }
        }
    };



    var team_carousel = function($scope, $) {
        if(!$('.team_carousel').hasClass('slick-initialized')){
        if ($('.team_carousel').length) {
            $('.team_carousel').slick({
                slidesToShow: 3,
                slidesToScroll: 1,
                autoplay: false,
                dots: true,
                arrows: true,
                autoplay: true,
                autoplaySpeed: 2000,
                infinite: true,
                responsive: [{
                        breakpoint: 1200,
                        settings: {
                            slidesToShow: 3,
                            slidesToScroll: 1
                        }
                    },
                    {
                        breakpoint: 991,
                        settings: {
                            slidesToShow: 3,
                            slidesToScroll: 1
                        }
                    },
                    {
                        breakpoint: 768,
                        settings: {
                            slidesToShow: 2,
                            slidesToScroll: 1,
                            dots: true
                        }
                    },
                    {
                        breakpoint: 576,
                        settings: {
                            slidesToShow: 2,
                            slidesToScroll: 1,
                            dots: true
                        }
                    },
                    {
                        breakpoint: 480,
                        settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1,
                            dots: true
                        }
                    }
                    // You can unslick at a given breakpoint now by adding:
                    // settings: "unslick"
                    // instead of a settings object
                ]
            });
        }
        }
    };



    var bulbSlider = function($scope, $) {
        if ($('.bulb-carousel').length) {
            var bulb_obj = $('.bulb-carousel').data('slick');
            $('.bulb-carousel').slick({
                mobileFirst: JSON.parse(bulb_obj.mobile_first),
                slidesToShow: parseInt(bulb_obj.slides_to_show),
                slidesToScroll: parseInt(bulb_obj.slides_to_scroll),
                infinite: JSON.parse(bulb_obj.infinite),
                autoplay: JSON.parse(bulb_obj.autoplay),
                autoplaySpeed: parseInt(bulb_obj.autoplay_speed),
                arrows: JSON.parse(bulb_obj.arrows),
                dots: JSON.parse(bulb_obj.dots),
                responsive: [{
                        breakpoint: 991,
                        settings: {
                            slidesToShow: 2
                        },
                    },
                    {
                        breakpoint: 767,
                        settings: {
                            slidesToShow: 2
                        },
                    },
                    {
                        breakpoint: 480,
                        settings: {
                            slidesToShow: 1
                        },
                    }
                ]
            });
        }
    };

    var testimonials_1 = function($scope, $) {
        if ($('.testimonials-carousel').length) {
            // slider
            $('.testimonials-carousel').slick({
                mobileFirst: false,
                slidesToShow: 1,
                slidesToScroll: 1,
                infinite: true,
                autoplay: true,
                autoplaySpeed: 5000,
                //rtl: plugins.rtltrue,
                arrows: false,
                dots: true
            });
        }
    };

    var counterCarousel = function($scope, $) {
        if ($('.counter-carousel').length) {
            $('.counter-carousel').slick({
                mobileFirst: false,
                slidesToShow: 4,
                slidesToScroll: 1,
                infinite: false,
                autoplay: true,
                autoplaySpeed: 4000,
                arrows: false,
                dots: true,
                responsive: [{
                    breakpoint: 991,
                    settings: {
                        slidesToShow: 2
                    },
                }, {
                    breakpoint: 767,
                    settings: {
                        slidesToShow: 2
                    },
                }, {
                    breakpoint: 480,
                    settings: {
                        slidesToShow: 1
                    },
                }]
            });
        }
    };

    var brandCarousel = function($scope, $) {
        if ($('.counter-carousel').length) {
            $('.counter-carousel').slick({
                mobileFirst: false,
                slidesToShow: 7,
                slidesToScroll: 1,
                infinite: true,
                autoplay: true,
                autoplaySpeed: 2000,
                //rtl: plugins.rtltrue,
                arrows: false,
                dots: true,
                //variableWidth: !plugins.rtltrue,
                responsive: [{
                        breakpoint: 991,
                        settings: {
                            slidesToShow: 5
                        },
                    },
                    {
                        breakpoint: 767,
                        settings: {
                            slidesToShow: 3
                        },
                    },
                    {
                        breakpoint: 480,
                        settings: {
                            slidesToShow: 1,
                            arrows: false
                        },
                    }
                ]
            });
        }
    };


    $(window).on('elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction('frontend/element_ready/electrician-main-slider.default', mainSlider);
        elementorFrontend.hooks.addAction('frontend/element_ready/centre-sevices_tabs.default', serviceTabSlider);
        elementorFrontend.hooks.addAction('frontend/element_ready/elec_latest_news_2.default', blogCarousel);
        elementorFrontend.hooks.addAction('frontend/element_ready/electrician-testimonials-2.default', testiCarousel);
        elementorFrontend.hooks.addAction('frontend/element_ready/electrician-brands-2.default', ptCarousel);
        elementorFrontend.hooks.addAction('frontend/element_ready/electrician-team-2.default', team_carousel);
    });
})(jQuery);