<?php
/**
 * Product Loop Start
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/loop/loop-start.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see        https://docs.woocommerce.com/document/template-structure/
 * @author        WooThemes
 * @package    WooCommerce/Templates
 * @version     3.3.0
 */
global $woocommerce_loop, $g5plus_woocommerce_loop;

$columns = isset($g5plus_woocommerce_loop['columns']) ? $g5plus_woocommerce_loop['columns'] : '';
if ( ! isset( $columns ) || empty( $columns ) ) {
	$columns = $woocommerce_loop['columns'];
}


$class                  = array();
$class[]                = 'product-listing woocommerce clearfix';
$archive_product_layout = isset( $g5plus_woocommerce_loop['layout'] ) ? $g5plus_woocommerce_loop['layout'] : '';
$masonry                = isset( $g5plus_woocommerce_loop['masonry'] ) ? $g5plus_woocommerce_loop['masonry'] : '';
if ( $archive_product_layout == 'slider' ) {
	$class[] = 'product-slider';
} else {
	if ( $masonry == '' ) {
		$class[] = 'columns-' . $columns;
	}
}

$class_names = join( ' ', $class );

if ( $archive_product_layout == 'slider' ) {


	$autoPlay = isset( $g5plus_woocommerce_loop['autoPlay'] ) ? $g5plus_woocommerce_loop['autoPlay'] : 'false';

	$autoplayTimeout = isset($g5plus_woocommerce_loop['autoplayTimeout']) ? $g5plus_woocommerce_loop['autoplayTimeout'] : 5000;

	$autoHeight = isset( $g5plus_woocommerce_loop['autoHeight'] ) ? $g5plus_woocommerce_loop['autoHeight'] : 'false';

	$transitionStyle = isset( $g5plus_woocommerce_loop['transitionStyle'] ) ? $g5plus_woocommerce_loop['transitionStyle'] : 'false';


	$owl_wrap_args = array(
		'items'      => $columns,
		'autoplay'   => $autoPlay === 'true',
		'autoplayTimeout' => $autoplayTimeout,
		'autoHeight' => $autoHeight === 'true',
		'dots' => false,
		'nav' => true,
		'responsive' => array(
			0 => array(
				'items' => $columns < 2 ? $columns : 2,
			),
			480 => array(
				'items' => $columns < 2 ? $columns : 2,
			),
			768 => array(
				'items' => $columns < 3 ? $columns : 3,
			),
			992 => array(
				'items' => $columns < 4 ? $columns : 4,
			),
			1200 => array(
				'items' => $columns,
			),
		),
	);


	if ( $transitionStyle != 'false' ) {
		$owl_wrap_args = array_merge( array(
			'animateOut' => "owl-{$transitionStyle}-out",
			'animateIn'  => "owl-{$transitionStyle}-in"
		), $owl_wrap_args );
	}
}

?>
<div class="<?php echo esc_attr( $class_names ); ?>">
	<?php if ( $archive_product_layout == 'slider' ) : ?>
	<div data-toggle="carousel" class="owl-carousel" data-plugin-options='<?php echo json_encode($owl_wrap_args); ?>'>
		<?php endif; ?>
