<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 6/6/2015
 * Time: 2:10 PM
 */

$opt_social_sharing = g5plus_get_option('social_sharing',array(
	'facebook' => '1',
	'twitter' => '1',
	'linkedin' => '1',
	'tumblr' => '1',
	'pinterest' => '1'
));
$sharing_facebook = isset($opt_social_sharing['facebook']) ? $opt_social_sharing['facebook'] : 0;
$sharing_twitter = isset($opt_social_sharing['twitter']) ? $opt_social_sharing['twitter'] : 0;
$sharing_linkedin = isset($opt_social_sharing['linkedin']) ? $opt_social_sharing['linkedin'] : 0;
$sharing_tumblr = isset($opt_social_sharing['tumblr']) ? $opt_social_sharing['tumblr'] : 0;
$sharing_pinterest = isset($opt_social_sharing['pinterest']) ? $opt_social_sharing['pinterest'] : 0;


if (($sharing_facebook == 1) ||
($sharing_twitter == 1) ||
($sharing_linkedin == 1) ||
($sharing_tumblr == 1) ||
($sharing_pinterest == 1)
) :
$page_permalink = get_permalink();
$page_title = get_the_title();

?>
    <div class="social-share-wrap">
        <label><?php esc_html_e("Share:",'g5plus-handmade'); ?></label>
        <ul class="social-share">
            <?php if ($sharing_facebook == 1) : ?>
                <?php
	                $link = "https://www.facebook.com/sharer.php?u=" . urlencode($page_permalink);
	                $icon = 'fa fa-facebook';
	                $attributes = array();
	                $attributes[] = sprintf( 'href="%s"', $link );
	                $attributes[] = 'target="_blank"';
	                $attributes[] = 'rel="nofollow"';
	            ?>
                <li>
	                <a <?php echo join( ' ', $attributes ) ?>>
		                <i class="<?php echo esc_attr($icon); ?>"></i>
	                </a>
                </li>
            <?php endif; ?>

            <?php if ($sharing_twitter == 1) :  ?>
	            <?php
	            $link  = "https://twitter.com/share?text=" . $page_title . "&url=" . urlencode($page_permalink) . "";
	            $icon = 'fa fa-twitter';
	            $attributes = array();
	            $attributes[] = 'target="_blank"';
	            $attributes[] = sprintf( 'href="%s"', $link );
	            $attributes[] = 'rel="nofollow"';
	            ?>
	            <li>
		            <a <?php echo join( ' ', $attributes ) ?>>
			            <i class="<?php echo esc_attr($icon); ?>"></i>
		            </a>
	            </li>
            <?php endif; ?>

            <?php if ($sharing_linkedin == 1):?>
	            <?php
	            $link = "http://www.linkedin.com/shareArticle?mini=true&url=" . urlencode($page_permalink) . "&title=" . $page_title;
	            $icon = 'fa fa-linkedin';
	            $attributes = array();
	            $attributes[] = 'target="_blank"';
	            $attributes[] = sprintf( 'href="%s"', $link );
	            $attributes[] = 'rel="nofollow"';
	            ?>
	            <li>
		            <a <?php echo join( ' ', $attributes ) ?>>
			            <i class="<?php echo esc_attr($icon); ?>"></i>
		            </a>
	            </li>
            <?php endif; ?>

            <?php if ($sharing_tumblr == 1) :  ?>
	            <?php
	            $link = "http://www.tumblr.com/share/link?url=" . urlencode($page_permalink) . "&name=" . $page_title;
	            $icon = 'fa fa-tumblr';
	            $attributes = array();
	            $attributes[] = 'target="_blank"';
	            $attributes[] = sprintf( 'href="%s"', $link );
	            $attributes[] = 'rel="nofollow"';
	            ?>
	            <li>
		            <a <?php echo join( ' ', $attributes ) ?>>
			            <i class="<?php echo esc_attr($icon); ?>"></i>
		            </a>
	            </li>
            <?php endif; ?>

            <?php if ($sharing_pinterest == 1) :  ?>
	            <?php
	            $_img_src = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
	            $link = "http://pinterest.com/pin/create/button/?url=" . urlencode($page_permalink) . '&media=' . (($_img_src === false) ? '' :  $_img_src[0]) . "&description=" . $page_title;
	            $icon = 'fa fa-pinterest';
	            $attributes = array();
	            $attributes[] = sprintf( 'href="%s"', $link );
	            $attributes[] = 'target="_blank"';
	            $attributes[] = 'rel="nofollow"';
	            ?>
	            <li>
		            <a <?php echo join( ' ', $attributes ) ?>>
			            <i class="<?php echo esc_attr($icon); ?>"></i>
		            </a>
	            </li>
            <?php endif; ?>
        </ul>
    </div>
<?php endif;