<?php
/*---------------------------------------------------
/* COMMENT FIELDS
/*---------------------------------------------------*/
if (!function_exists('g5plus_comment_fields')) {
	function g5plus_comment_fields($fields){

		$commenter = wp_get_current_commenter();
		$req      = get_option( 'require_name_email' );
		$aria_req = ( $req ? " aria-required='true'" : '' );
		$html_req = ( $req ? " required='required'" : '' );
		$html5 = current_theme_supports('html5', 'comment-form') ? 'html5' : 'xhtml';;

		$fields   =  array(
			'author' => '<p class="comment-form-author">' . '<label for="author">' . esc_html__('Name','g5plus-handmade') . ( $req ? ' <span class="required">*</span>' : '' ) . '</label> ' .
				'<input placeholder="'. esc_html__('Name','g5plus-handmade') .'" id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30" maxlength="245"' . $aria_req . $html_req . ' /></p>',
			'email'  => '<p class="comment-form-email"><label for="email">' . esc_html__('Email','g5plus-handmade') . ( $req ? ' <span class="required">*</span>' : '' ) . '</label> ' .
				'<input placeholder="'. esc_html__('Email','g5plus-handmade') .'" id="email" name="email" ' . ( $html5 ? 'type="email"' : 'type="text"' ) . ' value="' . esc_attr(  $commenter['comment_author_email'] ) . '" size="30" maxlength="100" aria-describedby="email-notes"' . $aria_req . $html_req  . ' /></p>',
			//'url'    => '<p class="comment-form-url"><label for="url">' . esc_html__('Website','g5plus-handmade') . '</label> ' .
			//	'<input placeholder="'. esc_html__('Website','g5plus-handmade') .'"  id="url" name="url" ' . ( $html5 ? 'type="url"' : 'type="text"' ) . ' value="' . esc_attr( $commenter['comment_author_url'] ) . '" size="30" maxlength="200" /></p>',
		);
		return $fields;
	}
	add_filter('comment_form_default_fields','g5plus_comment_fields');
}

/*---------------------------------------------------
/* COMMENT FORMS ARGS
/*---------------------------------------------------*/
if (!function_exists('g5plus_comment_form_args')) {
	function g5plus_comment_form_args($comment_form_args) {
		$defaults = array(
			'comment_field' => '<p class="comment-form-comment"><label for="comment">' . esc_html__('Comment','g5plus-handmade') . '</label> <textarea placeholder="'. esc_html__('Comment','g5plus-handmade') .'" id="comment" name="comment" cols="45" rows="8" maxlength="65525" aria-required="true" required="required"></textarea></p>',
			'label_submit' => esc_html__('Send us now','g5plus-handmade'),
			'class_submit' => 'handmade-button style1 button-2x'
		);

		$comment_form_args = wp_parse_args($defaults,$comment_form_args);
		return $comment_form_args;
	}
	add_filter('comment_form_defaults','g5plus_comment_form_args');
}

/*---------------------------------------------------
/* SET ONE PAGE MENU
/*---------------------------------------------------*/
if (!function_exists('g5plus_main_menu_one_page_filter')) {
	function g5plus_main_menu_one_page_filter($args) {
		if (isset($args['theme_location']) && ($args['theme_location'] != 'primary') && ($args['theme_location'] != 'mobile')) {
			return $args;
		}
		$prefix = 'g5plus_';
		$is_one_page = g5plus_rwmb_meta($prefix . 'is_one_page');
		if ($is_one_page == '1') {
			$args['menu_class'] .= ' menu-one-page';
		}
		return $args;
	}
	add_filter('wp_nav_menu_args','g5plus_main_menu_one_page_filter', 20);
}


function add_query_vars_filter( $vars ){
	$vars[] = "custom-page";
	return $vars;
}
add_filter( 'query_vars', 'add_query_vars_filter' );

/*---------------------------------------------------
/* ADD SEARCH FORM TO BEFORE X-MENU
/*---------------------------------------------------*/
if (!function_exists('g5plus_search_form_before_menu_mobile')) {
	function g5plus_search_form_before_menu_mobile($params) {
		ob_start();
		?>
		<form class="search-form-menu-mobile"  method="get" action="<?php echo esc_url(site_url()); ?>">
			<input type="search" name="s" placeholder="<?php esc_html_e('Search...','g5plus-handmade'); ?>">
			<button type="submit"><i class="fa fa-search"></i></button>
		</form>
		<?php
		$params .= ob_get_clean();

		return $params;
	}
	add_filter('g5plus_before_menu_mobile_filter','g5plus_search_form_before_menu_mobile', 10);
}

/*---------------------------------------------------
/* ADD FILE TYPE
/*---------------------------------------------------*/
if (!function_exists('g5plus_upload_types')) {
	function g5plus_upload_types($existing_mimes=array()){
		$existing_mimes['svg'] = 'image/svg+xml';
		return $existing_mimes;
	}
	add_filter('upload_mimes', 'g5plus_upload_types');
}

// STICKY LOGO
if (!function_exists('g5plus_sticky_logo')) {
	function g5plus_sticky_logo($agrs){
		global  $g5plus_header_layout;
		if (in_array($g5plus_header_layout, array('header-3','header-5', 'header-9'))) {
			return $agrs;
		}

		$prefix = 'g5plus_';

		$logo_sticky_meta_id = g5plus_rwmb_meta($prefix . 'sticky_logo');
		$logo_sticky_meta = g5plus_rwmb_meta($prefix . 'sticky_logo', 'type=image_advanced');

		$logo_sticky = '';
		if ($logo_sticky_meta !== array() && isset($logo_sticky_meta[$logo_sticky_meta_id]) && isset($logo_sticky_meta[$logo_sticky_meta_id]['full_url'])) {
			$logo_sticky = $logo_sticky_meta[$logo_sticky_meta_id]['full_url'];
		}
		if (empty($logo_sticky)) {
			$opt_sticky_logo = g5plus_get_option('sticky_logo', array(
				'url' => THEME_URL . 'assets/images/theme-options/logo.png'
			));
			$opt_logo = g5plus_get_option('logo',array(
				'url' => THEME_URL . 'assets/images/theme-options/logo.png'
			));

			if ( isset($opt_sticky_logo['url'])) {
				$logo_sticky = $opt_sticky_logo['url'];
			}
			else if ( isset($opt_logo['url'])) {
				$logo_sticky = $opt_logo['url'];
			}
		}

		if (!empty($logo_sticky)) {
			ob_start();
			?>
				<li class="logo-sticky">
					<a  href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?> - <?php bloginfo( 'description' ); ?>">
						<img src="<?php echo esc_url($logo_sticky); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?> - <?php bloginfo( 'description' ); ?>" />
					</a>
				</li>
			<?php

			$agrs .= ob_get_clean();
		}

		return $agrs;
	}
	add_filter('xmenu_primary_filter_before', 'g5plus_sticky_logo');
}

if (!function_exists('g5plus_editor_stylesheets')) {
    function g5plus_editor_stylesheets($stylesheets) {
        $screen = get_current_screen();
        $post_id = '';
        if ( is_admin() && ($screen->id == 'post') ) {
            global $post;
            $post_id = $post->ID;
        }
        $stylesheets[] =  THEME_URL . 'assets/plugins/fonts-awesome/css/font-awesome.min.css';
        $stylesheets[] = admin_url('admin-ajax.php') . '?action=gsf_custom_css_editor&post_id=' . $post_id;
	    $fonts_url = g5plus_get_fonts_url();
	    $stylesheets[] = $fonts_url;
        return $stylesheets;
    }
    add_filter( 'editor_stylesheets', 'g5plus_editor_stylesheets', 99 );
}



if (!function_exists('g5plus_widget_categories_args')) {
	function g5plus_widget_categories_args($cat_args) {
		$cat_args['taxonomy'] = 'category';
		return $cat_args;
	}
	add_filter('widget_categories_args', 'g5plus_widget_categories_args');
}


if (!function_exists('g5plus_cat_count_span')) {
	function g5plus_cat_count_span($links, $args) {
		if (isset($args['taxonomy']) && ($args['taxonomy'] == 'category')) {
			$links = str_replace('(', '<span class="count">(', $links);
			$links = str_replace(')', ')</span>', $links);
		}
		return $links;
	}
	add_filter('wp_list_categories','g5plus_cat_count_span',10,2);
}

if (!function_exists('g5plus_archive_count_span')) {
	function g5plus_archive_count_span($links) {
		$links = str_replace('&nbsp;(', '<span class="count">(', $links);
		$links = str_replace(')', ')</span>', $links);
		return $links;
	}
	add_filter('get_archives_link', 'g5plus_archive_count_span');
}



