<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 6/1/2015
 * Time: 6:16 PM
 */
/*================================================
LOAD STYLESHEETS
================================================== */
if (!function_exists('g5plus_enqueue_styles')) {
	function g5plus_enqueue_styles() {
		$enable_minifile_css = g5plus_get_option('enable_minifile_css','0');
		$min_suffix = ($enable_minifile_css == 1) ? '.min' :  '';

		/*font-awesome*/
		$url_font_awesome = THEME_URL . 'assets/plugins/fonts-awesome/css/font-awesome.min.css';
		$cdn_font_awesome = g5plus_get_option('cdn_font_awesome','');
		if (!empty($cdn_font_awesome)) {
			$url_font_awesome = $cdn_font_awesome;
		}
		wp_enqueue_style('g5plus_framework_font_awesome', $url_font_awesome, array(),'4.6.3');
		wp_enqueue_style('g5plus_framework_font_awesome_animation', THEME_URL . 'assets/plugins/fonts-awesome/css/font-awesome-animation.min.css', array());

		/*bootstrap*/
		$cdn_bootstrap_css = g5plus_get_option('cdn_bootstrap_css');
		if (!empty($cdn_bootstrap_css)) {
			wp_enqueue_style('g5plus_framework_bootstrap', $cdn_bootstrap_css, array());
		} else {
			wp_enqueue_style('bootstrap',  THEME_URL . 'assets/plugins/bootstrap/css/bootstrap.min.css', array(),'3.4.1');
		}


		/*pe-icon-7-stroke*/
		wp_enqueue_style('g5plus_framework_pe_icon_7_stroke', THEME_URL . 'assets/plugins/pe-icon-7-stroke/css/styles'.$min_suffix.'.css', array());

		/*owl-carousel*/
		wp_enqueue_script('owl-carousel', THEME_URL . 'assets/plugins/owl-carousel/owl.carousel'.$min_suffix.'.js',array('jquery'),'2.3.4',true);
		wp_enqueue_style('owl-carousel-transitions',THEME_URL . 'assets/plugins/owl-carousel/assets/owl.transitions'.$min_suffix.'.css',array(),'2.3.4');
		wp_enqueue_style('owl-carousel-theme',THEME_URL . 'assets/plugins/owl-carousel/assets/owl.theme.default'.$min_suffix.'.css',array(),'2.3.4');
		wp_enqueue_style('owl-carousel',THEME_URL . 'assets/plugins/owl-carousel/assets/owl.carousel'.$min_suffix.'.css',array(),'2.3.4');

		/*prettyPhoto*/
		wp_enqueue_style('g5plus_framework_prettyPhoto', THEME_URL . 'assets/plugins/prettyPhoto/css/prettyPhoto'.$min_suffix.'.css', array());

		/*peffect_scrollbar*/
		wp_enqueue_style('g5plus_framework_peffect_scrollbar', THEME_URL . 'assets/plugins/perfect-scrollbar/css/perfect-scrollbar.min.css', array());


		wp_enqueue_script( 'g5plus-jplayer-js', THEME_URL . 'assets/plugins/jquery.jPlayer/jquery.jplayer.min.js', array( 'jquery' ), '', true );
		wp_enqueue_style( 'g5plus-jplayer-css', THEME_URL . 'assets/plugins/jquery.jPlayer/skin/g5plus/skin'.$min_suffix.'.css', array(), true );


		if (!(defined('G5PLUS_SCRIPT_DEBUG') && G5PLUS_SCRIPT_DEBUG)) {
			wp_enqueue_style('g5plus_framework_style', THEME_URL . 'style'.$min_suffix.'.css');

		}
        wp_enqueue_style('g5plus_framework_vc_customize_css', THEME_URL . 'assets/vc-extend/css/vc-customize'.$min_suffix.'.css');

		$enable_rtl_mode = g5plus_get_option('enable_rtl_mode','0');
		if (is_rtl() || $enable_rtl_mode == '1' || isset($_GET['RTL'])) {
			wp_enqueue_style('g5plus_framework_rtl', THEME_URL . 'assets/css/rtl'.$min_suffix.'.css');
		}

		if (!class_exists('g5plusFrameWork')) {
			$fonts_url = g5plus_get_fonts_url();
			$fonts_css = g5plus_get_fonts_css();
			wp_enqueue_style('google-fonts',$fonts_url);
			wp_add_inline_style('google-fonts',$fonts_css);

			$custom_css_redux = g5plus_custom_css_redux();
			wp_add_inline_style('g5plus_framework_vc_customize_css',$custom_css_redux);
		}
	}
	add_action('wp_enqueue_scripts', 'g5plus_enqueue_styles',11);
}

/*================================================
LOAD SCRIPTS
================================================== */
if (!function_exists('g5plus_enqueue_script')) {
	function g5plus_enqueue_script() {
		$enable_minifile_js = g5plus_get_option('enable_minifile_js','0');
		$min_suffix = ($enable_minifile_js == 1) ? '.min' :  '';

		/*bootstrap*/
		$cdn_bootstrap_js = g5plus_get_option('cdn_bootstrap_js');
		if (!empty($cdn_bootstrap_js)) {
			wp_enqueue_script('g5plus_framework_bootstrap', $cdn_bootstrap_js, array('jquery'), false, true);
		} else {
			wp_enqueue_script('bootstrap', THEME_URL . 'assets/plugins/bootstrap/js/bootstrap.min.js', array('jquery'), '3.4.1', true);
		}


		if (is_single()) {
			wp_enqueue_script('comment-reply');
		}

		/*plugins*/
		wp_enqueue_script('g5plus_framework_plugins', THEME_URL . 'assets/js/plugin'.$min_suffix.'.js', array(), false, true);

		wp_enqueue_script('g5plus_framework_app', THEME_URL . 'assets/js/main' . $min_suffix . '.js', array(), false, true);
		wp_localize_script('g5plus_framework_app','g5plus_framework_vars',array(
			'ajax_url' => admin_url( 'admin-ajax.php?activate-multi=true' ),
			'theme_url' => THEME_URL,
			'site_url' => site_url(),
			'product_compare' => esc_html__('Compare', 'g5plus-handmade'),
			'product_wishList' => esc_html__('WishList', 'g5plus-handmade')
		));

	}
	add_action('wp_enqueue_scripts', 'g5plus_enqueue_script');
}

/* CUSTOM CSS OUTPUT
	================================================== */
if(!function_exists('g5plus_enqueue_custom_css')){
    function g5plus_enqueue_custom_css() {
        $custom_css = g5plus_get_option('custom_css');
        if ( $custom_css ) {
	        echo '<style id="g5plus_custom_style" type="text/css"></style>';
            echo sprintf('<style type="text/css">%s %s</style>',"\n",$custom_css);
        }
    }
    add_action( 'wp_head', 'g5plus_enqueue_custom_css' );
}

/* CUSTOM JS OUTPUT
	================================================== */
if(!function_exists('g5plus_enqueue_custom_script')){
    function g5plus_enqueue_custom_script() {
        $custom_js = g5plus_get_option('custom_js');
        if ( $custom_js ) {
            echo sprintf('<script type="text/javascript">%s</script>',$custom_js);
        }
    }
    add_action( 'wp_footer', 'g5plus_enqueue_custom_script' );
}

if (!function_exists('g5plus_woocompare_custom_style')) {
	function g5plus_woocompare_custom_style() {
		$action = isset($_GET['action']) ? $_GET['action'] : '';
		if ($action == 'yith-woocompare-view-table') {
			$custom_css = '
			.woocommerce-compare-page h1 {
				font-size: 24px;
				background-color: #f7f7f7;
				color: #333333;
			}';
			echo '<style id="g5plus_woocompare_custom_style" type="text/css"></style>';
			echo sprintf('<style type="text/css">%s %s</style>',"\n",$custom_css);
		}

	}
	add_action('wp_print_footer_scripts','g5plus_woocompare_custom_style');
}
