<?php
add_action( 'wp_enqueue_scripts', 'child_theme_enqueue_styles', 1000 );
function child_theme_enqueue_styles() {
    wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/style.css', array( 'g5plus_framework_style' ) );
}

add_action( 'after_setup_theme', 'g5plus_child_theme_setup');
function g5plus_child_theme_setup(){
    $language_path = get_stylesheet_directory() .'/languages';
    if(is_dir($language_path)){
        load_child_theme_textdomain('g5plus-handmade', $language_path );
    }
}
add_action( 'after_switch_theme', 'g5plus_child_after_switch_theme',1 );
function g5plus_child_after_switch_theme() {
	$sidebars_widgets =  get_theme_mod('sidebars_widgets');
	foreach ($sidebars_widgets['data'] as $k => $v) {
		if (!is_array($v)) {
			unset($sidebars_widgets['data'][$k]);
		}
	}
	set_theme_mod('sidebars_widgets', $sidebars_widgets);
}
// if you want to add some custom function
