<?php

add_action( 'admin_init', 'gridlove_buddy_compatibility' );

function gridlove_buddy_compatibility() {

	if ( is_admin() && current_user_can( 'activate_plugins' ) && !gridlove_buddy_is_theme_active() ) {

		add_action( 'admin_notices', 'gridlove_buddy_compatibility_notice' );

		deactivate_plugins( GRIDLOVE_BUDDY_BASENAME );

		if ( isset( $_GET['activate'] ) ) {
			unset( $_GET['activate'] );
		}
	}
}

function gridlove_buddy_compatibility_notice() {
	echo '<div class="notice notice-warning"><p><strong>Note:</strong> Gridlove Buddy plugin has been deactivated as it requires Gridlove Theme to be active.</p></div>';
}

function gridlove_buddy_is_theme_active() {
	return defined( 'GRIDLOVE_THEME_VERSION' );
}

?>
