<!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width,initial-scale=1.0">
	<?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<link rel="profile" href="https://gmpg.org/xfn/11" />
	<?php endif; ?>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<?php if (  function_exists( 'wp_body_open' ) ): ?>
		<?php wp_body_open(); ?>
	<?php else : ?>
		<?php do_action( 'wp_body_open' ); ?>
	<?php endif; ?>
	
	<?php $header_orientation_class = gridlove_get_option( 'header_orientation' ) == 'wide' ? 'gridlove-header-wide' : ''; ?>
	<?php $shadow_class = gridlove_get_option('header_shadow') ? 'gridlove-header-shadow' : ''; ?>
	<?php $page_options = gridlove_blank_page_options(); ?>

	<?php if ( $page_options['header'] ) : ?>
		
		<header id="header" class="gridlove-site-header hidden-md-down <?php echo esc_attr( $header_orientation_class ); ?> <?php echo esc_attr( $shadow_class ); ?>">
				
				<?php if( gridlove_get_option( 'header_top' ) ): ?>
					<?php get_template_part( 'template-parts/header/topbar' ); ?>
				<?php endif; ?>

				<?php get_template_part('template-parts/header/layout-'.gridlove_get_option( 'header_layout' )); ?>

				<?php if ( gridlove_get_option( 'header_sticky' ) ): ?>
					
					<?php if ( gridlove_get_option( 'header_sticky_customize' ) ): ?>
						<?php get_template_part( 'template-parts/header/sticky-' . gridlove_get_option('header_sticky_layout') ) ?>
					<?php else: ?>
						<?php get_template_part( 'template-parts/header/sticky-1' ); ?>
					<?php endif; ?>
					
				<?php endif; ?>

		</header>

		<?php get_template_part( 'template-parts/header/responsive' ); ?>
		
	<?php endif; ?>