<?php
/**
 * Get default option by passing option id
 *
 * @param string  $option
 * @return array|mixed|false
 * @param since   1.9
 */

if ( !function_exists( 'gridlove_get_default_option' ) ):
	function gridlove_get_default_option( $option ) {


		if ( empty( $option ) ) {
			return false;
		}

		$defaults = array(
			'logo'   => array( 'url' => esc_url( get_parent_theme_file_uri( '/assets/img/gridlove_logo.png' ) ) ),
			'logo_retina'   => array( 'url' => esc_url( get_parent_theme_file_uri( '/assets/img/gridlove_logo@2x.png' ) ) ),
			'logo_mini'   => array( 'url' => esc_url( get_parent_theme_file_uri( '/assets/img/gridlove_logo_mini.png' ) ) ),
			'logo_mini_retina'   => array( 'url' => esc_url( get_parent_theme_file_uri( '/assets/img/gridlove_logo_mini@2x.png' ) ) ),
			'logo_custom_url'   => '',
			'default_fimg'   => array( 'url' => esc_url( get_parent_theme_file_uri( '/assets/img/gridlove_default.jpg' ) ) ),
			'header_layout' => 1,
			'header_site_desc' => 0,
			'header_actions' => array(
				'search-button' => 1,
				'sidebar-button' => 1,
			),
			'header_height' => 100,
			'color_header_main_bg' => '#ffffff',
			'color_header_main_txt' => '#111111',
			'color_header_main_acc' => '#009cff',
			'color_header_bottom_bg' => '#ffffff',
			'color_header_bottom_txt' => '#111111',
			'color_header_bottom_acc' => '#009cff',
			'logo_bg' => false,
			'color_logo_bg' => '#f0233b',
			'header_orientation' => '',
			'header_shadow' => true,
			'header_top' => false,
			'color_header_top_bg' => '#222222',
			'color_header_top_txt' => '#dddddd',
			'color_header_top_acc' => '#ffffff',
			'header_top_l' => 'secondary-menu-1',
			'header_top_c' => '0',
			'header_top_r' => 'social-menu',
			'header_sticky' => true,
			'header_sticky_offset' => 100,
			'header_sticky_up' => false,
			'header_sticky_logo' => 'main',
			'header_sticky_colors' => 'main',
			'color_header_sticky_bg' => '#0288d1',
			'color_header_sticky_txt' => '#ffffff',
			'color_header_sticky_acc' => '#009cff',
			'header_sticky_customize' => false,
			'header_sticky_layout' => 1,
			'header_sticky_menu' => 'gridlove_main_menu',
			'header_sticky_actions' => array(
				'search-button' => 1,
				'sidebar-button' => 1,
			),
			'responsive_secondary_nav' => false,
			'responsive_more_link' => false,
			'responsive_social_nav' => false,
			'color_body_bg' => '#f3f3f3',
			'background_image' => array(),
			'color_module_h' => '#111111',
			'color_content_bg' => '#ffffff',
			'color_content_h' => '#111111',
			'color_content_txt' => '#5e5e5e',
			'color_content_acc' => '#009cff',
			'color_content_meta' => '#818181',
			'color_highlight_bg' => '#083b5c',
			'color_highlight_txt' => '#ffffff',
			'color_highlight_acc' => '#b5e1ff',
			'color_footer_bg' => '#111111',
			'color_footer_txt' => '#ffffff',
			'color_footer_acc' => '#ffffff',
			'footer_widgets' => true,
			'footer_layout' => '4_3',
			'footer_bottom' => true,
			'footer_copyright' => wp_kses_post( '<p style="text-align: center;">' . sprintf( __( 'Copyright &copy; {current_year}. Created by %s. Powered by %s', 'gridlove' ), '<a href="https://mekshq.com" target="_blank" rel="noopener">Meks</a>', '<a href="https://www.wordpress.org" target="_blank" rel="noopener">WordPress</a>' ) . '</p>' ),
			'sidebars' => array(),
			'cover_type' => 'fixed',
			'cover_w' => 1500,
			'cover_h' => 500,
			'cover_overlay' => 'dark',
			'cover_1_cat' => true,
			'cover_1_excerpt' => true,
			'cover_1_excerpt_limit' => 210,
			'lay_cover_1_meta' => array(
				'author' => 1,
				'date' => 0,
				'comments' => 1,
				'views' => 0,
				'rtime' => 0,
			),
			'cover_1_icon' => true,
			'cover_1_autoplay' => false,
			'cover_1_autoplay_time' => 5,
			'cover_2_cat' => true,
			'cover_2_excerpt' => true,
			'cover_2_excerpt_limit' => 250,
			'lay_cover_2_meta' => array(
				'author' => 1,
				'date' => 0,
				'comments' => 1,
				'views' => 0,
				'rtime' => 0,
			),
			'cover_2_icon' => true,
			'cover_2_autoplay' => false,
			'cover_2_autoplay_time' => 5,
			'cover_3_cat' => true,
			'lay_cover_3_meta' => array(
				'author' => 1,
				'date' => 1,
				'comments' => 0,
				'views' => 0,
				'rtime' => 0,
			),
			'cover_3_icon' => true,
			'cover_3_autoplay' => false,
			'cover_3_autoplay_time' => 5,
			'cover_4_cat' => true,
			'lay_cover_4_meta' => array(
				'author' => 0,
				'date' => 1,
				'comments' => 0,
				'views' => 0,
				'rtime' => 0,
			),
			'cover_4_icon' => true,
			'cover_4_autoplay' => false,
			'cover_4_autoplay_time' => 5,
			'lay_a_cat' => true,
			'lay_a_meta' => array(
				'author' => 1,
				'date' => 1,
				'comments' => 0,
				'views' => 0,
				'rtime' => 0,
			),
			'lay_a_icon' => true,
			'lay_b_cat' => true,
			'lay_b_meta' => array(
				'author' => 1,
				'date' => 0,
				'comments' => 0,
				'views' => 1,
				'rtime' => 0,
			),
			'lay_b_icon' => true,
			'lay_c_cat' => true,
			'lay_c_meta' => array(
				'author' => 1,
				'date' => 0,
				'comments' => 1,
				'views' => 0,
				'rtime' => 0,
			),
			'lay_c_icon' => true,
			'lay_d_cat' => true,
			'lay_d_meta' => array(
				'author' => 1,
				'date' => 0,
				'comments' => 0,
				'views' => 0,
				'rtime' => 0,
			),
			'lay_d_icon' => true,
			'use_highlight' => true,
			'highlight_cat' => array(),
			'highlight_tag' => array(),
			'highlight_comments' => '',
			'highlight_views' => '',
			'highlight_manual' => array(),
			'highlight_manual_ids' => '',
			'single_layout' => '7_1',
			'single_sidebar_position' => 'right',
			'single_sidebar_standard' => 'gridlove_default_sidebar',
			'single_sidebar_sticky' => 'gridlove_default_sticky_sidebar',
			'single_cat' => true,
			'lay_single_meta' => array(
				'author' => 1,
				'date' => 1,
				'comments' => 1,
				'views' => 0,
				'rtime' => 1,
			),
			'single_icon' => false,
			'single_share' => true,
			'single_share_content' => false,
			'single_share_position' => 'bellow',
			'single_fimg' => true,
			'single_fimg_cap' => false,
			'single_headline' => true,
			'single_tags' => true,
			'single_author' => true,
			'single_prev_next' => true,
			'single_prev_next_in_category' => true,
			'single_infinite_scroll' => false,
			'single_related' => true,
			'single_related_using' => 'default',
			'related_limit' => 3,
			'related_layout' => 'b',
			'related_type' => 'cat',
			'related_order' => 'date',
			'related_time' => '0',
			'page_layout' => '4_1',
			'page_sidebar_position' => 'right',
			'page_sidebar_standard' => 'gridlove_default_sidebar',
			'page_sidebar_sticky' => 'gridlove_default_sticky_sidebar',
			'page_fimg' => true,
			'page_fimg_cap' => false,
			'category_cover_layout' => 'none',
			'category_cover_limit' => 3,
			'category_cover_order' => 'date',
			'category_cover_unique' => false,
			'category_layouts_type' => 'simple',
			'category_layout' => '1',
			'category_layout_masonry' => '1',
			'category_ppp' => 'inherit',
			'category_ppp_num' => get_option( 'posts_per_page' ),
			'category_pag' => 'load-more',
			'category_combo' => false,
			'category_combo_layout' => '1',
			'category_show_children' => false,
			'tag_layouts_type' => 'simple',
			'tag_layout' => '1',
			'tag_layout_masonry' => '1',
			'tag_ppp' => 'inherit',
			'tag_ppp_num' => get_option( 'posts_per_page' ),
			'tag_pag' => 'load-more',
			'author_layouts_type' => 'simple',
			'author_layout' => '1',
			'author_layout_masonry' => '1',
			'author_ppp' => 'inherit',
			'author_ppp_num' => get_option( 'posts_per_page' ),
			'author_pag' => 'load-more',
			'search_layouts_type' => 'simple',
			'search_layout' => '1',
			'search_layout_masonry' => '1',
			'search_ppp' => 'inherit',
			'search_ppp_num' => get_option( 'posts_per_page' ),
			'search_pag' => 'load-more',
			'archive_layouts_type' => 'simple',
			'archive_layout' => '5',
			'archive_layout_masonry' => '1',
			'archive_ppp' => 'inherit',
			'archive_ppp_num' => get_option( 'posts_per_page' ),
			'archive_pag' => 'load-more',
			'main_font' => array(
				'google' => true,
				'font-weight' => '400',
				'font-family' => 'Cabin',
				'subsets' => 'latin-ext',
			),
			'h_font' => array(
				'google' => true,
				'font-weight' => '700',
				'font-family' => 'Lato',
				'subsets' => 'latin-ext',
			),
			'nav_font' => array(
				'font-weight' => '700',
				'font-family' => 'Cabin',
				'subsets' => 'latin-ext',
			),
			'font_size_p' => '16',
			'font_size_nav' => '16',
			'font_size_module' => '16',
			'font_size_small' => '14',
			'font_size_h1' => '40',
			'font_size_h2' => '26',
			'font_size_h3' => '22',
			'font_size_h4' => '20',
			'font_size_h5' => '18',
			'font_size_h6' => '16',
			'uppercase' => array(
				'site-title' => 0,
				'gridlove-site-description' => 0,
				'gridlove-main-navigation' => 0,
				'entry-title' => 0,
				'module-title' => 0,
				'widget-title' => 0,
			),
			'ad_header' => '',
			'ad_below_header' => '',
			'ad_above_footer' => '',
			'ad_above_single' => '',
			'ad_below_single' => '',
			'ad_archive' => '',
			'ad_archive_position' => 4,
			'ad_exclude_404' => false,
			'ad_exclude_from_pages' => array(),
			'rtl_mode' => false,
			'rtl_lang_skip' => '',
			'more_string' => '...',
			'views_forgery' => '',
			'gridlove_bultin_gallery' => true,
			'on_single_img_popup' => false,
			'featured_paginated_image' => 'never',
			'breadcrumbs' => 'none',
			'primary_category' => false,
			'words_read_per_minute' => 200,
			'post_modified_date' => false,
			'back_to_top' => false,
			'product_sidebar_position' => 'right',
			'product_sidebar_standard' => 'gridlove_default_sidebar',
			'product_sidebar_sticky' => 'gridlove_default_sticky_sidebar',
			'product_archive_sidebar_position' => 'right',
			'product_archive_sidebar_standard' => 'gridlove_default_sidebar',
			'product_archive_sidebar_sticky' => 'gridlove_default_sticky_sidebar',
			'forum_sidebar_position' => 'right',
			'forum_sidebar_standard' => 'gridlove_default_sidebar',
			'forum_sidebar_sticky' => 'gridlove_default_sticky_sidebar',
			'topic_sidebar_position' => 'right',
			'topic_sidebar_standard' => 'gridlove_default_sidebar',
			'topic_sidebar_sticky' => 'gridlove_default_sticky_sidebar',
			'enable_translate' => '1',
			'minify_css' => true,
			'minify_js' => true,
			'disable_img_sizes' => array()
		);




		$defaults = apply_filters( 'gridlove_modify_default_options', $defaults );

		if ( isset( $defaults[$option] ) ) {
			return $defaults[$option];
		}

		return false;
	}
endif;

?>
