<?php

require_once get_parent_theme_file_path( '/inc/merlin/vendor/autoload.php' );
require_once get_parent_theme_file_path( '/inc/merlin/class-merlin.php' );

/**
 * Merlin WP configuration file.
 */

if ( ! class_exists( 'Merlin' ) ) {
	return;
}

$strings = array(
	'admin-menu'               => esc_html__( 'Gridlove Setup Wizard', 'gridlove' ),
	'title%s%s%s%s'            => esc_html__( '%s%s Themes &lsaquo; Theme Setup: %s%s', 'gridlove' ),
	'return-to-dashboard' 	   => esc_html__( 'Return to the dashboard', 'gridlove' ),
	'ignore'                   => esc_html__( 'Disable this wizard', 'gridlove' ),
	
	'btn-skip'                  => esc_html__( 'Skip', 'gridlove' ),
	'btn-next'                  => esc_html__( 'Next', 'gridlove' ),
	'btn-start'                 => esc_html__( 'Start', 'gridlove' ),
	'btn-no'                    => esc_html__( 'Cancel', 'gridlove' ),
	'btn-plugins-install'       => esc_html__( 'Install', 'gridlove' ),

	'btn-child-install'         => esc_html__( 'Install', 'gridlove' ),
	'btn-content-install'       => esc_html__( 'Install', 'gridlove' ),
	'btn-import'                => esc_html__( 'Import', 'gridlove' ),
	'btn-license-activate'     => esc_html__( 'Activate', 'gridlove' ),
	'btn-license-skip'         => esc_html__( 'Later', 'gridlove' ),
	
	'welcome-header%s'         => esc_html__( 'Welcome to %s', 'gridlove' ),
	'welcome-header-success%s' => esc_html__( 'Hi. Welcome back', 'gridlove' ),
	'welcome%s'                => esc_html__( 'This wizard will set up your theme, install plugins, and import content. It is optional & should take only a few minutes.', 'gridlove' ),
	'welcome-success%s'        => esc_html__( 'You may have already run this theme setup wizard. If you would like to proceed anyway, click on the "Start" button below.', 'gridlove' ),
	
	'license-header%s'         => esc_html__( 'Activate %s', 'gridlove' ),
	'license-header-success%s' => esc_html__( '%s is Activated', 'gridlove' ),
	'license%s'                => esc_html__( 'Enter your license key to enable remote updates and theme support.', 'gridlove' ),
	'license-label'            => esc_html__( 'License key', 'gridlove' ),
	'license-success%s'        => esc_html__( 'The theme is already registered, so you can go to the next step!', 'gridlove' ),
	'license-json-success%s'   => esc_html__( 'Your theme is activated! Remote updates and theme support are enabled.', 'gridlove' ),
	'license-tooltip'          => esc_html__( 'Need help?', 'gridlove' ),
	
	'child-header'         => esc_html__( 'Install Child Theme', 'gridlove' ),
	'child-header-success' => esc_html__( 'You\'re good to go!', 'gridlove' ),
	'child'                => esc_html__( 'Let\'s build & activate a child theme so you may easily make theme changes.', 'gridlove' ),
	'child-success%s'      => esc_html__( 'Your child theme has already been installed and is now activated, if it wasn\'t already.', 'gridlove' ),
	'child-action-link'    => esc_html__( 'Learn about child themes', 'gridlove' ),
	'child-json-success%s' => esc_html__( 'Awesome. Your child theme has already been installed and is now activated.', 'gridlove' ),
	'child-json-already%s' => esc_html__( 'Awesome. Your child theme has been created and is now activated.', 'gridlove' ),
	
	'plugins-header'         => esc_html__( 'Install Plugins', 'gridlove' ),
	'plugins-header-success' => esc_html__( 'You\'re up to speed!', 'gridlove' ),
	'plugins'                => esc_html__( 'Let\'s install some essential WordPress plugins to get your site up to speed.', 'gridlove' ),
	'plugins-success%s'      => esc_html__( 'The required WordPress plugins are all installed and up to date. Press "Next" to continue the setup wizard.', 'gridlove' ),
	'plugins-action-link'    => esc_html__( 'Plugins', 'gridlove' ),
	
	'import-header'      => esc_html__( 'Import Content', 'gridlove' ),
	'import'             => esc_html__( 'Let\'s import content to your website, to help you get familiar with the theme.', 'gridlove' ),
	'import-action-link' => esc_html__( 'Details', 'gridlove' ),
	
	'ready-header'      => esc_html__( 'All done. Have fun!', 'gridlove' ),
	'ready%s'           => esc_html__( 'Your theme has been all set up. Enjoy your new theme by %s.', 'gridlove' ),
	'ready-action-link' => esc_html__( 'Extras', 'gridlove' ),
	'ready-big-button'  => esc_html__( 'View your website', 'gridlove' ),
	
	'ready-link-3' => '',
	'ready-link-2' => wp_kses( sprintf( '<a href="%1$s" target="_blank">%2$s</a>', 'https://mekshq.com/documentation/gridlove/', esc_html__( 'Theme Documentation', 'gridlove' ) ), array( 'a' => array( 'href' => array(), 'target' => array() ) ) ),
);

if(gridlove_is_redux_active()){
	$strings['ready-link-1'] = wp_kses( sprintf( '<a href="'.admin_url( 'admin.php?page=gridlove_options' ).'" target="_blank">%s</a>', esc_html__( 'Start Customizing', 'gridlove' ) ), array( 'a' => array( 'href' => array(), 'target' => array() ) ) );
}

/**
 * Set directory locations, text strings, and other settings for Merlin WP.
 *
 * @since 1.0
 */
$gridlove_wizard = new Merlin(

	// Configure Merlin with custom settings.
	$config = array(
		'directory'            => 'inc/merlin', // Location / directory where Merlin WP is placed in your theme.
		'merlin_url'           => 'gridlove-importer', // The wp-admin page slug where Merlin WP loads.
		'parent_slug'          => 'themes.php', // The wp-admin parent page slug for the admin menu item.
		'capability'           => 'manage_options', // The capability required for this menu to be displayed to the user.
		'child_action_btn_url' => 'https://codex.wordpress.org/child_themes', // URL for the 'child-action-link'.
		'dev_mode'             => false, // Enable development mode for testing.
		'license_step'         => false, // EDD license activation step.
		'license_required'     => false, // Require the license activation step.
		'license_help_url'     => '', // URL for the 'license-tooltip'.
		'edd_remote_api_url'   => '', // EDD_Theme_Updater_Admin remote_api_url.
		'edd_item_name'        => '', // EDD_Theme_Updater_Admin item_name.
		'edd_theme_slug'       => '', // EDD_Theme_Updater_Admin item_slug.
		'ready_big_button_url' => get_home_url(), // Link for the big button on the ready step.
	),

	// Text strings.
	$strings

);


/**
 * Prepare files to import
 *
 * @since 1.0
 */
add_filter( 'merlin_import_files', 'gridlove_demo_import_files' );

if(!function_exists('gridlove_demo_import_files')):
	function gridlove_demo_import_files() {
			return array(
				array(
					'import_file_name'         => 'Gridlove default',
					'local_import_file'          => get_parent_theme_file_path( '/inc/demos/01_default/content.xml' ),
					'local_import_widget_file'   => get_parent_theme_file_path( '/inc/demos/01_default/widgets.json' ),
					'local_import_redux'       => array(
						array(
							'file_path'    => get_parent_theme_file_path( '/inc/demos/01_default/options.json' ),
							'option_name' => 'gridlove_settings',
						)
					),
					'import_preview_image_url' => get_parent_theme_file_uri( '/screenshot.png' ),
					'import_notice'            => '',
					'preview_url'              => 'https://demo.mekshq.com/gridlove/',
				)
			);
	}
endif;

/**
 * Execute custom code after the whole import has finished.
 *
 * @since 1.0
 */
add_action( 'merlin_after_all_import', 'gridlove_merlin_after_import_setup' );
if(!function_exists('gridlove_merlin_after_import_setup')):
	
	function gridlove_merlin_after_import_setup( ) {
		
		/* Set Menus */


        $menus = array();

        $main_menu = get_term_by( 'name', 'Gridlove Main', 'nav_menu' );
        if ( isset( $main_menu->term_id ) ) {
            $menus['gridlove_main_menu'] = $main_menu->term_id;
        }

        $social_menu = get_term_by( 'name', 'Gridlove Social', 'nav_menu' );
        if ( isset( $social_menu->term_id ) ) {
            $menus['gridlove_social_menu'] = $social_menu->term_id;
        }

        $secondary_menu = get_term_by( 'name', 'Gridlove Secondary', 'nav_menu' );
        if ( isset( $secondary_menu->term_id ) ) {
            $menus['gridlove_secondary_menu_1'] = $secondary_menu->term_id;
        }

        if ( !empty( $menus ) ) {
            set_theme_mod( 'nav_menu_locations', $menus );
        }


        /* Set Home Page */

        $home_page_title = 'Gridlove Home';

        $page = get_page_by_title( $home_page_title );

        if ( isset( $page->ID ) ) {
            update_option( 'page_on_front', $page->ID );
            update_option( 'show_on_front', 'page' );
		}
		
		gridlove_import_contact_form();

	}

endif;

/* Insert WPForms contact form
 *
 * @return void
 * @since 1.9.5
 */

if ( !function_exists( 'gridlove_import_contact_form' ) ):
	function gridlove_import_contact_form( ) {
		$forms = json_decode( file_get_contents( get_parent_theme_file_path( '/inc/demos/01_default/wpforms.json' ) ), true );

		if ( ! empty( $forms ) ) {

			foreach ( $forms as $form ) {

				$title  = ! empty( $form['settings']['form_title'] ) ? $form['settings']['form_title'] : '';
				$desc   = ! empty( $form['settings']['form_desc'] ) ? $form['settings']['form_desc'] : '';
				$new_id = wp_insert_post( array(
					'post_title'   => $title,
					'post_status'  => 'publish',
					'post_type'    => 'wpforms',
					'post_excerpt' => $desc,
				) );
				if ( $new_id ) {
					$form['id'] = $new_id;
					wp_update_post(
						array(
							'ID'           => $new_id,
							'post_content' => wp_slash( wp_json_encode( $form ) ),
						)
					);
				}
			}
		}

	}
endif;

/**
 * Unset the default widgets
 *
 * @return array
 * @since 1.0
 */

add_action('merlin_widget_importer_before_widgets_import', 'gridlove_remove_widgets_before_import');

if(!function_exists('gridlove_remove_widgets_before_import')):
	function gridlove_remove_widgets_before_import() {
		delete_option( 'sidebars_widgets' );	
	}
endif;

/**
 * Unset the child theme generator step in merlin welcome panel
 *
 * @param $steps
 * @return mixed
 * @since 1.0
 */

add_filter('gridlove_merlin_steps', 'gridlove_remove_child_theme_generator_from_merlin');

if(!function_exists('gridlove_remove_child_theme_generator_from_merlin')):
    function gridlove_remove_child_theme_generator_from_merlin($steps){
        unset($steps['child']);
        return $steps;
    }
endif;


/**
 * Stop initial redirect after theme is activated
 *
 * @since 1.0
 */

remove_action( 'after_switch_theme', array( $gridlove_wizard, 'switch_theme' ) );
?>