<?php
/**
 * Grider
 * Grider - Creating a dynamic grid layout has never been easier.
 * Exclusively on https://1.envato.market/grider-elementor
 *
 * @encoding        UTF-8
 * @version         1.0.0
 * @copyright       (C) 2018 - 2021 Merkulove ( https://merkulov.design/ ). All rights reserved.
 * @license         Envato License https://1.envato.market/KYbje
 * @contributors    Nemirovskiy Vitaliy (nemirovskiyvitaliy@gmail.com)
 * @support         help@merkulov.design
 **/

namespace Merkulove\GriderElementor;

use Merkulove\GriderElementor\Unity\Plugin;
use Merkulove\GriderElementor\Unity\Settings;
use Merkulove\GriderElementor\Unity\TabGeneral;

/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}

/**
 * SINGLETON: Settings class used to modify default plugin settings.
 *
 * @since 1.0.0
 **/
final class Config {

	/**
	 * The one true Settings.
	 *
     * @since 1.0.0
     * @access private
	 * @var Config
	 **/
	private static $instance;

    /**
     * Prepare plugin settings by modifying the default one.
     *
     * @since 1.0.0
     * @access public
     *
     * @return void
     **/
    public function prepare_settings() {

        /** Get default plugin settings. */
        $tabs = Plugin::get_tabs();

	    $offset = 0;
	    $tabs = array_slice( $tabs, 0, $offset, true ) +
            [ 'general' => [
	            'enabled'       => true,
	            'class'         => TabGeneral::class,
	            'label'         => esc_html__( 'WooCommerce', 'selection' ),
	            'title'         => esc_html__( 'WooCommerce Integration', 'selection' ),
	            'show_title'    => true,
	            'icon'          => 'storefront',
	            'fields'        => []
            ]
        ] + array_slice( $tabs, $offset, NULL, true );

        // Add Text control
        $tabs['general']['fields']['ck_key'] = [
            'type'              => 'text',
            'label'             => esc_html__( 'Consumer key', 'grider-elementor' ),
            'show_label'        => true,
            'placeholder'       => esc_html__( 'Enter consumer key', 'grider-elementor' ),
            'description'       => esc_html__( 'Some text field description.', 'grider-elementor' ),
            'show_description'  => false,
            'default'           => '',
            'attr'              => [
                'class'     => 'mdp-test-class',
                'maxlength' => '4500'
            ]
        ];

	    $tabs['general']['fields']['cs_key'] = [
		    'type'              => 'text',
		    'label'             => esc_html__( 'Consumer secret', 'grider-elementor' ),
		    'show_label'        => true,
		    'placeholder'       => esc_html__( 'Enter consumer secret', 'grider-elementor' ),
		    'description'       => esc_html__( 'Some text field description.', 'grider-elementor' ),
		    'show_description'  => false,
		    'default'           => '',
		    'attr'              => [
			    'class'     => 'mdp-test-class',
			    'maxlength' => '4500'
		    ]
	    ];

        /** Set updated tabs. */
        Plugin::set_tabs( $tabs );

        /** Refresh settings. */
        Settings::get_instance()->get_options();

    }

	/**
	 * Main Settings Instance.
	 * Insures that only one instance of Settings exists in memory at any one time.
	 *
	 * @static
     * @since 1.0.0
     * @access public
     *
	 * @return Config
	 **/
	public static function get_instance() {

		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof self ) ) {

			self::$instance = new self;

		}

		return self::$instance;

	}

}
