<?php $count = 1;
$query_args = array('post_type' => 'bunch_faqs' , 'showposts' => $num , 'order_by' => $sort , 'order' => $order);

if( $cat ) $query_args['faqs_category'] = $cat;
$query = new WP_Query($query_args); ?>

<div class="post-column">
    <div class="clearfix">
        <div class="img-box">
            <img src="<?php echo esc_url($image_top); ?>" alt="<?php esc_attr_e('image', 'greengia');?>">
        </div>
        <div class="content">
            <h2><?php echo wp_kses_post($title_top); ?></h2>
            <h5><?php echo wp_kses_post($subtitle_top); ?></h5>
            <?php echo wp_kses_post($text_top); ?>
        </div>
    </div>
    <div class="clearfix margin-top-45">
        <div class="content">
            <h2><?php echo wp_kses_post($title_bottom); ?></h2>
            <h5><?php echo wp_kses_post($subtitle_bottom); ?></h5>
            <?php echo wp_kses_post($text_bottom); ?>
        </div>
        <div class="img-box">
            <img src="<?php echo esc_url($image_bottom); ?>" alt="<?php esc_attr_e('image', 'greengia');?>">
        </div>
    </div>
    <div class="border-bottom margin-top-50 margin-bottom-50"></div>

    <div class="clearfix sec-padd-bottom">
        <div class="tabs-box tabs-style-one">
            <!--Tab Buttons-->
            <ul class="tab-buttons clearfix">
                <?php foreach( $atts['services_tabs'] as $key => $item ): ?>
                <li data-tab="#tab-<?php echo esc_attr($key); ?>" class="tab-btn <?php if($key == 1) { echo 'active-btn'; } ?>"><?php echo wp_kses_post($item->title); ?></li>
                <?php endforeach; ?>
            </ul>
        
            <!--Tabs Content-->
            <div class="tabs-content">
                <?php foreach( $atts['services_tabs'] as $key => $item ): ?>
                <!--Tab / Active Tab-->
                <div class="tab <?php if($key == 1) { echo 'active-tab'; } ?>" id="tab-<?php echo esc_attr($key); ?>">
                    <div class="text-content">
                        <div class="text"><p><?php echo wp_kses_post($item->text); ?></p></div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>

        <div class="request-quote">
            <div class="section-title">
                <h2><?php echo wp_kses_post($quote_title); ?></h2>
            </div>
            <div class="text">
                <p><?php echo wp_kses_post($quote_text); ?></p>
            </div>
            <h4><?php esc_html_e('For queries:', 'greengia'); ?></h4>
            <ul>
                <li><span><?php esc_html_e('Ph:', 'greengia'); ?></span> <?php echo wp_kses_post($phone); ?></li>
                <li><span><?php esc_html_e('Email:', 'greengia'); ?></span> <?php echo sanitize_email($email); ?></li>
            </ul>
            <form action="http://feedburner.google.com/fb/a/mailverify">
                <input type="hidden" id="uri2" name="uri" value="<?php echo esc_attr($form_id); ?>">
                <div class="form-group">
                    <input type="email" placeholder="<?php esc_html_e('Enter Your Email', 'greengia');?>">
                    <button><i class="fa fa-paper-plane"></i></button>
                </div>
            </form>
        </div>
    </div>
    
    <?php if($query->have_posts()): ?>
    <div class="section-title">
        <h2><?php echo wp_kses_post($faqs_title); ?></h2>
    </div>
    <div class="accordion-box style-one">
        <?php while($query->have_posts()): $query->the_post();
        global $post;
        $faqs_meta = _WSH()->get_meta(); ?>
        <!--Start single accordion box-->
        <div class="accordion animated out" data-delay="0" data-animation="fadeInUp">
            <div class="acc-btn <?php if($count == 2) { echo 'active'; } ?>">
                <p class="title"><?php the_title(); ?></p>
                <div class="toggle-icon">
                    <span class="plus fa fa-plus-circle"></span><span class="minus fa fa-minus-circle"></span>
                </div>
            </div>
            <div class="acc-content <?php if($count == 2) { echo 'collapsed'; } ?>">
                <div class="text"><p><?php echo wp_kses_post(get_the_content()); ?></p></div>
            </div>
        </div>
        <?php $count++; endwhile; ?>
    </div>
    <?php endif; wp_reset_postdata(); ?>
</div>
