<section class="contact-us sec-padd2">
    <div class="container">
        <div class="section-title">
            <h1><?php echo wp_kses_post($editor); ?></h1>
        </div>
        <div class="text margin-bottom-35">
            <p><?php echo wp_kses_post($text); ?></p>
        </div>
        <div class="row">
            <div class="col-md-4 col-sm-12">
                <div class="default-cinfo margin-bottom-30">
                    <div class="accordion-box style-2">
                    	<?php $count=1; foreach( $atts['contact_details'] as $key => $item ): ?>
                        <!--Start single accordion box-->
                        <div class="accordion animated out" data-delay="0" data-animation="fadeInUp">
                            <div class="acc-btn <?php if($count == 1) { echo 'active'; } ?>">
                                <?php echo wp_kses_post($item->branch_name); ?>
                                <div class="toggle-icon">
                                    <i class="plus fa fa-angle-right"></i><i class="minus fa fa-angle-down"></i>
                                </div>
                            </div>
                            <div class="acc-content <?php if($count == 1) { echo 'collapsed'; } ?>">
                                <ul class="contact-infos">
                                    <li>
                                        <div class="icon_box"><i class="icon-arrows"></i></div><!-- /.icon-box -->
                                        <div class="text-box">
                                            <p><b><?php esc_html_e('Address:', 'greengia'); ?></b> <?php echo wp_kses_post($item->address); ?></p>
                                        </div><!-- /.text-box -->
                                    </li>
                                    <li>
                                        <div class="icon_box"><i class="icon-telephone"></i></div><!-- /.icon-box -->
                                        <div class="text-box">
                                            <p><b><?php esc_html_e('Phone:', 'greengia'); ?></b> <?php echo wp_kses_post($item->phone); ?></p>
                                        </div><!-- /.text-box -->
                                    </li>
                                    <li>
                                        <div class="icon_box"><i class="icon-letter"></i></div><!-- /.icon-box -->
                                        <div class="text-box">
                                            <p><b><?php esc_html_e('Email:', 'greengia'); ?></b> <?php echo sanitize_email($item->email); ?></p>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="icon_box"><i class="icon-clock"></i></div><!-- /.icon-box -->
                                        <div class="text-box">
                                            <p><b><?php esc_html_e('Working Hrs:', 'greengia'); ?></b> <br><?php echo wp_kses_post($item->working_hours); ?></p>
                                        </div>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <?php $count++; endforeach; ?>
                    </div>
                </div>
            </div>
            
            <div class="col-md-8 col-sm-12">
                <div class="default-form-area margin-bottom-30">
                    <h2 class="margin-bottom-30"><?php echo wp_kses_post($contact_title); ?></h2>
                    <div id="contact-form" class="default-form">
                        <div class="row clearfix">
                        	<?php echo do_shortcode($contact_shortcode); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
