<?php
///----Blog widgets---

//Recent Post
class Bunch_Recent_Post extends WP_Widget
{
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Bunch_Recent_Post', /* Name */esc_html__('Greengia Recent Post','greengia'), array( 'description' => esc_html__('Show the recent posts sidebar', 'greengia' )) );
	}
 

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		
		echo wp_kses_post($before_widget); ?>
		
        <!-- Recent Posts -->
        <div class="popular_news">
            <?php echo wp_kses_post($before_title.$title.$after_title); ?>

            <div class="popular-post">
                <?php $query_string = 'posts_per_page='.$instance['number'];
				if( $instance['cat'] ) $query_string .= '&cat='.$instance['cat'];
				
				$this->posts($query_string);  
				?>
            </div>
        </div>
        
		<?php echo wp_kses_post($after_widget);
	}
 
 
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['number'] = $new_instance['number'];
		$instance['cat'] = $new_instance['cat'];
		
		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = ( $instance ) ? esc_attr($instance['title']) : esc_html__('Recent Post', 'greengia');
		$number = ( $instance ) ? esc_attr($instance['number']) : 3;
		$cat = ( $instance ) ? esc_attr($instance['cat']) : '';?>
			
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title: ', 'greengia'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('number')); ?>"><?php esc_html_e('No. of Posts:', 'greengia'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo esc_attr( $number ); ?>" />
        </p>
       
    	<p>
            <label for="<?php echo esc_attr($this->get_field_id('cat')); ?>"><?php esc_html_e('Category', 'greengia'); ?></label>
            <?php wp_dropdown_categories( array('show_option_all'=>esc_html__('All Categories', 'greengia'), 'selected'=>$cat, 'class'=>'widefat', 'name'=>$this->get_field_name('cat')) ); ?>
        </p>
            
		<?php 
	}
	
	function posts($query_string)
	{
		$query = new WP_Query($query_string);
		if( $query->have_posts() ):?>
        
           	<!-- Title -->
			<?php while( $query->have_posts() ): $query->the_post(); ?>
            <div class="item">
                <div class="post-thumb"><a href="<?php echo esc_url(get_permalink(get_the_id())); ?>"><?php the_post_thumbnail('greengia_90x80'); ?></a></div>
                <h4><a href="<?php echo esc_url(get_permalink(get_the_id()));?>"><?php the_title();?></a></h4>
                <div class="post-info"><?php echo get_the_date('F d, Y'); ?></div>
            </div>
            <?php endwhile; ?>
            
        <?php endif;
		wp_reset_postdata();
    }
}

// Services Menu
class Bunch_Services_Menu extends WP_Widget
{
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Bunch_Services_Menu', /* Name */esc_html__('Greengia Services Menu','greengia'), array( 'description' => esc_html__('Show services menu in sidebar.', 'greengia' )) );
	}
	
	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		
		echo wp_kses_post($before_widget); ?>
		
        <!--Start single sidebar-->
        <ul class="service-catergory">
        	<?php $args = array('post_type' => 'bunch_services', 'showposts'=>$instance['number']);
				if( $instance['cat'] ) $args['tax_query'] = array(array('taxonomy' => 'services_category','field' => 'id','terms' => (array)$instance['cat']));
				 
				$this->posts($args); 
			?>
        </ul>
        
        <?php echo wp_kses_post($after_widget);
	}
 
 
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['number'] = $new_instance['number'];
		$instance['cat'] = $new_instance['cat'];
		
		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$number = ( $instance ) ? esc_attr($instance['number']) : 6;
		$cat = ( $instance ) ? esc_attr($instance['cat']) : '';?>
        
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('number')); ?>"><?php esc_html_e('No. of Posts:', 'greengia'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo esc_attr( $number ); ?>" />
        </p>
       
    	<p>
            <label for="<?php echo esc_attr($this->get_field_id('cat')); ?>"><?php esc_html_e('Category', 'greengia'); ?></label>
            <?php wp_dropdown_categories( array('show_option_all'=>esc_html__('All Categories', 'greengia'), 'selected'=>$cat, 'taxonomy' => 'services_category', 'class'=>'widefat', 'name'=>$this->get_field_name('cat')) ); ?>
        </p>
            
		<?php 
	}
	
	function posts($args)
	{
		$query = new WP_Query($args);
		if( $query->have_posts() ):
		while( $query->have_posts() ): $query->the_post();
		$services_meta = _WSH()->get_meta(); ?>
        <li><a href="<?php echo esc_url(greengia_set($services_meta, 'ext_url')); ?>"><?php the_title(); ?></a></li>
        <?php endwhile; endif;
		wp_reset_postdata();
    }
}

//Our Brochures
class Bunch_Brochures extends WP_Widget
{
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Bunch_Brochures', /* Name */esc_html__('Greengia Our Brochures','greengia'), array( 'description' => esc_html__('Show the info Our Brochures', 'greengia' )) );
	}

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		
		echo wp_kses_post($before_widget);?>
      		
            <!--Our Brochures-->
            <div class="boucher">
				<?php echo wp_kses_post($before_title.$title.$after_title); ?>
                <ul>
                    <li><a href="<?php echo esc_url($instance['pdf']); ?>"><span><?php esc_html_e('Research Results', 'greengia'); ?></span><?php esc_html_e('Download.pdf', 'greengia'); ?></a></li>
                    <li><a href="<?php echo esc_url($instance['word']); ?>"><span><?php esc_html_e('Research Results', 'greengia'); ?></span><?php esc_html_e('Download.txt', 'greengia'); ?></a></li>
                </ul>
            </div>
            
		<?php
		
		echo wp_kses_post($after_widget);
	}
	
	
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['title'] = $new_instance['title'];
		$instance['pdf'] = $new_instance['pdf'];
		$instance['word'] = $new_instance['word'];

		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = ( $instance ) ? esc_attr($instance['title']) : esc_html__('Our Brochures', 'greengia');
		$pdf = ( $instance ) ? esc_attr($instance['pdf']) : '#';
		$word = ($instance) ? esc_attr($instance['word']) : '#';
		?>
        
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title:', 'greengia'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('pdf')); ?>"><?php esc_html_e('PDF Link:', 'greengia'); ?></label>
            <input placeholder="<?php esc_html_e('PDF link here', 'greengia');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('pdf')); ?>" name="<?php echo esc_attr($this->get_field_name('pdf')); ?>" type="text" value="<?php echo esc_attr($pdf); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('word')); ?>"><?php esc_html_e('Work Doc Link:', 'greengia'); ?></label>
            <input placeholder="<?php esc_html_e('Word link here', 'greengia');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('word')); ?>" name="<?php echo esc_attr($this->get_field_name('word')); ?>" type="text" value="<?php echo esc_attr($word); ?>" />
        </p>
                
		<?php 
	}
	
}

//Our Brochures
class Bunch_Sidebar_Info extends WP_Widget
{
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Bunch_Sidebar_Info', /* Name */esc_html__('Greengia Sidebar Info','greengia'), array( 'description' => esc_html__('Show the info Our Brochures', 'greengia' )) );
	}

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		
		echo wp_kses_post($before_widget);?>
      		
            <!--Our Brochures-->
            <div class="img-box">
                <img src="<?php echo esc_url($instance['image']); ?>" alt="<?php esc_attr_e('image', 'greengia');?>">
            </div><br>
            <div class="text"><p><?php echo wp_kses_post($instance['content']); ?></p></div>

            <div class="default-cinfo margin-top-20">
                <ul class="contact-infos">
                    <li>
                        <div class="icon_box"><i class="icon-arrows"></i></div><!-- /.icon-box -->
                        <div class="text-box">
                            <p><?php echo wp_kses_post($instance['address']); ?></p>
                        </div><!-- /.text-box -->
                    </li>
                    <li>
                        <div class="icon_box"><i class="icon-telephone"></i></div><!-- /.icon-box -->
                        <div class="text-box">
                            <p><?php echo wp_kses_post($instance['phone']); ?></p>
                        </div><!-- /.text-box -->
                    </li>
                    <li>
                        <div class="icon_box"><i class="icon-letter"></i></div><!-- /.icon-box -->
                        <div class="text-box">
                            <p><?php echo sanitize_email($instance['email']); ?></p>
                        </div>
                    </li>
                </ul>
            </div>
            
		<?php
		
		echo wp_kses_post($after_widget);
	}
	
	
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['image'] = $new_instance['image'];
		$instance['content'] = $new_instance['content'];
		$instance['address'] = $new_instance['address'];
		$instance['phone'] = $new_instance['phone'];
		$instance['email'] = $new_instance['email'];

		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$image = ( $instance ) ? esc_attr($instance['image']) : get_template_directory_uri().'/images/service/7.jpg';
		$content = ($instance) ? esc_attr($instance['content']) : '';
		$address = ( $instance ) ? esc_attr($instance['address']) : '<b>Greengia Landscaping</b> <br>121 Park Drive, Varick Str, <br>Newyork, USA.';
		$phone = ( $instance ) ? esc_attr($instance['phone']) : '+123-456-7890 & 891';
		$email = ( $instance ) ? esc_attr($instance['email']) : 'Mailus@TocoGarden.com';
		?>
        
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('image')); ?>"><?php esc_html_e('Image:', 'greengia'); ?></label>
            <input placeholder="<?php esc_html_e('images url here', 'greengia');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('image')); ?>" name="<?php echo esc_attr($this->get_field_name('image')); ?>" type="text" value="<?php echo esc_attr($image); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('content')); ?>"><?php esc_html_e('Content:', 'greengia'); ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('content')); ?>" name="<?php echo esc_attr($this->get_field_name('content')); ?>" ><?php echo wp_kses_post($content); ?></textarea>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('address')); ?>"><?php esc_html_e('Address:', 'greengia'); ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('address')); ?>" name="<?php echo esc_attr($this->get_field_name('address')); ?>" ><?php echo wp_kses_post($address); ?></textarea>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('phone')); ?>"><?php esc_html_e('Phone:', 'greengia'); ?></label>
            <input placeholder="<?php esc_html_e('Phone', 'greengia');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('phone')); ?>" name="<?php echo esc_attr($this->get_field_name('phone')); ?>" type="text" value="<?php echo esc_attr($phone); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('email')); ?>"><?php esc_html_e('Email:', 'greengia'); ?></label>
            <input placeholder="<?php esc_html_e('Email', 'greengia');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('email')); ?>" name="<?php echo esc_attr($this->get_field_name('email')); ?>" type="text" value="<?php echo esc_attr($email); ?>" />
        </p>
                
		<?php 
	}
	
}

///----footer widgets---
//About Us
class Bunch_About_Us extends WP_Widget
{
	
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Bunch_About_Us', /* Name */esc_html__('Greengia About Us','greengia'), array( 'description' => esc_html__('Show the information about company', 'greengia' )) );
	}

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		$options = _WSH()->option();
		echo wp_kses_post($before_widget); ?>
      		
			<!--Footer Column-->
            <div class="about-widget">
                <?php echo wp_kses_post($before_title.$title.$after_title); ?>
                
                <div class="widget-content">
                    <div class="text"><p><?php echo wp_kses_post($instance['content']); ?></p></div>
                    <div class="link">
                        <a href="<?php echo esc_url($instance['about_url']); ?>" class="default_link"><?php esc_html_e('Read More', 'greengia'); ?><i class="icon-right-arrow"></i></a>
                    </div>
                </div>
            </div>
            
		<?php
		
		echo wp_kses_post($after_widget);
	}
	
	
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['title'] = $new_instance['title'];
		$instance['content'] = $new_instance['content'];
		$instance['about_url'] = $new_instance['about_url'];

		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = ( $instance ) ? esc_attr($instance['title']) : 'About';
		$content = ($instance) ? esc_attr($instance['content']) : '';
		$about_url = ($instance) ? esc_attr($instance['about_url']) : '#';
		?>
        
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title:', 'greengia'); ?></label>
            <input placeholder="<?php esc_html_e('Title', 'greengia');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('content')); ?>"><?php esc_html_e('Content:', 'greengia'); ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('content')); ?>" name="<?php echo esc_attr($this->get_field_name('content')); ?>" ><?php echo wp_kses_post($content); ?></textarea>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('about_url')); ?>"><?php esc_html_e('Read More URL:', 'greengia'); ?></label>
            <input placeholder="<?php esc_html_e('read more link here', 'greengia');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('about_url')); ?>" name="<?php echo esc_attr($this->get_field_name('about_url')); ?>" type="text" value="<?php echo esc_attr($about_url); ?>" />
        </p>
                
		<?php 
	}
	
}

//Latest News
class Bunch_Latest_News extends WP_Widget
{
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Bunch_Latest_News', /* Name */esc_html__('Greengia Latest News','greengia'), array( 'description' => esc_html__('Show the latest news', 'greengia' )) );
	}
 

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		
		echo wp_kses_post($before_widget); ?>
		
        <!-- Recent Posts -->
        <div class="footer-widget posts-widget">
            <?php echo wp_kses_post($before_title.$title.$after_title); ?>
            
            <div class="widget-content">
                <?php $query_string = 'posts_per_page='.$instance['number'];
				if( $instance['cat'] ) $query_string .= '&cat='.$instance['cat'];
				
				$this->posts($query_string); ?>
            </div>
            
        </div>
        
		<?php echo wp_kses_post($after_widget);
	}
 
 
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['number'] = $new_instance['number'];
		$instance['cat'] = $new_instance['cat'];
		
		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = ( $instance ) ? esc_attr($instance['title']) : esc_html__('Latest News', 'greengia');
		$number = ( $instance ) ? esc_attr($instance['number']) : 3;
		$cat = ( $instance ) ? esc_attr($instance['cat']) : ''; ?>
			
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title: ', 'greengia'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('number')); ?>"><?php esc_html_e('No. of Posts:', 'greengia'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo esc_attr( $number ); ?>" />
        </p>
       
    	<p>
            <label for="<?php echo esc_attr($this->get_field_id('cat')); ?>"><?php esc_html_e('Category', 'greengia'); ?></label>
            <?php wp_dropdown_categories( array('show_option_all'=>esc_html__('All Categories', 'greengia'), 'selected'=>$cat, 'class'=>'widefat', 'name'=>$this->get_field_name('cat')) ); ?>
        </p>
            
		<?php 
	}
	
	function posts($query_string)
	{
		$query = new WP_Query($query_string);
		if( $query->have_posts() ):?>
        	
            <?php while( $query->have_posts() ): $query->the_post(); ?>
            <!--Post-->
            <div class="post">
                <div class="content">
                    <h4><a href="<?php echo esc_url(get_permalink(get_the_id())); ?>"><?php echo wp_trim_words( get_the_title(), 4, '...' ); ?></a></h4>
                </div>
                <div class="time"><?php echo get_the_date('F d, Y'); ?></div>
            </div>
            <?php endwhile; ?>
            
        <?php endif;
		wp_reset_postdata();
    }
}

//Working Hours
class Bunch_Working_Hours extends WP_Widget
{
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Bunch_Working_Hours', /* Name */esc_html__('Greengia Working Hours','greengia'), array( 'description' => esc_html__('Show the info Working Hours', 'greengia' )) );
	}

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		
		echo wp_kses_post($before_widget);?>
      		
            <!--Our Brochures-->
            <div class="working-widget">
                <div class="inner-bg">
                    <?php echo wp_kses_post($before_title.$title.$after_title); ?>
                    
                    <div class="text">
                        <p><?php echo wp_kses_post($instance['content']); ?></p>
                    </div><br>
                    <ul>
                        <li><?php esc_html_e('Mon - Friday:', 'greengia'); ?> <span><?php echo wp_kses_post($instance['monday_friday']); ?></span></li>
                        <li><?php esc_html_e('Saturday:', 'greengia'); ?> <span><?php echo wp_kses_post($instance['saturday']); ?></span></li>
                        <li><?php esc_html_e('Sunday:', 'greengia'); ?> <span><?php echo wp_kses_post($instance['sunday']); ?></span></li>
                    </ul>
                </div>
            </div>
            
		<?php
		
		echo wp_kses_post($after_widget);
	}
	
	
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['title'] = $new_instance['title'];
		$instance['content'] = $new_instance['content'];
		$instance['monday_friday'] = $new_instance['monday_friday'];
		$instance['saturday'] = $new_instance['saturday'];
		$instance['sunday'] = $new_instance['sunday'];

		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = ( $instance ) ? esc_attr($instance['title']) : esc_html__('Working Hours', 'greengia');
		$content = ($instance) ? esc_attr($instance['content']) : '';
		$monday_friday = ( $instance ) ? esc_attr($instance['monday_friday']) : '09:00 -18:00';
		$saturday = ($instance) ? esc_attr($instance['saturday']) : '10:00 - 14:00';
		$sunday = ($instance) ? esc_attr($instance['sunday']) : 'Closed';
		?>
        
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title:', 'greengia'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('content')); ?>"><?php esc_html_e('Content:', 'greengia'); ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('content')); ?>" name="<?php echo esc_attr($this->get_field_name('content')); ?>" ><?php echo wp_kses_post($content); ?></textarea>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('monday_friday')); ?>"><?php esc_html_e('Monday to Friday:', 'greengia'); ?></label>
            <input placeholder="<?php esc_html_e('monday to friday timing here', 'greengia');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('monday_friday')); ?>" name="<?php echo esc_attr($this->get_field_name('monday_friday')); ?>" type="text" value="<?php echo esc_attr($monday_friday); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('saturday')); ?>"><?php esc_html_e('Saturday:', 'greengia'); ?></label>
            <input placeholder="<?php esc_html_e('saturday timing here', 'greengia');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('saturday')); ?>" name="<?php echo esc_attr($this->get_field_name('saturday')); ?>" type="text" value="<?php echo esc_attr($saturday); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('sunday')); ?>"><?php esc_html_e('Sunday:', 'greengia'); ?></label>
            <input placeholder="<?php esc_html_e('sunday timing here', 'greengia');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('sunday')); ?>" name="<?php echo esc_attr($this->get_field_name('sunday')); ?>" type="text" value="<?php echo esc_attr($sunday); ?>" />
        </p>
                
		<?php 
	}
	
}

?>