<?php $options = _WSH()->option();
	greengia_bunch_global_variable();
	$icon_href = (greengia_set( $options, 'site_favicon' )) ? greengia_set( $options, 'site_favicon' ) : get_template_directory_uri().'/images/favicon.png';
 ?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<?php if ( ! function_exists( 'has_site_icon' ) || ! has_site_icon() ):?>
	<link rel="shortcut icon" href="<?php echo esc_url($icon_href);?>" type="image/x-icon">
	<link rel="icon" href="<?php echo esc_url($icon_href);?>" type="image/x-icon">
<?php endif;?>
<!-- Responsive -->
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<div class="boxed_wrapper">
 	
    <?php if(greengia_set($options, 'preloader')):?>
    <!-- Preloader -->
    <div class="preloader"></div>
	<?php endif;?>
    
    <header class="main-header">
        <div class="top-bar">
            <div class="container">
                <div class="clearfix">
                    <?php if(greengia_set($options, 'welcome_note') && greengia_set($options, 'iso_number') && greengia_set( $options, 'social_media')):?>
                    <div class="top-bar-text float_left">
                        <ul class="list_inline">
                            
                            <li><i class="icon-winner-trophy-for-the-best"></i><?php echo wp_kses_post(greengia_set($options, 'welcome_note')); ?></li>
                            <li><i class="icon-stamp"></i><?php echo wp_kses_post(greengia_set($options, 'iso_number')); ?></li>
                        	
                        </ul>
                    </div>
                    
                    
                    <div class="right-column float_right">
    					<?php if(greengia_set( $options, 'social_media' ) && is_array( greengia_set( $options, 'social_media' ) )): ?>
                        <ul class="social-icon">
                        	<?php $social_icons = greengia_set( $options, 'social_media' );
							foreach( greengia_set( $social_icons, 'social_media' ) as $social_icon ):
							if( isset( $social_icon['tocopy' ] ) ) continue; ?>
                            <li><a href="<?php echo esc_url(greengia_set( $social_icon, 'social_link')); ?>" target="_blank"><i class="fa <?php echo esc_attr(greengia_set( $social_icon, 'social_icon')); ?>"></i></a></li>
                            <?php endforeach; ?>
                        </ul>
                        <?php endif; ?>
                        <?php if(greengia_set($options, 'lang_switcher')): ?>
                        <div id="polyglotLanguageSwitcher" class="">
                            <?php do_action('wpml_add_language_selector'); ?>
                        </div>
                        <?php endif;?>
                    </div>
                    <?php endif;?>
                </div>
            </div>
        </div>
        
        <div class="header-upper">
            <div class="container">
                <div class="clearfix">
                    
                    <div class="pull-left logo-outer">
                        <div class="logo">
                        	<?php if(greengia_set($options, 'logo_image')):?>
                            <a href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php echo esc_url(greengia_set($options, 'logo_image'));?>" alt="<?php esc_html_e('Arctica', 'greengia');?>" title="<?php esc_html_e('Arctica', 'greengia');?>"></a>
                            <?php else:?>
                            <a href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php echo esc_url(get_template_directory_uri().'/images/logo/logo.png');?>" alt="<?php esc_html_e('Arctica', 'greengia');?>"></a>
                            <?php endif;?>
                        </div>
                    </div>
                    
                    <div class="pull-right upper-right clearfix">
                        
                        <!--Info Box-->
                        <?php if(greengia_set($options, 'phone')):?>
                        <div class="upper-column info-box">
                            <div class="icon-box"><span class="icon-telephone"></span></div>
                            <ul>
                                <li><strong><?php esc_html_e('Call us now', 'greengia'); ?></strong></li>
                                <li><a href="tel:<?php echo esc_url(greengia_set($options, 'phone')); ?>"><?php echo wp_kses_post(greengia_set($options, 'phone')); ?></a></li>
                            </ul>
                        </div>
                        <?php endif;?>
                        <!--Info Box-->
                        <?php if(greengia_set($options, 'email')):?>
                        <div class="upper-column info-box">
                            <div class="icon-box"><span class="icon-letter"></span></div>
                            <ul>
                                <li><strong><?php esc_html_e('Email at', 'greengia'); ?></strong></li>
                                <li><a href="mailto:<?php echo sanitize_email(greengia_set($options, 'email')); ?>"><?php echo sanitize_email(greengia_set($options, 'email')); ?></a></li>
                            </ul>
                        </div>
                        <?php endif;?>
                        <!--Search Box-->
                        <div class="outer-box2">
                            <!--Search form-->
                            <div class="search-form">
                                <?php echo get_template_part('searchform2'); ?>
                            </div>
                        </div>
                        
                    </div>
                    
                </div>
            </div>
        </div>   
    </header>
    
    <section class="theme_menu stricky">
        <div class="container">
            <nav class="main-menu">
                <div class="navbar-header">     
                    <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                    </button>
                </div>
                <div class="navbar-collapse collapse clearfix">
                    <ul class="navigation clearfix">
    					<?php wp_nav_menu( array( 'theme_location' => 'main_menu', 'container_id' => 'navbar-collapse-1',
							'container_class'=>'navbar-collapse collapse navbar-right',
							'menu_class'=>'nav navbar-nav',
							'fallback_cb'=>false, 
							'items_wrap' => '%3$s', 
							'container'=>false,
							'walker'=> new Bunch_Bootstrap_walker()  
						) ); ?>
                    </ul>
                    <ul class="mobile-menu clearfix">
    					<?php wp_nav_menu( array( 'theme_location' => 'main_menu', 'container_id' => 'navbar-collapse-1',
							'container_class'=>'navbar-collapse collapse navbar-right',
							'menu_class'=>'nav navbar-nav',
							'fallback_cb'=>false, 
							'items_wrap' => '%3$s', 
							'container'=>false,
							'walker'=> new Bunch_Bootstrap_walker()  
						) ); ?>
                    </ul>
                </div>
            </nav> <!-- End of #main_menu -->
       </div> <!-- End of .conatiner -->
    </section>
    