<?php add_action('after_setup_theme', 'greengia_bunch_theme_setup');
function greengia_bunch_theme_setup()
{
	global $wp_version;
	if(!defined('GREENGIA_VERSION')) define('GREENGIA_VERSION', '1.0');
	if( !defined( 'GREENGIA_ROOT' ) ) define('GREENGIA_ROOT', get_template_directory().'/');
	if( !defined( 'GREENGIA_URL' ) ) define('GREENGIA_URL', get_template_directory_uri().'/');	
	if( !defined( 'KC_LICENSE' ) ) define('KC_LICENSE', 'twrvqysv-51mw-zgsz-8scg-e03y-7cawas6y3vji');
	include_once get_template_directory() . '/includes/loader.php';
	
	
	load_theme_textdomain('greengia', get_template_directory() . '/languages');
	
	//ADD THUMBNAIL SUPPORT
	add_theme_support('post-thumbnails');
	add_theme_support('woocommerce');
	add_theme_support( 'wc-product-gallery-lightbox' );
	add_theme_support('automatic-feed-links'); //Enables post and comment RSS feed links to head.
	add_theme_support('widgets'); //Add widgets and sidebar support
	add_theme_support( "title-tag" );
	add_theme_support( 'wp-block-styles' );
	add_theme_support( 'align-wide' );
	add_theme_support( 'editor-styles' );
	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form', 'comment-form', 'comment-list', 'gallery', 'caption'
	) );
	/** Register wp_nav_menus */
	if(function_exists('register_nav_menu'))
	{
		register_nav_menus(
			array(
				/** Register Main Menu location header */
				'main_menu' => esc_html__('Main Menu', 'greengia'),
			)
		);
	}
	if ( ! isset( $content_width ) ) $content_width = 960;
	add_image_size( 'greengia_270x220', 270, 220, true ); // '270x220 Project Gallery'
	add_image_size( 'greengia_70x70', 70, 70, true ); // '70x70 Testimonials'
	add_image_size( 'greengia_370x250', 370, 250, true ); // '370x250 Our Team'
	add_image_size( 'greengia_85x85', 85, 85, true ); // '85x85 Testimonials'
	add_image_size( 'greengia_370x200', 370, 200, true ); // '370x200 Services'
	add_image_size( 'greengia_450x400', 450, 400, true ); // '450x400 Gallery Fullwidth'
	add_image_size( 'greengia_270x220', 270, 220, true ); // '270x220 Gallery Grid'
	add_image_size( 'greengia_370x270', 370, 270, true ); // '370x270 Gallery Masnonry'
	add_image_size( 'greengia_370x340', 370, 340, true ); // '370x340 Gallery Masnonry'
	add_image_size( 'greengia_370x430', 370, 430, true ); // '370x430 Gallery Masnonry'
	add_image_size( 'greengia_370x530', 370, 530, true ); // '370x530 Gallery Masnonry'
	add_image_size( 'greengia_370x245', 370, 245, true ); // '370x245 Blog Grid'
	add_image_size( 'greengia_770x440', 770, 440, true ); // '770x440 Blog Single'
	add_image_size( 'greengia_90x80', 90, 80, true ); // '90x80 Recent Post Sidebar'
}

function reengia_gutenberg_editor_palette_styles() {
    add_theme_support( 'editor-color-palette', array(
        array(
            'name' => esc_html__( 'strong yellow', 'greengia' ),
            'slug' => 'strong-yellow',
            'color' => '#f7bd00',
        ),
        array(
            'name' => esc_html__( 'strong white', 'greengia' ),
            'slug' => 'strong-white',
            'color' => '#fff',
        ),
		array(
            'name' => esc_html__( 'light black', 'greengia' ),
            'slug' => 'light-black',
            'color' => '#242424',
        ),
        array(
            'name' => esc_html__( 'very light gray', 'greengia' ),
            'slug' => 'very-light-gray',
            'color' => '#797979',
        ),
        array(
            'name' => esc_html__( 'very dark black', 'greengia' ),
            'slug' => 'very-dark-black',
            'color' => '#000000',
        ),
    ) );
	
	add_theme_support( 'editor-font-sizes', array(
		array(
			'name' => esc_html__( 'Small', 'greengia' ),
			'size' => 10,
			'slug' => 'small'
		),
		array(
			'name' => esc_html__( 'Normal', 'greengia' ),
			'size' => 15,
			'slug' => 'normal'
		),
		array(
			'name' => esc_html__( 'Large', 'greengia' ),
			'size' => 24,
			'slug' => 'large'
		),
		array(
			'name' => esc_html__( 'Huge', 'greengia' ),
			'size' => 36,
			'slug' => 'huge'
		)
	) );
	
}
add_action( 'after_setup_theme', 'reengia_gutenberg_editor_palette_styles' );

function greengia_bunch_widget_init()
{
	global $wp_registered_sidebars;
	$theme_options = _WSH()->option();
	register_sidebar(array(
	  'name' => esc_html__( 'Default Sidebar', 'greengia' ),
	  'id' => 'default-sidebar',
	  'description' => esc_html__( 'Widgets in this area will be shown on the right-hand side.', 'greengia' ),
	  'before_widget'=>'<div id="%1$s" class="widget sidebar-widget %2$s">',
	  'after_widget'=>'</div>',
	  'before_title' => '<div class="section-title style-2"><h4>',
	  'after_title' => '</h4></div>'
	));
	register_sidebar(array(
	  'name' => esc_html__( 'Footer Sidebar', 'greengia' ),
	  'id' => 'footer-sidebar',
	  'description' => esc_html__( 'Widgets in this area will be shown in Footer Area.', 'greengia' ),
	  'before_widget'=>'<div id="%1$s" class="col-md-3 col-sm-6 col-xs-12 footer-widget footer-column %2$s">',
	  'after_widget'=>'</div>',
	  'before_title' => '<div class="footer-title"><h4>',
	  'after_title' => '</h4></div>'
	));
	
	register_sidebar(array(
	  'name' => esc_html__( 'Blog Listing', 'greengia' ),
	  'id' => 'blog-sidebar',
	  'description' => esc_html__( 'Widgets in this area will be shown on the right-hand side.', 'greengia' ),
	  'before_widget'=>'<div id="%1$s" class="widget sidebar-widget %2$s">',
	  'after_widget'=>'</div>',
	  'before_title' => '<div class="section-title style-2"><h4>',
	  'after_title' => '</h4></div>'
	));
	if( !is_object( _WSH() )  )  return;
	$sidebars = greengia_set(greengia_set( $theme_options, 'dynamic_sidebar' ) , 'dynamic_sidebar' ); 
	foreach( array_filter((array)$sidebars) as $sidebar)
	{
		if(greengia_set($sidebar , 'topcopy')) continue ;
		
		$name = greengia_set( $sidebar, 'sidebar_name' );
		
		if( ! $name ) continue;
		$slug = greengia_bunch_slug( $name );
		
		register_sidebar( array(
			'name' => $name,
			'id' =>  sanitize_title( $slug ) ,
			'before_widget' => '<div id="%1$s" class="side-bar widget %2$s">',
			'after_widget' => "</div>",
			'before_title' => '<div class="section-title style-2"><h4>',
			'after_title' => '</h4></div>',
		) );		
	}
	
	update_option('wp_registered_sidebars' , $wp_registered_sidebars) ;
}
add_action( 'widgets_init', 'greengia_bunch_widget_init' );
// Update items in cart via AJAX
function greengia_load_head_scripts() {
	$options = _WSH()->option();
    if ( !is_admin() ) {
		$protocol = is_ssl() ? 'https://' : 'http://';
		if(greengia_set($options, 'map_api_key')){
		$map_path = '?key='.greengia_set($options, 'map_api_key');
		wp_enqueue_script( 'map_api', ''.$protocol.'maps.google.com/maps/api/js'.$map_path, array(), false, false );
		wp_enqueue_script( 'jquery-googlemap', get_template_directory_uri().'/js/gmap.js', array(), false, false );
		}
	}
}
add_action( 'wp_enqueue_scripts', 'greengia_load_head_scripts' );
//global variables
function greengia_bunch_global_variable() {
    global $wp_query;
}

function greengia_enqueue_scripts() {
    //styles
	wp_enqueue_style( 'bootstrap', get_template_directory_uri() . '/css/bootstrap.min.css' );
	wp_enqueue_style( 'bootstrap-select', get_template_directory_uri() . '/css/bootstrap-select.min.css' );
	wp_enqueue_style( 'bootstrap-touchspin', get_template_directory_uri() . '/css/jquery.bootstrap-touchspin.css' );
	wp_enqueue_style( 'fontawesome', get_template_directory_uri() . '/css/font-awesome.css' );
	wp_enqueue_style( 'flaticon', get_template_directory_uri() . '/css/flaticon.css' );
	wp_enqueue_style( 'icomoon', get_template_directory_uri() . '/css/icomoon.css' );
	wp_enqueue_style( 'owl-carousel', get_template_directory_uri() . '/css/owl.carousel.css' );
	wp_enqueue_style( 'bxslider', get_template_directory_uri() . '/css/jquery.bxslider.css' );
	wp_enqueue_style( 'flexslider', get_template_directory_uri() . '/css/flexslider.css' );
	wp_enqueue_style( 'gui', get_template_directory_uri() . '/css/gui.css' );
	wp_enqueue_style( 'fancybox', get_template_directory_uri() . '/css/jquery.fancybox.css' );
	wp_enqueue_style( 'language-switcher', get_template_directory_uri() . '/css/polyglot-language-switcher.css' );
	wp_enqueue_style( 'animate', get_template_directory_uri() . '/css/animate.min.css' );
	wp_enqueue_style( 'nouislider', get_template_directory_uri() . '/css/nouislider.css' );
	wp_enqueue_style( 'nouislider.pips', get_template_directory_uri() . '/css/nouislider.pips.css' );
	wp_enqueue_style( 'magnific-popup', get_template_directory_uri() . '/css/magnific-popup.css' );
	wp_enqueue_style( 'common-style', get_template_directory_uri() . '/css/common-style.css' );
	wp_enqueue_style( 'greengia-main-style', get_stylesheet_uri() );
	wp_enqueue_style( 'greengia-custom-style', get_template_directory_uri() . '/css/custom.css' );
	wp_enqueue_style( 'greengia-gutenberg', get_template_directory_uri() . '/css/gutenberg.css' );
	wp_enqueue_style( 'greengia-responsive', get_template_directory_uri() . '/css/responsive.css' );
	
	
    //scripts
	wp_enqueue_script( 'jquery-ui-core' );
	wp_enqueue_script( 'bootstrap', get_template_directory_uri().'/js/bootstrap.min.js', array(), false, true );
	wp_enqueue_script( 'owl', get_template_directory_uri().'/js/owl.carousel.min.js', array(), false, true );
	wp_enqueue_script( 'mixitup', get_template_directory_uri().'/js/jquery.mixitup.min.js', array(), false, true );
	wp_enqueue_script( 'fancybox-pack', get_template_directory_uri().'/js/jquery.fancybox.pack.js', array(), false, true );
	wp_enqueue_script( 'imagezoom', get_template_directory_uri().'/js/imagezoom.js', array(), false, true );
	wp_enqueue_script( 'magnific-popup', get_template_directory_uri().'/js/jquery.magnific-popup.min.js', array(), false, true );
	wp_enqueue_script( 'language-switcher', get_template_directory_uri().'/js/jquery.polyglot.language.switcher.js', array(), false, true );
	wp_enqueue_script( 'SmoothScroll', get_template_directory_uri().'/js/SmoothScroll.js', array(), false, true );
	wp_enqueue_script( 'appear', get_template_directory_uri().'/js/jquery.appear.js', array(), false, true );
	wp_enqueue_script( 'countTo', get_template_directory_uri().'/js/jquery.countTo.js', array(), false, true );
	wp_enqueue_script( 'wow', get_template_directory_uri().'/js/wow.js', array(), false, true );
	wp_enqueue_script( 'fitvids', get_template_directory_uri().'/js/jquery.fitvids.js', array(), false, true );
	wp_enqueue_script( 'nouislider', get_template_directory_uri().'/js/nouislider.js', array(), false, true );
	wp_enqueue_script( 'isotope', get_template_directory_uri().'/js/isotope.js', array(), false, true );
	wp_enqueue_script( 'bootstrap-touchspin', get_template_directory_uri().'/js/jquery.bootstrap-touchspin.js', array(), false, true );
	wp_enqueue_script( 'gui', get_template_directory_uri().'/js/gui.js', array(), false, true );
	wp_enqueue_script( 'bootstrap-select', get_template_directory_uri().'/js/bootstrap-select.min.js', array(), false, true );
	wp_enqueue_script( 'flexslider', get_template_directory_uri().'/js/jquery.flexslider.js', array(), false, true );
	wp_enqueue_script( 'default-map', get_template_directory_uri().'/js/default-map.js', array(), false, true );
	wp_enqueue_script( 'greengia-main-script', get_template_directory_uri().'/js/custom.js', array(), false, true );
	if( is_singular() ) wp_enqueue_script('comment-reply');
	
}
add_action( 'wp_enqueue_scripts', 'greengia_enqueue_scripts' );

/*-------------------------------------------------------------*/
function greengia_theme_slug_fonts_url() {
    $fonts_url = '';
 
    /* Translators: If there are characters in your language that are not
    * supported by Lora, translate this to 'off'. Do not translate
    * into your own language.
    */
	$roboto_slab = _x( 'on', 'Roboto Slab font: on or off', 'greengia' );
    $roboto = _x( 'on', 'Roboto font: on or off', 'greengia' );
 
    if ( 'off' !== $roboto_slab || 'off' !== $roboto ) {
        $font_families = array();
		
		if ( 'off' !== $roboto_slab ) {
            $font_families[] = 'Roboto Slab:400,700';
        }
		
		if ( 'off' !== $roboto ) {
            $font_families[] = 'Roboto:300,400,500,700';
        }
 
        $opt = get_option('greengia'.'_theme_options');
		if ( greengia_set( $opt, 'body_custom_font' ) ) {
			if ( $custom_font = greengia_set( $opt, 'body_font_family' ) )
				$font_families[] = $custom_font . ':300,300i,400,400i,600,700';
		}
		if ( greengia_set( $opt, 'use_custom_font' ) ) {
			$font_families[] = greengia_set( $opt, 'h1_font_family' ) . ':300,300i,400,400i,600,700';
			$font_families[] = greengia_set( $opt, 'h2_font_family' ) . ':300,300i,400,400i,600,700';
			$font_families[] = greengia_set( $opt, 'h3_font_family' ) . ':300,300i,400,400i,600,700';
			$font_families[] = greengia_set( $opt, 'h4_font_family' ) . ':300,300i,400,400i,600,700';
			$font_families[] = greengia_set( $opt, 'h5_font_family' ) . ':300,300i,400,400i,600,700';
			$font_families[] = greengia_set( $opt, 'h6_font_family' ) . ':300,300i,400,400i,600,700';
		}
		$font_families = array_unique( $font_families);
        $query_args = array(
            'family' => urlencode( implode( '|', $font_families ) ),
            'subset' => urlencode( 'latin,latin-ext' ),
        );
 
        $fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
    }
 
    return esc_url_raw( $fonts_url );
}
function greengia_theme_slug_scripts_styles() {
    wp_enqueue_style( 'greengia-theme-slug-fonts', greengia_theme_slug_fonts_url(), array(), null );
}
add_action( 'wp_enqueue_scripts', 'greengia_theme_slug_scripts_styles' );
/*---------------------------------------------------------------------*/
function reengia_add_editor_styles() {
    add_editor_style( 'editor-style.css' );
}
add_action( 'admin_init', 'reengia_add_editor_styles' );
/**
 * WooCommerce Extra Feature
 * --------------------------
 *
 * Change number of related products on product page
 * Set your own value for 'posts_per_page'
 *
 */ 
function greengia_woo_related_products_limit() {
  global $product;
	
	$args['posts_per_page'] = 6;
	return $args;
}
add_filter( 'woocommerce_output_related_products_args', 'greengia_jk_related_products_args' );
  function greengia_jk_related_products_args( $args ) {
	$args['posts_per_page'] = 3; // 4 related products
	$args['columns'] = 3; // arranged in 2 columns
	return $args;
}