<?php
//Setup theme constant and default data
$theme_obj = wp_get_theme('grandwedding');

define("GRANDWEDDING_THEMENAME", $theme_obj['Name']);
if (!defined('GRANDWEDDING_THEMEDEMO'))
{
	define("GRANDWEDDING_THEMEDEMO", false);
}
define("GRANDWEDDING_THEMEDEMOIG", 'kinfolklifestyle');
define("GRANDWEDDING_SHORTNAME", "pp");
define("GRANDWEDDING_THEMEVERSION", $theme_obj['Version']);
define("GRANDWEDDING_THEMEDEMOURL", $theme_obj['ThemeURI']);
define("GRANDWEDDING_THEMEDATEFORMAT", get_option('date_format'));
define("GRANDWEDDING_THEMETIMEFORMAT", get_option('time_format'));
define("ENVATOITEMID", 19983430);
define("GRANDWEDDING_BUILDERDOCURL", 'https://themes.themegoods.com/grandwedding/doc/create-a-page-using-content-builder-2/');

//Get default WP uploads folder
$wp_upload_arr = wp_upload_dir();
define("GRANDWEDDING_THEMEUPLOAD", $wp_upload_arr['basedir']."/".strtolower(sanitize_title(GRANDWEDDING_THEMENAME))."/");
define("GRANDWEDDING_THEMEUPLOADURL", $wp_upload_arr['baseurl']."/".strtolower(sanitize_title(GRANDWEDDING_THEMENAME))."/");

if(!is_dir(GRANDWEDDING_THEMEUPLOAD))
{
	wp_mkdir_p(GRANDWEDDING_THEMEUPLOAD);
}

/**
*  Begin Global variables functions
*/

//Get default WordPress post variable
function grandwedding_get_wp_post() {
	global $post;
	return $post;
}

//Get default WordPress file system variable
function grandwedding_get_wp_filesystem() {
	require_once(ABSPATH . 'wp-admin/includes/file.php');
	WP_Filesystem();
	global $wp_filesystem;
	return $wp_filesystem;
}

//Get default WordPress wpdb variable
function grandwedding_get_wpdb() {
	global $wpdb;
	return $wpdb;
}

//Get default WordPress wp_query variable
function grandwedding_get_wp_query() {
	global $wp_query;
	return $wp_query;
}

//Get default WordPress customize variable
function grandwedding_get_wp_customize() {
	global $wp_customize;
	return $wp_customize;
}

//Get default WordPress current screen variable
function grandwedding_get_current_screen() {
	global $current_screen;
	return $current_screen;
}

//Get default WordPress paged variable
function grandwedding_get_paged() {
	global $paged;
	return $paged;
}

//Get default WordPress registered widgets variable
function grandwedding_get_registered_widget_controls() {
	global $wp_registered_widget_controls;
	return $wp_registered_widget_controls;
}

//Get default WordPress registered sidebars variable
function grandwedding_get_registered_sidebars() {
	global $wp_registered_sidebars;
	return $wp_registered_sidebars;
}

//Get default Woocommerce variable
function grandwedding_get_woocommerce() {
	global $woocommerce;
	return $woocommerce;
}

//Get all google font usages in customizer
function grandwedding_get_google_fonts() {
	$grandwedding_google_fonts = array('tg_body_font', 'tg_header_font', 'tg_menu_font', 'tg_sidemenu_font', 'tg_sidebar_title_font', 'tg_button_font');
	
	global $grandwedding_google_fonts;
	return $grandwedding_google_fonts;
}

//Get menu transparent variable
function grandwedding_get_page_menu_transparent() {
	global $grandwedding_page_menu_transparent;
	return $grandwedding_page_menu_transparent;
}

//Set menu transparent variable
function grandwedding_set_page_menu_transparent($new_value = '') {
	global $grandwedding_page_menu_transparent;
	$grandwedding_page_menu_transparent = $new_value;
}

//Get no header checker variable
function grandwedding_get_is_no_header() {
	global $grandwedding_is_no_header;
	return $grandwedding_is_no_header;
}

//Get deafult theme screen CSS class
function grandwedding_get_screen_class() {
	global $grandwedding_screen_class;
	return $grandwedding_screen_class;
}

//Set deafult theme screen CSS class
function grandwedding_set_screen_class($new_value = '') {
	global $grandwedding_screen_class;
	$grandwedding_screen_class = $new_value;
}

//Get theme homepage style
function grandwedding_get_homepage_style() {
	global $grandwedding_homepage_style;
	return $grandwedding_homepage_style;
}

//Set theme homepage style
function grandwedding_set_homepage_style($new_value = '') {
	global $grandwedding_homepage_style;
	$grandwedding_homepage_style = $new_value;
}

//Get page gallery ID
function grandwedding_get_page_gallery_id() {
	global $grandwedding_page_gallery_id;
	return $grandwedding_page_gallery_id;
}

//Get default theme options variable
function grandwedding_get_options() {
	global $grandwedding_options;
	return $grandwedding_options;
}

//Set default theme options variable
function grandwedding_set_options($new_value = '') {
	global $grandwedding_options;
	$grandwedding_options = $new_value;
}

//Get top bar setting
function grandwedding_get_topbar() {
	global $grandwedding_topbar;
	return $grandwedding_topbar;
}

//Set top bar setting
function grandwedding_set_topbar($new_value = '') {
	global $grandwedding_topbar;
	$grandwedding_topbar = $new_value;
}

//Get is hide title option
function grandwedding_get_hide_title() {
	global $grandwedding_hide_title;
	return $grandwedding_hide_title;
}

//Set is hide title option
function grandwedding_set_hide_title($new_value = '') {
	global $grandwedding_hide_title;
	$grandwedding_hide_title = $new_value;
}

//Get theme page content CSS class
function grandwedding_get_page_content_class() {
	global $grandwedding_page_content_class;
	return $grandwedding_page_content_class;
}

//Set theme page content CSS class
function grandwedding_set_page_content_class($new_value = '') {
	global $grandwedding_page_content_class;
	$grandwedding_page_content_class = $new_value;
}

//Get Kirki global variable
function grandwedding_get_kirki() {
	global $kirki;
	return $kirki;
}

//Get admin theme global variable
function grandwedding_get_wp_admin_css_colors() {
	global $_wp_admin_css_colors;
	return $_wp_admin_css_colors;
}

//Get theme plugins
function grandwedding_get_plugins() {
	global $grandwedding_tgm_plugins;
	return $grandwedding_tgm_plugins;
}

//Set theme plugins
function grandwedding_set_plugins($new_value = '') {
	global $grandwedding_tgm_plugins;
	$grandwedding_tgm_plugins = $new_value;
}

//Get page custom fields values
function grandwedding_get_page_postmetas() {
	//Get all sidebars
	$theme_sidebar = array(
		'' => '',
		'Page Sidebar' => 'Page Sidebar', 
		'Contact Sidebar' => 'Contact Sidebar', 
		'Blog Sidebar' => 'Blog Sidebar',
	);
	
	$dynamic_sidebar = get_option('pp_sidebar');
	
	if(!empty($dynamic_sidebar))
	{
		foreach($dynamic_sidebar as $sidebar)
		{
			$theme_sidebar[$sidebar] = $sidebar;
		}
	}
	
	/*
		Get gallery list
	*/
	$args = array(
	    'numberposts' => -1,
	    'post_type' => array('galleries'),
	);
	
	$galleries_arr = get_posts($args);
	$galleries_select = array();
	$galleries_select[0] = '';
	
	foreach($galleries_arr as $gallery)
	{
		$galleries_select[$gallery->ID] = $gallery->post_title;
	}
	
	/*
		Get page templates list
	*/
	if(function_exists('get_page_templates'))
	{
		$page_templates = get_page_templates();
		$page_templates_select = array();
		$page_key = 1;
		
		foreach ($page_templates as $template_name => $template_filename) 
		{
			$page_templates_select[$template_name] = get_template_directory_uri()."/functions/images/page/".basename($template_filename, '.php').".png";
			$page_key++;
		}
	}
	else
	{
		$page_templates_select = array();
	}
	
	/*
		Get all menus available
	*/
	$menus = get_terms('nav_menu');
	$menus_select = array(
		 '' => 'Default Menu'
	);
	foreach($menus as $each_menu)
	{
		$menus_select[$each_menu->slug] = $each_menu->name;
	}
	
	$grandwedding_page_postmetas = array();
	$pp_menu_layout = get_option('pp_menu_layout');
		
	if($pp_menu_layout != 'leftmenu')
	{
	    $grandwedding_page_postmetas[99] = array("section" => "Page Menu", "id" => "page_menu_transparent", "type" => "checkbox", "title" => "Make Menu Transparent", "description" => "Check this option if you want to display main menu in transparent");
	}
	
	$grandwedding_page_postmetas_extended = 
		array (
			/*
				Begin Page custom fields
			*/
			array("section" => esc_html__('Page Template', 'grandwedding' ), "id" => "page_custom_template", "type" => "template", "title" => esc_html__('Page Template', 'grandwedding' ), "description" => esc_html__('Select template for this page', 'grandwedding' ), "items" => $page_templates_select),
			
			array("section" => esc_html__('Page Title', 'grandwedding' ), "id" => "page_show_title", "type" => "checkbox", "title" => esc_html__('Hide Default Page Header', 'grandwedding' ), "description" => esc_html__('Check this option if you want to hide default page header', 'grandwedding' )),
			
			array("section" => esc_html__('Footer', 'grandwedding' ), "id" => "page_show_footer_sidebar", "type" => "checkbox", "title" => esc_html__('Hide Page Footer Sidebar', 'grandwedding' ), "description" => esc_html__('Check this option if you want to hide page footer sidebar', 'grandwedding' )),
			
			array("section" => esc_html__('Page Tagline', 'grandwedding' ), "id" => "page_tagline", "type" => "textarea", "title" => esc_html__('Page Tagline (Optional)', 'grandwedding' ), "description" => esc_html__('Enter page tagline. It will displays under page title (*Note: HTML code also support)', 'grandwedding' )),
			
			array(
    			"section" 		=> esc_html__('Page Attributes', 'grandwedding' ), 
    			"id" 			=> "page_header_type", 
    			"type" 			=> "select", 
    			"title" 		=> esc_html__('Header Content Type', 'grandwedding' ), 
    			"description" 	=> esc_html__('Select header content type for this page.', 'grandwedding' ), 
				"items" 		=> array(
					"Image" => "Featured Image",
					"Vimeo Video" => "Vimeo Video",
					"Youtube Video" => "Youtube Video",
			)),
				
			array(
				"section" 		=> esc_html__('Page Attributes', 'grandwedding' ), 
				"id" 			=> "page_header_vimeo", 
				"type" 			=> "text", 
				"title" 		=> esc_html__('Vimeo Video ID (Optional)', 'grandwedding' ), 
				"description" 	=> esc_html__('Please enter Vimeo Video ID for example 73317780', 'grandwedding' )
			),
			
			array(
				"section" 		=> esc_html__('Page Attributes', 'grandwedding' ), 
				"id" 			=> "page_header_youtube", 
				"type" 			=> "text", 
				"title" 		=> esc_html__('Youtube Video ID (Optional)', 'grandwedding' ), 
				"description" 	=> esc_html__('Please enter Youtube Video ID for example 6AIdXisPqHc', 'grandwedding' )
			),
			
			array("section" => esc_html__('Select Sidebar (Optional)', 'grandwedding' ), "id" => "page_sidebar", "type" => "select", "title" => esc_html__('Page Sidebar (Optional)', 'grandwedding' ), "description" => esc_html__('Select this page sidebar to display. To use this option, you have to select page template end with "Sidebar" only', 'grandwedding' ), "items" => $theme_sidebar),
			
			array("section" => esc_html__('Select Menu', 'grandwedding' ), "id" => "page_menu", "type" => "select", "title" => esc_html__('Page Menu (Optional)', 'grandwedding' ), "description" => esc_html__('Select this page menu if you want to display main menu other than default one', 'grandwedding' ), "items" => $menus_select),
			
			array("section" => "Content Type", "id" => "page_gallery_id", "type" => "select", "title" => "Gallery", "description" => "You can select image gallery to display on this page. To use this option, you have to select Gallery as page template.", "items" => $galleries_select),
		);
	
	
	$grandwedding_page_postmetas = $grandwedding_page_postmetas + $grandwedding_page_postmetas_extended;
		
	return $grandwedding_page_postmetas;
}
?>