<?php
/**
 * Template Name: Gallery
 * The main template file for display gallery page
 *
 * @package WordPress
*/

$grandwedding_page_gallery_id = get_post_meta($post->ID, 'page_gallery_id', true);
$gallery_template = get_post_meta($grandwedding_page_gallery_id, 'gallery_template', true);
$grandwedding_page_gallery_id = grandwedding_get_page_gallery_id();

if(!empty($grandwedding_page_gallery_id))
{
	switch($gallery_template)
	{	
	    case 'Gallery 1 Column':
			get_template_part("single-gallery-1");
			exit;
		break;
		
		case 'Gallery 2 Columns':
			get_template_part("single-gallery-2");
			exit;
		break;
		
		case 'Gallery 3 Columns':
			get_template_part("single-gallery-3");
			exit;
		break;
		
		case 'Gallery 4 Columns':
			get_template_part("single-gallery-4");
			exit;
		break;
		
		case 'Gallery Kenburns':
			get_template_part("single-gallery-kenburns");
			exit;
		break;
		
		case 'Gallery Fullscreen':
		default:
			get_template_part("single-gallery-fullscreen");
			exit;
		break;
		
		case 'Gallery Flow':
			get_template_part("single-gallery-flow");
			exit;
		break;
		
		case 'Gallery Horizontal':
			get_template_part("single-gallery-horizontal");
			exit;
		break;
	}
}
else
{
	echo 'Please select gallery you want to display in page options.';
}

exit;
?>