<?php
/**
 * The style "default" of the Price block
 *
 * @package WordPress
 * @subpackage ThemeREX Addons
 * @since v1.2
 */

$args = get_query_var('trx_addons_args_sc_price');
?><div <?php if (!empty($args['id'])) echo ' id="'.esc_attr($args['id']).'"'; ?> 
	class="sc_price sc_price_<?php
			echo esc_attr($args['type']);
			if (!empty($args['class'])) echo ' '.esc_attr($args['class']);
	?>"<?php
	if (!empty($args['css'])) echo ' style="'.esc_attr($args['css']).'"';
?>><?php

	?><div class="sc_price_info"><?php

		if (!empty($args['title'])) {
			?><div class="sc_price_title"><?php
				if (!empty($args['link'])) {
					?><a href="<?php echo esc_url($args['link']); ?>"><?php
				} 
				echo esc_html($args['title']); 
				if (!empty($args['link'])) {
					?></a><?php
				} 
			?></div><?php
		}
		
		if (!empty($args['content'])) {
			?><div class="sc_price_details"><?php trx_addons_show_layout($args['content']); ?></div><?php
		}
		
		if (!empty($args['price1_1']) || !empty($args['price1_2']) || !empty($args['price2_1']) || !empty($args['price2_2'])) {
			?><div class="sc_price_price"><?php
			if (!empty($args['price1_1']) || !empty($args['price1_2'])) { ?>
				<div class="sc_price_prices sc_price_first"> <?php
					if (!empty($args['price_label1'])) {
						?><div class="sc_price_label"><?php echo esc_html($args['price_label1']); ?></div><?php
					}
					if (!empty($args['price1_1'])) {
						$price = str_replace(array('{','}'),array('<sub>','</sub>'),$args['price1_1']);
						?><div class="sc_price_value"><?php echo wp_kses_post($price); ?></div><?php
					}
					if (!empty($args['price1_2'])) {
						$price = str_replace(array('{','}'),array('<sub>','</sub>'),$args['price1_2']);
						?><div class="sc_price_value"><?php echo wp_kses_post($price); ?></div><?php
					} ?>
				</div> <?php
			}
			if (!empty($args['price2_1']) || !empty($args['price2_2'])) { ?>
				<div class="sc_price_prices sc_price_second"> <?php
					if (!empty($args['price_label2'])) {
						?><div class="sc_price_label"><?php echo esc_html($args['price_label2']); ?></div><?php
					}
					if (!empty($args['price2_1'])) {
						$price = str_replace(array('{','}'),array('<sub>','</sub>'),$args['price2_1']);
						?><div class="sc_price_value"><?php echo wp_kses_post($price); ?></div><?php
					}
					if (!empty($args['price2_2'])) {
						$price = str_replace(array('{','}'),array('<sub>','</sub>'),$args['price2_2']);
						?><div class="sc_price_value"><?php echo wp_kses_post($price); ?></div><?php
					} ?>
				</div> <?php
			}
			?></div><?php
		}

	?></div><?php
	if (!empty($args['link']) && !empty($args['link_text'])) {
		?><a href="<?php echo esc_url($args['link']); ?>" class="sc_price_link"><?php echo esc_html($args['link_text']); ?></a><?php
	} ?>
</div>