<?php
/**
 * The template to display the cars compare table
 *
 * @package WordPress
 * @subpackage ThemeREX Addons
 * @since v1.6.25
 */

get_header(); 

do_action('trx_addons_action_start_compare_list');

if (have_posts()) {
	$output = array(
		'thumb'			=> array(''),
		'title'			=> array(esc_html__('Name', 'grab-taxi')),
		'price'			=> array(esc_html__('Price', 'grab-taxi')),
		'type'			=> array(esc_html__('Type', 'grab-taxi')),
		'maker'			=> array(esc_html__('Maker', 'grab-taxi')),
		'model'			=> array(esc_html__('Model', 'grab-taxi')),
		'status'		=> array(esc_html__('Status', 'grab-taxi')),
		'city'			=> array(esc_html__('City', 'grab-taxi')),
		'fuel'			=> array(esc_html__('Fuel', 'grab-taxi')),
		'transmission'	=> array(esc_html__('Transmission', 'grab-taxi')),
		'type_drive'	=> array(esc_html__('Type of drive', 'grab-taxi')),
		'engine_type'	=> array(esc_html__('Engine type', 'grab-taxi')),
		'engine_size'	=> array(esc_html__('Engine size', 'grab-taxi')),
		'engine_power_horses'	=> array(esc_html__('Engine power (in horses)', 'grab-taxi')),
		'engine_power_wt'		=> array(esc_html__('Engine power (in watts)', 'grab-taxi')),
		'doors'	=> array(esc_html__('Doors', 'grab-taxi')),
		'passengers'	=> array(esc_html__('Passengers', 'grab-taxi')),
		'luggage'	=> array(esc_html__('Luggage', 'grab-taxi')),
		'mileage'		=> array(esc_html__('Mileage', 'grab-taxi')),
		'produced'		=> array(esc_html__('Produced', 'grab-taxi')),
		'id'			=> array(esc_html__('Car ID', 'grab-taxi'))
	);
	$features = trx_addons_get_list_terms(false, TRX_ADDONS_CPT_CARS_TAXONOMY_FEATURES);
	if (is_array($features)) {
		foreach ($features as $id=>$title)
			$output['feature_'.trim($id)] = array($title);
	}

	$links_title = esc_html__('Show all cars from %s', 'grab-taxi');

	while ( have_posts() ) { the_post(); 
		$meta = get_post_meta(get_the_ID(), 'trx_addons_options', true);
		$output['thumb'][] = has_post_thumbnail() 
									? get_the_post_thumbnail(get_the_ID(), trx_addons_get_thumb_size('medium'), array(
																												'alt' => the_title_attribute(array( 'echo' => false ))
																												))
									: '';
		$output['title'][] = '<a href="'.esc_url(get_permalink()).'">' . esc_html(get_the_title()) . '</a>'; 
		$output['price'][] = (!empty($meta['before_price'])
								? trx_addons_prepare_macros($meta['before_price']).' '
								: '')
							. (!empty($meta['price'])
								? trx_addons_format_price($meta['price'])
								: '')
							. (!empty($meta['price']) && !empty($meta['price2'])
								? '<span class="cars_price_delimiter"></span>'
								: '')
							. (!empty($meta['price2'])
								? trx_addons_format_price($meta['price2'])
								: '')
							. (!empty($meta['after_price'])
								? ' '.trx_addons_prepare_macros($meta['after_price'])
								: '');
		$output['type'][]  = trx_addons_get_post_terms(', ', get_the_ID(), TRX_ADDONS_CPT_CARS_TAXONOMY_TYPE);
		$output['status'][]= trx_addons_get_post_terms(', ', get_the_ID(), TRX_ADDONS_CPT_CARS_TAXONOMY_STATUS);
		$output['maker'][] = trx_addons_get_post_terms(', ', get_the_ID(), TRX_ADDONS_CPT_CARS_TAXONOMY_MAKER);
		$output['model'][] = trx_addons_get_post_terms(', ', get_the_ID(), TRX_ADDONS_CPT_CARS_TAXONOMY_MODEL);
		$output['city'][]  = trx_addons_get_post_terms(', ', get_the_ID(), TRX_ADDONS_CPT_CARS_TAXONOMY_CITY);
		$output['fuel'][]  = trx_addons_get_option_title(TRX_ADDONS_CPT_CARS_PT, 'fuel', $meta['fuel']);
		$output['transmission'][]= trx_addons_get_option_title(TRX_ADDONS_CPT_CARS_PT, 'transmission', $meta['transmission']);
		$output['type_drive'][]  = trx_addons_get_option_title(TRX_ADDONS_CPT_CARS_PT, 'type_drive', $meta['type_drive']); 
		$output['engine_type'][] = $meta['engine_type'];
		$output['engine_size'][] = $meta['engine_size'] . ($meta['engine_size_prefix'] 
														? ' ' . trx_addons_prepare_macros($meta['engine_size_prefix'])
														: '');
		$output['engine_power_horses'][] = $meta['engine_power_horses'];
		$output['engine_power_wt'][] = $meta['engine_power_wt'];
		$output['doors'][] = $meta['doors'] . ($meta['doors_prefix'] 
														? ' ' . trx_addons_prepare_macros($meta['doors_prefix'])
														: '');
		$output['passengers'][] = $meta['passengers'] . ($meta['passengers_prefix'] 
														? ' ' . trx_addons_prepare_macros($meta['passengers_prefix'])
														: '');												
		$output['luggage'][] = $meta['luggage'] . ($meta['luggage_prefix'] 
														? ' ' . trx_addons_prepare_macros($meta['luggage_prefix'])
														: '');												
		$output['mileage'][] = trx_addons_num2kilo($meta['mileage']). ($meta['mileage_prefix'] 
														? ' ' . trx_addons_prepare_macros($meta['mileage_prefix'])
														: '');
		$output['produced'][] = $meta['produced'];
		$output['id'][] = $meta['id'];
		// Add features
		$features = get_the_terms(get_the_ID(), TRX_ADDONS_CPT_CARS_TAXONOMY_FEATURES);
		$features_in_prop = array();
		if ( !empty( $features ) ) {
			foreach( $features as $term )
				$features_in_prop['feature_'.trim($term->term_id)][] = 1;
		}
		foreach( $output as $k=>$v ) {
			if (substr($k, 0, 8) == 'feature_') {
				$output[$k][] = !empty($features_in_prop[$k])
									? '<span class="cars_feature_present trx_addons_icon-ok"></span>'
									: '';
			}
		}
	}
	wp_reset_postdata();

	?><div class="sc_cars sc_cars_compare">
		<table class="sc_cars_compare_table" border="0" cellpadding="0" cellspacing="0" width="100%">
			<?php
			foreach( $output as $k=>$v ) {
				?><tr class="sc_cars_compare_<?php echo esc_attr($k); ?>"><?php
					for ($i=0; $i<count($v); $i++) {
						?><td class="sc_cars_compare_<?php grab_taxi_show_layout($i==0 ? 'title' : 'data'); ?>"><?php
							trx_addons_show_layout($v[$i]);
						?></td><?php
					}
				?></tr><?php
			}
			?>
		</table>
	</div><!-- .sc_cars --><?php

} else {

	trx_addons_get_template_part('templates/tpl.posts-none.php');

}

do_action('trx_addons_action_end_compare_list');

get_footer();
?>