<?php
/**
 * Default Theme Options and Internal Theme Settings
 *
 * @package WordPress
 * @subpackage GRAB_TAXI
 * @since GRAB_TAXI 1.0
 */

// Theme init priorities:
// Action 'after_setup_theme'
// 1 - register filters to add/remove lists items in the Theme Options
// 2 - create Theme Options
// 3 - add/remove Theme Options elements
// 5 - load Theme Options. Attention! After this step you can use only basic options (not overriden)
// 9 - register other filters (for installer, etc.)
//10 - standard Theme init procedures (not ordered)
// Action 'wp'
// 1 - detect override mode. Attention! Only after this step you can use overriden options (separate values for the shop, courses, etc.)


if ( !function_exists('grab_taxi_options_theme_setup1') ) {
	add_action( 'after_setup_theme', 'grab_taxi_options_theme_setup1', 1 );
	function grab_taxi_options_theme_setup1() {
		
		// -----------------------------------------------------------------
		// -- ONLY FOR PROGRAMMERS, NOT FOR CUSTOMER
		// -- Internal theme settings
		// -----------------------------------------------------------------
		grab_taxi_storage_set('settings', array(
			
			'disable_jquery_ui'		=> false,		// Prevent loading custom jQuery UI libraries in the third-party plugins
		
			'max_load_fonts'		=> 3,			// Max fonts number to load from Google fonts or from uploaded fonts
		
			'use_mediaelements'		=> true,		// Load script "Media Elements" to play video and audio
		
			'max_excerpt_length'	=> 40,			// Max words number for the excerpt in the blog style 'Excerpt'.
													// For style 'Classic' - get half from this value

			'comment_maxlength'		=> 1000,		// Max length of the message from contact form

			'comment_after_name'	=> true,		// Place 'comment' field before the 'name' and 'email'
			
			'socials_type'			=> 'icons',		// Type of socials:
													// icons - use fontello icons to present social networks
													// images - use images from theme's folder trx_addons/css/icons.png
			
			'icons_type'			=> 'icons',		// Type of other icons:
													// icons - use fontello icons to present icons
													// images - use images from theme's folder trx_addons/css/icons.png
			
			'icons_selector'		=> 'vc'	// Icons selector in the shortcodes:
													// vc (default) - standard VC icons selector (very slow and don't support images)
													// internal - internal popup with plugin's or theme's icons list (fast)
		));
	}
}


// -----------------------------------------------------------------
// -- Theme options for customizer
// -----------------------------------------------------------------
if (!function_exists('grab_taxi_options_create')) {

	function grab_taxi_options_create() {

		// Message about options override. 
		// Attention! Not need esc_html() here, because this message put in wp_kses_data() below
		$msg_override = wp_kses_data( __('<b>Attention!</b> Some of these options can be overridden in the following sections (Homepage, Blog archive, Shop, Events, etc.) or in the settings of individual pages', 'grab-taxi'));

		grab_taxi_storage_set('options', array(
		
			// Section 'Title & Tagline' - add theme options in the standard WP section
			'title_tagline' => array(
				"title" => esc_html__('Title, Tagline & Site icon', 'grab-taxi'),
				"desc" => wp_kses_data( __('Specify site title and tagline (if need) and upload the site icon', 'grab-taxi') ),
				"type" => "section"
				),
		
		
			// Section 'Header' - add theme options in the standard WP section
			'header_image' => array(
				"title" => esc_html__('Header', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select or upload logo images, select header type and widgets set for the header', 'grab-taxi') )
							. '<br>'
							. wp_kses_data( $msg_override ),
				"type" => "section"
				),
			'header_image_override' => array(
				"title" => esc_html__('Header image override', 'grab-taxi'),
				"desc" => wp_kses_data( __("Allow override the header image with the page's/post's/product's/etc. featured image", 'grab-taxi') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'grab-taxi')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'header_style' => array(
				"title" => esc_html__('Header style', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select style to display the site header', 'grab-taxi') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'grab-taxi')
				),
				"std" => 'header-default',
				"options" => array(),
				"type" => "select"
				),
			'header_position' => array(
				"title" => esc_html__('Header position', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select position to display the site header', 'grab-taxi') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'grab-taxi')
				),
				"std" => 'default',
				"options" => array(),
				"type" => "select"
				),
			'header_widgets' => array(
				"title" => esc_html__('Header widgets', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the header on each page', 'grab-taxi') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'grab-taxi'),
					"desc" => wp_kses_data( __('Select set of widgets to show in the header on this page', 'grab-taxi') ),
				),
				"std" => 'hide',
				"options" => array(),
				"type" => "select"
				),
			'header_columns' => array(
				"title" => esc_html__('Header columns', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select number columns to show widgets in the Header. If 0 - autodetect by the widgets count', 'grab-taxi') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'grab-taxi')
				),
				"dependency" => array(
					'header_style' => array('header-default'),
					'header_widgets' => array('^hide')
				),
				"std" => 0,
				"options" => grab_taxi_get_list_range(0,6),
				"type" => "select"
				),
			'header_scheme' => array(
				"title" => esc_html__('Header Color Scheme', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select color scheme to decorate header area', 'grab-taxi') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'grab-taxi')
				),
				"std" => 'dark',
				"options" => array(),
				"refresh" => false,
				"type" => "select"
				),
			'header_fullheight' => array(
				"title" => esc_html__('Header fullheight', 'grab-taxi'),
				"desc" => wp_kses_data( __("Enlarge header area to fill whole screen. Used only if header have a background image", 'grab-taxi') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'grab-taxi')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'header_wide' => array(
				"title" => esc_html__('Header fullwide', 'grab-taxi'),
				"desc" => wp_kses_data( __('Do you want to stretch the header widgets area to the entire window width?', 'grab-taxi') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'grab-taxi')
				),
				"dependency" => array(
					'header_style' => array('header-default')
				),
				"std" => 1,
				"type" => "checkbox"
				),

			'menu_info' => array(
				"title" => esc_html__('Menu settings', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select main menu style, position, color scheme and other parameters', 'grab-taxi') ),
				"type" => "info"
				),
			'menu_style' => array(
				"title" => esc_html__('Menu position', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select position of the main menu', 'grab-taxi') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'grab-taxi')
				),
				"std" => 'top',
				"options" => array(
					'top'	=> esc_html__('Top',	'grab-taxi'),
					'left'	=> esc_html__('Left',	'grab-taxi'),
					'right'	=> esc_html__('Right',	'grab-taxi')
				),
				"type" => "hidden" //switch
				),
			'menu_scheme' => array(
				"title" => esc_html__('Menu Color Scheme', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select color scheme to decorate main menu area', 'grab-taxi') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'grab-taxi')
				),
				"std" => 'inherit',
				"options" => array(),
				"refresh" => false,
				"type" => "select"
				),
			'menu_side_stretch' => array(
				"title" => esc_html__('Stretch sidemenu', 'grab-taxi'),
				"desc" => wp_kses_data( __('Stretch sidemenu to window height (if menu items number >= 5)', 'grab-taxi') ),
				"dependency" => array(
					'menu_style' => array('left', 'right')
				),
				"std" => 1,
				"type" => "checkbox"
				),
			'menu_side_icons' => array(
				"title" => esc_html__('Iconed sidemenu', 'grab-taxi'),
				"desc" => wp_kses_data( __('Get icons from anchors and display it in the sidemenu or mark sidemenu items with simple dots', 'grab-taxi') ),
				"dependency" => array(
					'menu_style' => array('left', 'right')
				),
				"std" => 1,
				"type" => "checkbox"
				),
			'menu_mobile_fullscreen' => array(
				"title" => esc_html__('Mobile menu fullscreen', 'grab-taxi'),
				"desc" => wp_kses_data( __('Display mobile and side menus on full screen (if checked) or slide narrow menu from the left or from the right side (if not checked)', 'grab-taxi') ),
				"dependency" => array(
					'menu_style' => array('left', 'right')
				),
				"std" => 1,
				"type" => "checkbox"
				),
			'logo_info' => array(
				"title" => esc_html__('Logo settings', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select logo images for the normal and Retina displays', 'grab-taxi') ),
				"type" => "info"
				),
			'logo' => array(
				"title" => esc_html__('Logo', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select or upload site logo', 'grab-taxi') ),
				"std" => '',
				"type" => "image"
				),
			'logo_retina' => array(
				"title" => esc_html__('Logo for Retina', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'grab-taxi') ),
				"std" => '',
				"type" => "image"
				),
			'logo_inverse' => array(
				"title" => esc_html__('Logo inverse', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select or upload site logo to display it on the dark background', 'grab-taxi') ),
				"std" => '',
				"type" => "image"
				),
			'logo_inverse_retina' => array(
				"title" => esc_html__('Logo inverse for Retina', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'grab-taxi') ),
				"std" => '',
				"type" => "image"
				),
			'logo_side' => array(
				"title" => esc_html__('Logo side', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select or upload site logo (with vertical orientation) to display it in the side menu', 'grab-taxi') ),
				"std" => '',
				"type" => "image"
				),
			'logo_side_retina' => array(
				"title" => esc_html__('Logo side for Retina', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select or upload site logo (with vertical orientation) to display it in the side menu on Retina displays (if empty - use default logo from the field above)', 'grab-taxi') ),
				"std" => '',
				"type" => "image"
				),
			'logo_text' => array(
				"title" => esc_html__('Logo from Site name', 'grab-taxi'),
				"desc" => wp_kses_data( __('Do you want use Site name and description as Logo if images above are not selected?', 'grab-taxi') ),
				"std" => 1,
				"type" => "checkbox"
				),
			'author_phone' => array(
				"title" => esc_html__('Phone', 'grab-taxi'),
				"desc" => wp_kses_data( __("Display your phone. Default header only.", 'grab-taxi') ),
				"std" => esc_html__('123-456-7890', 'grab-taxi'),
				"refresh" => false,
				"type" => "textarea"
			),
		
		
			// Section 'Content'
			'content' => array(
				"title" => esc_html__('Content', 'grab-taxi'),
				"desc" => wp_kses_data( __('Options of the content area.', 'grab-taxi') )
							. '<br>'
							. wp_kses_data( $msg_override ),
				"type" => "section",
				),
			'color_scheme' => array(
				"title" => esc_html__('Site Color Scheme', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select color scheme to decorate whole site. Attention! Case "Inherit" can be used only for custom pages, not for root site content in the Appearance - Customize', 'grab-taxi') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'grab-taxi')
				),
				"std" => 'default',
				"options" => array(),
				"refresh" => false,
				"type" => "select"
				),
			'body_style' => array(
				"title" => esc_html__('Body style', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select width of the body content', 'grab-taxi') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'grab-taxi')
				),
				"refresh" => false,
				"std" => 'wide',
				"options" => array(
					'boxed'		=> esc_html__('Boxed',		'grab-taxi'),
					'wide'		=> esc_html__('Wide',		'grab-taxi'),
					'fullwide'	=> esc_html__('Fullwide',	'grab-taxi'),
					'fullscreen'=> esc_html__('Fullscreen',	'grab-taxi')
				),
				"type" => "select"
				),
			'boxed_bg_image' => array(
				"title" => esc_html__('Boxed bg image', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select or upload image, used as background in the boxed body', 'grab-taxi') ),
				"dependency" => array(
					'body_style' => array('boxed')
				),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'grab-taxi')
				),
				"std" => '',
				"type" => "image"
				),
			'expand_content' => array(
				"title" => esc_html__('Expand content', 'grab-taxi'),
				"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden', 'grab-taxi') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Content', 'grab-taxi')
				),
				"refresh" => false,
				"std" => 1,
				"type" => "checkbox"
				),
			'remove_margins' => array(
				"title" => esc_html__('Remove margins', 'grab-taxi'),
				"desc" => wp_kses_data( __('Remove margins above and below the content area', 'grab-taxi') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Content', 'grab-taxi')
				),
				"refresh" => false,
				"std" => 0,
				"type" => "checkbox"
				),
			'border_radius' => array(
				"title" => esc_html__('Border radius', 'grab-taxi'),
				"desc" => wp_kses_data( __('Specify the border radius of the form fields and buttons in pixels or other valid CSS units', 'grab-taxi') ),
				"std" => 0,
				"type" => "hidden" //text
				),
			'no_image' => array(
				"title" => esc_html__('No image placeholder', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select or upload image, used as placeholder for the posts without featured image', 'grab-taxi') ),
				"std" => '',
				"type" => "image"
				),
			'seo_snippets' => array(
				"title" => esc_html__('SEO snippets', 'grab-taxi'),
				"desc" => wp_kses_data( __('Add structured data markup to the single posts and pages', 'grab-taxi') ),
				"std" => 0,
				"type" => "checkbox"
				),
            'privacy_text' => array(
                "title" => esc_html__("Text with Privacy Policy link", 'grab-taxi'),
                "desc"  => wp_kses_data( __("Specify text with Privacy Policy link for the checkbox 'I agree ...'", 'grab-taxi') ),
                "std"   => wp_kses( __( 'I agree that my submitted data is being collected and stored.', 'grab-taxi'), 'grab_taxi_kses_content' ),
                "type"  => "text"
            ),
			'author_info' => array(
				"title" => esc_html__('Author info', 'grab-taxi'),
				"desc" => wp_kses_data( __("Display block with information about post's author", 'grab-taxi') ),
				"std" => 1,
				"type" => "checkbox"
				),

			'related_posts' => array(
				"title" => esc_html__('Related posts', 'grab-taxi'),
				"desc" => wp_kses_data( __('How many related posts should be displayed in the single post? If 0 - no related posts showed.', 'grab-taxi') ),
				"std" => 0,
				"options" => grab_taxi_get_list_range(0,9),
				"type" => "hidden" //select
				),
			'related_columns' => array(
				"title" => esc_html__('Related columns', 'grab-taxi'),
				"desc" => wp_kses_data( __('How many columns should be used to output related posts in the single page (from 2 to 4)?', 'grab-taxi') ),
				"std" => 2,
				"options" => grab_taxi_get_list_range(1,4),
				"type" => "hidden" //select
				),
			'related_style' => array(
				"title" => esc_html__('Related posts style', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select style of the related posts output', 'grab-taxi') ),
				"std" => 2,
				"options" => grab_taxi_get_list_styles(1,2),
				"type" => "hidden" //select
				),
			
		
		
			// Section 'Content'
			'sidebar' => array(
				"title" => esc_html__('Sidebar', 'grab-taxi'),
				"desc" => wp_kses_data( __('Options of the sidebar area.', 'grab-taxi') )
							. '<br>'
							. wp_kses_data( $msg_override ),
				"type" => "section",
				),
			'sidebar_widgets' => array(
				"title" => esc_html__('Sidebar widgets', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select default widgets to show in the sidebar', 'grab-taxi') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'grab-taxi')
				),
				"std" => 'sidebar_widgets',
				"options" => array(),
				"type" => "select"
				),
			'sidebar_scheme' => array(
				"title" => esc_html__('Sidebar Color Scheme', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select color scheme to decorate sidebar', 'grab-taxi') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'grab-taxi')
				),
				"std" => 'dark',
				"options" => array(),
				"refresh" => false,
				"type" => "select"
				),
			'sidebar_position' => array(
				"title" => esc_html__('Sidebar position', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select position to show sidebar', 'grab-taxi') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'grab-taxi')
				),
				"refresh" => false,
				"std" => 'left',
				"options" => array(),
				"type" => "select"
				),
			'hide_sidebar_on_single' => array(
				"title" => esc_html__('Hide sidebar on the single post', 'grab-taxi'),
				"desc" => wp_kses_data( __("Hide sidebar on the single post's pages", 'grab-taxi') ),
				"std" => 0,
				"type" => "checkbox"
				),
			'widgets_above_page' => array(
				"title" => esc_html__('Widgets at the top of the page', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select widgets to show at the top of the page (above content and sidebar)', 'grab-taxi') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Widgets', 'grab-taxi')
				),
				"std" => 'hide',
				"options" => array(),
				"type" => "select"
				),
			'widgets_above_content' => array(
				"title" => esc_html__('Widgets above the content', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'grab-taxi') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Widgets', 'grab-taxi')
				),
				"std" => 'hide',
				"options" => array(),
				"type" => "select"
				),
			'widgets_below_content' => array(
				"title" => esc_html__('Widgets below the content', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'grab-taxi') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Widgets', 'grab-taxi')
				),
				"std" => 'hide',
				"options" => array(),
				"type" => "select"
				),
			'widgets_below_page' => array(
				"title" => esc_html__('Widgets at the bottom of the page', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select widgets to show at the bottom of the page (below content and sidebar)', 'grab-taxi') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Widgets', 'grab-taxi')
				),
				"std" => 'hide',
				"options" => array(),
				"type" => "select"
				),
		
		
		
			// Section 'Footer'
			'footer' => array(
				"title" => esc_html__('Footer', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select set of widgets and columns number in the site footer', 'grab-taxi') )
							. '<br>'
							. wp_kses_data( $msg_override ),
				"type" => "section"
				),
			'footer_style' => array(
				"title" => esc_html__('Footer style', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select style to display the site footer', 'grab-taxi') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Footer', 'grab-taxi')
				),
				"std" => 'footer-default',
				"options" => array(),
				"type" => "select"
				),
			'footer_scheme' => array(
				"title" => esc_html__('Footer Color Scheme', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select color scheme to decorate footer area', 'grab-taxi') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'grab-taxi')
				),
				"std" => 'dark',
				"options" => array(),
				"refresh" => false,
				"type" => "select"
				),
			'footer_widgets' => array(
				"title" => esc_html__('Footer widgets', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the footer', 'grab-taxi') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'grab-taxi')
				),
				"dependency" => array(
					'footer_style' => array('footer-default')
				),
				"std" => 'footer_widgets',
				"options" => array(),
				"type" => "select"
				),
			'footer_columns' => array(
				"title" => esc_html__('Footer columns', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select number columns to show widgets in the footer. If 0 - autodetect by the widgets count', 'grab-taxi') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'grab-taxi')
				),
				"dependency" => array(
					'footer_style' => array('footer-default'),
					'footer_widgets' => array('^hide')
				),
				"std" => 0,
				"options" => grab_taxi_get_list_range(0,6),
				"type" => "select"
				),
			'footer_wide' => array(
				"title" => esc_html__('Footer fullwide', 'grab-taxi'),
				"desc" => wp_kses_data( __('Do you want to stretch the footer to the entire window width?', 'grab-taxi') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'grab-taxi')
				),
				"dependency" => array(
					'footer_style' => array('footer-default')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'logo_in_footer' => array(
				"title" => esc_html__('Show logo', 'grab-taxi'),
				"desc" => wp_kses_data( __('Show logo in the footer', 'grab-taxi') ),
				'refresh' => false,
				"dependency" => array(
					'footer_style' => array('footer-default')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'logo_footer' => array(
				"title" => esc_html__('Logo for footer', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select or upload site logo to display it in the footer', 'grab-taxi') ),
				"dependency" => array(
					'footer_style' => array('footer-default'),
					'logo_in_footer' => array('1')
				),
				"std" => '',
				"type" => "image"
				),
			'logo_footer_retina' => array(
				"title" => esc_html__('Logo for footer (Retina)', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select or upload logo for the footer area used on Retina displays (if empty - use default logo from the field above)', 'grab-taxi') ),
				"dependency" => array(
					'footer_style' => array('footer-default'),
					'logo_in_footer' => array('1')
				),
				"std" => '',
				"type" => "image"
				),
			'socials_in_footer' => array(
				"title" => esc_html__('Show social icons', 'grab-taxi'),
				"desc" => wp_kses_data( __('Show social icons in the footer (under logo or footer widgets)', 'grab-taxi') ),
				"dependency" => array(
					'footer_style' => array('footer-default')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'copyright' => array(
				"title" => esc_html__('Copyright', 'grab-taxi'),
				"desc" => wp_kses_data( __('Copyright text in the footer. Use {Y} to insert current year and press "Enter" to create a new line', 'grab-taxi') ),
				"std" => esc_html__('AxiomThemes &copy; {Y}. All rights reserved.', 'grab-taxi'),
				"dependency" => array(
					'footer_style' => array('footer-default')
				),
				"refresh" => false,
				"type" => "textarea"
				),
		
		
		
			// Section 'Homepage' - settings for home page
			'homepage' => array(
				"title" => esc_html__('Homepage', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select blog style and widgets to display on the homepage', 'grab-taxi') ),
				"type" => "section"
				),
			'expand_content_home' => array(
				"title" => esc_html__('Expand content', 'grab-taxi'),
				"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden on the Homepage', 'grab-taxi') ),
				"refresh" => false,
				"std" => 1,
				"type" => "checkbox"
				),
			'blog_style_home' => array(
				"title" => esc_html__('Blog style', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select posts style for the homepage', 'grab-taxi') ),
				"std" => 'excerpt',
				"options" => array(),
				"type" => "select"
				),
			'first_post_large_home' => array(
				"title" => esc_html__('First post large', 'grab-taxi'),
				"desc" => wp_kses_data( __('Make first post large (with Excerpt layout) on the Classic layout of the Homepage', 'grab-taxi') ),
				"dependency" => array(
					'blog_style_home' => array('classic')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'header_style_home' => array(
				"title" => esc_html__('Header style', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select style to display the site header on the homepage', 'grab-taxi') ),
				"std" => 'inherit',
				"options" => array(),
				"type" => "select"
				),
			'header_position_home' => array(
				"title" => esc_html__('Header position', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select position to display the site header on the homepage', 'grab-taxi') ),
				"std" => 'inherit',
				"options" => array(),
				"type" => "select"
				),
			'header_widgets_home' => array(
				"title" => esc_html__('Header widgets', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the header on the homepage', 'grab-taxi') ),
				"std" => 'hide',
				"options" => array(),
				"type" => "select"
				),
			'sidebar_widgets_home' => array(
				"title" => esc_html__('Sidebar widgets', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select sidebar to show on the homepage', 'grab-taxi') ),
				"std" => 'inherit',
				"options" => array(),
				"type" => "select"
				),
			'sidebar_position_home' => array(
				"title" => esc_html__('Sidebar position', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select position to show sidebar on the homepage', 'grab-taxi') ),
				"refresh" => false,
				"std" => 'inherit',
				"options" => array(),
				"type" => "select"
				),
			'widgets_above_page_home' => array(
				"title" => esc_html__('Widgets above the page', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select widgets to show above page (content and sidebar)', 'grab-taxi') ),
				"std" => 'hide',
				"options" => array(),
				"type" => "select"
				),
			'widgets_above_content_home' => array(
				"title" => esc_html__('Widgets above the content', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'grab-taxi') ),
				"std" => 'hide',
				"options" => array(),
				"type" => "select"
				),
			'widgets_below_content_home' => array(
				"title" => esc_html__('Widgets below the content', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'grab-taxi') ),
				"std" => 'hide',
				"options" => array(),
				"type" => "select"
				),
			'widgets_below_page_home' => array(
				"title" => esc_html__('Widgets below the page', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select widgets to show below the page (content and sidebar)', 'grab-taxi') ),
				"std" => 'hide',
				"options" => array(),
				"type" => "select"
				),
			
		
		
			// Section 'Blog archive'
			'blog' => array(
				"title" => esc_html__('Blog archive', 'grab-taxi'),
				"desc" => wp_kses_data( __('Options for the blog archive', 'grab-taxi') ),
				"type" => "section",
				),
			'expand_content_blog' => array(
				"title" => esc_html__('Expand content', 'grab-taxi'),
				"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden on the blog archive', 'grab-taxi') ),
				"refresh" => false,
				"std" => 1,
				"type" => "checkbox"
				),
			'blog_style' => array(
				"title" => esc_html__('Blog style', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select posts style for the blog archive', 'grab-taxi') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'grab-taxi')
				),
				"dependency" => array(
                    '#page_template' => array( 'blog.php' ),
                    '.editor-page-attributes__template select' => array( 'blog.php' ),
				),
				"std" => 'excerpt',
				"options" => array(),
				"type" => "select"
				),
			'blog_columns' => array(
				"title" => esc_html__('Blog columns', 'grab-taxi'),
				"desc" => wp_kses_data( __('How many columns should be used in the blog archive (from 2 to 4)?', 'grab-taxi') ),
				"std" => 2,
				"options" => grab_taxi_get_list_range(2,4),
				"type" => "hidden"
				),
			'post_type' => array(
				"title" => esc_html__('Post type', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select post type to show in the blog archive', 'grab-taxi') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'grab-taxi')
				),
				"dependency" => array(
                    '#page_template' => array( 'blog.php' ),
                    '.editor-page-attributes__template select' => array( 'blog.php' ),
				),
				"linked" => 'parent_cat',
				"refresh" => false,
				"hidden" => true,
				"std" => 'post',
				"options" => array(),
				"type" => "select"
				),
			'parent_cat' => array(
				"title" => esc_html__('Category to show', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select category to show in the blog archive', 'grab-taxi') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'grab-taxi')
				),
				"dependency" => array(
                    '#page_template' => array( 'blog.php' ),
                    '.editor-page-attributes__template select' => array( 'blog.php' ),
				),
				"refresh" => false,
				"hidden" => true,
				"std" => '0',
				"options" => array(),
				"type" => "select"
				),
			'posts_per_page' => array(
				"title" => esc_html__('Posts per page', 'grab-taxi'),
				"desc" => wp_kses_data( __('How many posts will be displayed on this page', 'grab-taxi') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'grab-taxi')
				),
				"dependency" => array(
                    '#page_template' => array( 'blog.php' ),
                    '.editor-page-attributes__template select' => array( 'blog.php' ),
				),
				"hidden" => true,
				"std" => '',
				"type" => "text"
				),
			"blog_pagination" => array(
				"title" => esc_html__('Pagination style', 'grab-taxi'),
				"desc" => wp_kses_data( __('Show Older/Newest posts or Page numbers below the posts list', 'grab-taxi') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'grab-taxi')
				),
				"std" => "pages",
				"options" => array(
					'pages'	=> esc_html__("Page numbers", 'grab-taxi'),
					'links'	=> esc_html__("Older/Newest", 'grab-taxi'),
					'more'	=> esc_html__("Load more", 'grab-taxi'),
					'infinite' => esc_html__("Infinite scroll", 'grab-taxi')
				),
				"type" => "hidden" //select
				),
			'show_filters' => array(
				"title" => esc_html__('Show filters', 'grab-taxi'),
				"desc" => wp_kses_data( __('Show categories as tabs to filter posts', 'grab-taxi') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'grab-taxi')
				),
				"dependency" => array(
                    '#page_template' => array( 'blog.php' ),
                    '.editor-page-attributes__template select' => array( 'blog.php' ),
					'blog_style' => array('portfolio', 'gallery')
				),
				"hidden" => true,
				"std" => 0,
				"type" => "checkbox"
				),
			'first_post_large' => array(
				"title" => esc_html__('First post large', 'grab-taxi'),
				"desc" => wp_kses_data( __('Make first post large (with Excerpt layout) on the Classic layout of blog archive', 'grab-taxi') ),
				"dependency" => array(
					'blog_style' => array('classic')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			"blog_content" => array( 
				"title" => esc_html__('Posts content', 'grab-taxi'),
				"desc" => wp_kses_data( __("Show full post's content in the blog or only post's excerpt", 'grab-taxi') ),
				"std" => "excerpt",
				"options" => array(
					'excerpt'	=> esc_html__('Excerpt',	'grab-taxi'),
					'fullpost'	=> esc_html__('Full post',	'grab-taxi')
				),
				"type" => "select"
				),
			'time_diff_before' => array(
				"title" => esc_html__('Time difference', 'grab-taxi'),
				"desc" => wp_kses_data( __("How many days show time difference instead post's date", 'grab-taxi') ),
				"std" => 5,
				"type" => "text"
				),
			'sticky_style' => array(
				"title" => esc_html__('Sticky posts style', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select style of the sticky posts output', 'grab-taxi') ),
				"std" => 'inherit',
				"options" => array(
					'inherit' => esc_html__('Decorated posts', 'grab-taxi'),
					'columns' => esc_html__('Mini-cards',	'grab-taxi')
				),
				"type" => "select"
				),
			"blog_animation" => array( 
				"title" => esc_html__('Animation for the posts', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select animation to show posts in the blog. Attention! Do not use any animation on pages with the "wheel to the anchor" behaviour (like a "Chess 2 columns")!', 'grab-taxi') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'grab-taxi')
				),
				"dependency" => array(
                    '#page_template' => array( 'blog.php' ),
                    '.editor-page-attributes__template select' => array( 'blog.php' ),
				),
				"std" => "none",
				"options" => array(),
				"type" => "select"
				),
			'header_style_blog' => array(
				"title" => esc_html__('Header style', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select style to display the site header on the blog archive', 'grab-taxi') ),
				"std" => 'inherit',
				"options" => array(),
				"type" => "select"
				),
			'header_position_blog' => array(
				"title" => esc_html__('Header position', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select position to display the site header on the blog archive', 'grab-taxi') ),
				"std" => 'inherit',
				"options" => array(),
				"type" => "select"
				),
			'header_widgets_blog' => array(
				"title" => esc_html__('Header widgets', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the header on the blog archive', 'grab-taxi') ),
				"std" => 'inherit',
				"options" => array(),
				"type" => "select"
				),
			'sidebar_widgets_blog' => array(
				"title" => esc_html__('Sidebar widgets', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select sidebar to show on the blog archive', 'grab-taxi') ),
				"std" => 'inherit',
				"options" => array(),
				"type" => "select"
				),
			'sidebar_position_blog' => array(
				"title" => esc_html__('Sidebar position', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select position to show sidebar on the blog archive', 'grab-taxi') ),
				"refresh" => false,
				"std" => 'left',
				"options" => array(),
				"type" => "select"
				),
			'hide_sidebar_on_single_blog' => array(
				"title" => esc_html__('Hide sidebar on the single post', 'grab-taxi'),
				"desc" => wp_kses_data( __("Hide sidebar on the single post", 'grab-taxi') ),
				"std" => 0,
				"type" => "checkbox"
				),
			'widgets_above_page_blog' => array(
				"title" => esc_html__('Widgets above the page', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select widgets to show above page (content and sidebar)', 'grab-taxi') ),
				"std" => 'inherit',
				"options" => array(),
				"type" => "select"
				),
			'widgets_above_content_blog' => array(
				"title" => esc_html__('Widgets above the content', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'grab-taxi') ),
				"std" => 'inherit',
				"options" => array(),
				"type" => "select"
				),
			'widgets_below_content_blog' => array(
				"title" => esc_html__('Widgets below the content', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'grab-taxi') ),
				"std" => 'inherit',
				"options" => array(),
				"type" => "select"
				),
			'widgets_below_page_blog' => array(
				"title" => esc_html__('Widgets below the page', 'grab-taxi'),
				"desc" => wp_kses_data( __('Select widgets to show below the page (content and sidebar)', 'grab-taxi') ),
				"std" => 'inherit',
				"options" => array(),
				"type" => "select"
				),
			
		
		
			// Section 'Colors' - choose color scheme and customize separate colors from it
			'scheme' => array(
				"title" => esc_html__('* Color scheme editor', 'grab-taxi'),
				"desc" => esc_html__("Modify colors and preview changes on your site", 'grab-taxi'),
				"priority" => 1000,
				"type" => "section"
				),
		
			'scheme_storage' => array(
				"title" => esc_html__('Color schemes', 'grab-taxi'),
				"desc" => esc_html__('Select color scheme to modify. Attention! Only those sections will be changed which this scheme was assigned to', 'grab-taxi'),
				"std" => '$grab_taxi_get_scheme_storage',
				"refresh" => false,
				"type" => "scheme_editor"
				),


			// Section 'Hidden'
			'media_title' => array(
				"title" => esc_html__('Media title', 'grab-taxi'),
				"desc" => wp_kses_data( __('Used as title for the audio and video item in this post', 'grab-taxi') ),
				"override" => array(
					'mode' => 'post',
					'section' => esc_html__('Title', 'grab-taxi')
				),
				"hidden" => true,
				"std" => '',
				"type" => "text"
				),
			'media_author' => array(
				"title" => esc_html__('Media author', 'grab-taxi'),
				"desc" => wp_kses_data( __('Used as author name for the audio and video item in this post', 'grab-taxi') ),
				"override" => array(
					'mode' => 'post',
					'section' => esc_html__('Title', 'grab-taxi')
				),
				"hidden" => true,
				"std" => '',
				"type" => "text"
				),


			// Internal options.
			// Attention! Don't change any options in the section below!
			'reset_options' => array(
				"title" => '',
				"desc" => '',
				"std" => '0',
				"type" => "hidden",
				),

		));


		// Prepare panel 'Fonts'
		$fonts = array(
		
			// Panel 'Fonts' - manage fonts loading and set parameters of the base theme elements
			'fonts' => array(
				"title" => esc_html__('* Fonts settings', 'grab-taxi'),
				"desc" => '',
				"priority" => 1500,
				"type" => "panel"
				),

			// Section 'Load_fonts'
			'load_fonts' => array(
				"title" => esc_html__('Load fonts', 'grab-taxi'),
				"desc" => wp_kses_data( __('Specify fonts to load when theme start. You can use them in the base theme elements: headers, text, menu, links, input fields, etc.', 'grab-taxi') )
						. '<br>'
						. wp_kses_data( __('<b>Attention!</b> Press "Refresh" button to reload preview area after the all fonts are changed', 'grab-taxi') ),
				"type" => "section"
				),
			'load_fonts_subset' => array(
				"title" => esc_html__('Google fonts subsets', 'grab-taxi'),
				"desc" => wp_kses_data( __('Specify comma separated list of the subsets which will be load from Google fonts', 'grab-taxi') )
						. '<br>'
						. wp_kses_data( __('Available subsets are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese', 'grab-taxi') ),
				"refresh" => false,
				"std" => '$grab_taxi_get_load_fonts_subset',
				"type" => "text"
				)
		);

		for ($i=1; $i<=grab_taxi_get_theme_setting('max_load_fonts'); $i++) {
			$fonts["load_fonts-{$i}-info"] = array(
				"title" => esc_html(sprintf(__('Font %s', 'grab-taxi'), $i)),
				"desc" => '',
				"type" => "info",
				);
			$fonts["load_fonts-{$i}-name"] = array(
				"title" => esc_html__('Font name', 'grab-taxi'),
				"desc" => '',
				"refresh" => false,
				"std" => '$grab_taxi_get_load_fonts_option',
				"type" => "text"
				);
			$fonts["load_fonts-{$i}-family"] = array(
				"title" => esc_html__('Font family', 'grab-taxi'),
				"desc" => $i==1 
							? wp_kses_data( __('Select font family to use it if font above is not available', 'grab-taxi') )
							: '',
				"refresh" => false,
				"std" => '$grab_taxi_get_load_fonts_option',
				"options" => array(
					'inherit' => esc_html__("Inherit", 'grab-taxi'),
					'serif' => esc_html__('serif', 'grab-taxi'),
					'sans-serif' => esc_html__('sans-serif', 'grab-taxi'),
					'monospace' => esc_html__('monospace', 'grab-taxi'),
					'cursive' => esc_html__('cursive', 'grab-taxi'),
					'fantasy' => esc_html__('fantasy', 'grab-taxi')
				),
				"type" => "select"
				);
			$fonts["load_fonts-{$i}-styles"] = array(
				"title" => esc_html__('Font styles', 'grab-taxi'),
				"desc" => $i==1 
							? wp_kses_data( __('Font styles used only for the Google fonts. This is a comma separated list of the font weight and styles. For example: 400,400italic,700', 'grab-taxi') )
											. '<br>'
								. wp_kses_data( __('<b>Attention!</b> Each weight and style increase download size! Specify only used weights and styles.', 'grab-taxi') )
							: '',
				"refresh" => false,
				"std" => '$grab_taxi_get_load_fonts_option',
				"type" => "text"
				);
		}
		$fonts['load_fonts_end'] = array(
			"type" => "section_end"
			);

		// Sections with font's attributes for each theme element
		$theme_fonts = grab_taxi_get_theme_fonts();
		foreach ($theme_fonts as $tag=>$v) {
			$fonts["{$tag}_section"] = array(
				"title" => !empty($v['title']) 
								? $v['title'] 
								: esc_html(sprintf(__('%s settings', 'grab-taxi'), $tag)),
				"desc" => !empty($v['description']) 
								? $v['description'] 
								: wp_kses( sprintf(__('Font settings of the "%s" tag.', 'grab-taxi'), $tag), 'grab_taxi_kses_content' ),
				"type" => "section",
				);
	
			foreach ($v as $css_prop=>$css_value) {
				if (in_array($css_prop, array('title', 'description'))) continue;
				$options = '';
				$type = 'text';
				$title = ucfirst(str_replace('-', ' ', $css_prop));
				if ($css_prop == 'font-family') {
					$type = 'select';
					$options = array();
				} else if ($css_prop == 'font-weight') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'grab-taxi'),
						'100' => esc_html__('100 (Light)', 'grab-taxi'), 
						'200' => esc_html__('200 (Light)', 'grab-taxi'), 
						'300' => esc_html__('300 (Thin)',  'grab-taxi'),
						'400' => esc_html__('400 (Normal)', 'grab-taxi'),
						'500' => esc_html__('500 (Semibold)', 'grab-taxi'),
						'600' => esc_html__('600 (Semibold)', 'grab-taxi'),
						'700' => esc_html__('700 (Bold)', 'grab-taxi'),
						'800' => esc_html__('800 (Black)', 'grab-taxi'),
						'900' => esc_html__('900 (Black)', 'grab-taxi')
					);
				} else if ($css_prop == 'font-style') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'grab-taxi'),
						'normal' => esc_html__('Normal', 'grab-taxi'), 
						'italic' => esc_html__('Italic', 'grab-taxi')
					);
				} else if ($css_prop == 'text-decoration') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'grab-taxi'),
						'none' => esc_html__('None', 'grab-taxi'), 
						'underline' => esc_html__('Underline', 'grab-taxi'),
						'overline' => esc_html__('Overline', 'grab-taxi'),
						'line-through' => esc_html__('Line-through', 'grab-taxi')
					);
				} else if ($css_prop == 'text-transform') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'grab-taxi'),
						'none' => esc_html__('None', 'grab-taxi'), 
						'uppercase' => esc_html__('Uppercase', 'grab-taxi'),
						'lowercase' => esc_html__('Lowercase', 'grab-taxi'),
						'capitalize' => esc_html__('Capitalize', 'grab-taxi')
					);
				}
				$fonts["{$tag}_{$css_prop}"] = array(
					"title" => $title,
					"desc" => '',
					"refresh" => false,
					"std" => '$grab_taxi_get_theme_fonts_option',
					"options" => $options,
					"type" => $type
				);
			}
			
			$fonts["{$tag}_section_end"] = array(
				"type" => "section_end"
				);
		}

		$fonts['fonts_end'] = array(
			"type" => "panel_end"
			);

		// Add fonts parameters into Theme Options
		grab_taxi_storage_merge_array('options', '', $fonts);

		// Add Header Video if WP version < 4.7
		if (!function_exists('get_header_video_url')) {
			grab_taxi_storage_set_array_after('options', 'header_image_override', 'header_video', array(
				"title" => esc_html__('Header video', 'grab-taxi'),
				"desc" => wp_kses_data( __("Select video to use it as background for the header", 'grab-taxi') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'grab-taxi')
				),
				"std" => '',
				"type" => "video"
				)
			);
		}
	}
}


// Return lists with choises when its need in the admin mode
if (!function_exists('grab_taxi_options_get_list_choises')) {
	add_filter('grab_taxi_filter_options_get_list_choises', 'grab_taxi_options_get_list_choises', 10, 2);
	function grab_taxi_options_get_list_choises($list, $id) {
		if (is_array($list) && count($list)==0) {
			if (strpos($id, 'header_style')===0)
				$list = grab_taxi_get_list_header_styles(strpos($id, 'header_style_')===0);
			else if (strpos($id, 'header_position')===0)
				$list = grab_taxi_get_list_header_positions(strpos($id, 'header_position_')===0);
			else if (strpos($id, 'header_widgets')===0)
				$list = grab_taxi_get_list_sidebars(strpos($id, 'header_widgets_')===0, true);
			else if (strpos($id, 'header_scheme')===0 
					|| strpos($id, 'menu_scheme')===0
					|| strpos($id, 'color_scheme')===0
					|| strpos($id, 'sidebar_scheme')===0
					|| strpos($id, 'footer_scheme')===0)
				$list = grab_taxi_get_list_schemes($id!='color_scheme');
			else if (strpos($id, 'sidebar_widgets')===0)
				$list = grab_taxi_get_list_sidebars(strpos($id, 'sidebar_widgets_')===0, true);
			else if (strpos($id, 'sidebar_position')===0)
				$list = grab_taxi_get_list_sidebars_positions(strpos($id, 'sidebar_position_')===0);
			else if (strpos($id, 'widgets_above_page')===0)
				$list = grab_taxi_get_list_sidebars(strpos($id, 'widgets_above_page_')===0, true);
			else if (strpos($id, 'widgets_above_content')===0)
				$list = grab_taxi_get_list_sidebars(strpos($id, 'widgets_above_content_')===0, true);
			else if (strpos($id, 'widgets_below_page')===0)
				$list = grab_taxi_get_list_sidebars(strpos($id, 'widgets_below_page_')===0, true);
			else if (strpos($id, 'widgets_below_content')===0)
				$list = grab_taxi_get_list_sidebars(strpos($id, 'widgets_below_content_')===0, true);
			else if (strpos($id, 'footer_style')===0)
				$list = grab_taxi_get_list_footer_styles(strpos($id, 'footer_style_')===0);
			else if (strpos($id, 'footer_widgets')===0)
				$list = grab_taxi_get_list_sidebars(strpos($id, 'footer_widgets_')===0, true);
			else if (strpos($id, 'blog_style')===0)
				$list = grab_taxi_get_list_blog_styles(strpos($id, 'blog_style_')===0);
			else if (strpos($id, 'post_type')===0)
				$list = grab_taxi_get_list_posts_types();
			else if (strpos($id, 'parent_cat')===0)
				$list = grab_taxi_array_merge(array(0 => esc_html__('- Select category -', 'grab-taxi')), grab_taxi_get_list_categories());
			else if (strpos($id, 'blog_animation')===0)
				$list = grab_taxi_get_list_animations_in();
			else if ($id == 'color_scheme_editor')
				$list = grab_taxi_get_list_schemes();
			else if (strpos($id, '_font-family') > 0)
				$list = grab_taxi_get_list_load_fonts(true);
		}
		return $list;
	}
}




// -----------------------------------------------------------------
// -- Create and manage Theme Options
// -----------------------------------------------------------------

// Theme init priorities:
// 2 - create Theme Options
if (!function_exists('grab_taxi_options_theme_setup2')) {
	add_action( 'after_setup_theme', 'grab_taxi_options_theme_setup2', 2 );
	function grab_taxi_options_theme_setup2() {
		grab_taxi_options_create();
	}
}

// Step 1: Load default settings and previously saved mods
if (!function_exists('grab_taxi_options_theme_setup5')) {
	add_action( 'after_setup_theme', 'grab_taxi_options_theme_setup5', 5 );
	function grab_taxi_options_theme_setup5() {
		grab_taxi_storage_set('options_reloaded', false);
		grab_taxi_load_theme_options();
	}
}

// Step 2: Load current theme customization mods
if (is_customize_preview()) {
	if (!function_exists('grab_taxi_load_custom_options')) {
		add_action( 'wp_loaded', 'grab_taxi_load_custom_options' );
		function grab_taxi_load_custom_options() {
			if (!grab_taxi_storage_get('options_reloaded')) {
				grab_taxi_storage_set('options_reloaded', true);
				grab_taxi_load_theme_options();
			}
		}
	}
}

// Load current values for each customizable option
if ( !function_exists('grab_taxi_load_theme_options') ) {
	function grab_taxi_load_theme_options() {
		$options = grab_taxi_storage_get('options');
		$reset = (int) get_theme_mod('reset_options', 0);
		foreach ($options as $k=>$v) {
			if (isset($v['std'])) {
				if (strpos($v['std'], '$grab_taxi_')!==false) {
					$func = substr($v['std'], 1);
					if (function_exists($func)) {
						$v['std'] = $func($k);
					}
				}
				$value = $v['std'];
				if (!$reset) {
					if (isset($_GET[$k]))
						$value = $_GET[$k];
					else {
						$tmp = get_theme_mod($k, -987654321);
						if ($tmp != -987654321) $value = $tmp;
					}
				}
				grab_taxi_storage_set_array2('options', $k, 'val', $value);
				if ($reset) remove_theme_mod($k);
			}
		}
		if ($reset) {
			// Unset reset flag
			set_theme_mod('reset_options', 0);
			// Regenerate CSS with default colors and fonts
			grab_taxi_customizer_save_css();
		} else {
			do_action('grab_taxi_action_load_options');
		}
	}
}

// Override options with stored page/post meta
if ( !function_exists('grab_taxi_override_theme_options') ) {
	add_action( 'wp', 'grab_taxi_override_theme_options', 1 );
	function grab_taxi_override_theme_options($query=null) {
		if (is_page_template('blog.php')) {
			grab_taxi_storage_set('blog_archive', true);
			grab_taxi_storage_set('blog_template', get_the_ID());
		}
		grab_taxi_storage_set('blog_mode', grab_taxi_detect_blog_mode());
		if (is_singular()) {
			grab_taxi_storage_set('options_meta', get_post_meta(get_the_ID(), 'grab_taxi_options', true));
		}
	}
}


// Return customizable option value
if (!function_exists('grab_taxi_get_theme_option')) {
	function grab_taxi_get_theme_option($name, $defa='', $strict_mode=false, $post_id=0) {
		$rez = $defa;
		$from_post_meta = false;
		if ($post_id > 0) {
			if (!grab_taxi_storage_isset('post_options_meta', $post_id))
				grab_taxi_storage_set_array('post_options_meta', $post_id, get_post_meta($post_id, 'grab_taxi_options', true));
			if (grab_taxi_storage_isset('post_options_meta', $post_id, $name)) {
				$tmp = grab_taxi_storage_get_array('post_options_meta', $post_id, $name);
				if (!grab_taxi_is_inherit($tmp)) {
					$rez = $tmp;
					$from_post_meta = true;
				}
			}
		}
		if (!$from_post_meta && grab_taxi_storage_isset('options')) {
			$blog_mode = grab_taxi_storage_get('blog_mode');
			if ( !grab_taxi_storage_isset('options', $name) && (empty($blog_mode) || !grab_taxi_storage_isset('options', $name.'_'.$blog_mode)) ) {
				$rez = $tmp = '_not_exists_';
				if (function_exists('trx_addons_get_option'))
					$rez = trx_addons_get_option($name, $tmp, false);
				if ($rez === $tmp) {
					if ($strict_mode) {
						$s = debug_backtrace();
						$s = array_shift($s);
						echo '<pre>' . sprintf(esc_html__('Undefined option "%s" called from:', 'grab-taxi'), $name);
						if (function_exists('dco')) dco($s);
						else print_r($s);
						echo '</pre>';
                        wp_die();
					} else
						$rez = $defa;
				}
			} else {
				// Override option from GET or POST for current blog mode
				if (!empty($blog_mode) && isset($_REQUEST[$name . '_' . $blog_mode])) {
					$rez = wp_kses_data( wp_unslash( $_REQUEST[ $name . '_' . $blog_mode ] ) );
				// Override option from GET
				} else if (isset($_REQUEST[$name])) {
					$rez = wp_kses_data( wp_unslash( $_REQUEST[ $name ] ) );
				// Override option from current page settings (if exists)
				} else if (grab_taxi_storage_isset('options_meta', $name) && !grab_taxi_is_inherit(grab_taxi_storage_get_array('options_meta', $name))) {
					$rez = grab_taxi_storage_get_array('options_meta', $name);
				// Override option from current blog mode settings: 'home', 'search', 'page', 'post', 'blog', etc. (if exists)
				} else if (!empty($blog_mode) && grab_taxi_storage_isset('options', $name . '_' . $blog_mode, 'val') && !grab_taxi_is_inherit(grab_taxi_storage_get_array('options', $name . '_' . $blog_mode, 'val'))) {
					$rez = grab_taxi_storage_get_array('options', $name . '_' . $blog_mode, 'val');
				// Get saved option value
				} else if (grab_taxi_storage_isset('options', $name, 'val')) {
					$rez = grab_taxi_storage_get_array('options', $name, 'val');
				// Get ThemeREX Addons option value
				} else if (function_exists('trx_addons_get_option')) {
					$rez = trx_addons_get_option($name, $defa, false);
				}
			}
		}
		return $rez;
	}
}


// Check if customizable option exists
if (!function_exists('grab_taxi_check_theme_option')) {
	function grab_taxi_check_theme_option($name) {
		return grab_taxi_storage_isset('options', $name);
	}
}


// Get dependencies list from the Theme Options
if ( !function_exists('grab_taxi_get_theme_dependencies') ) {
	function grab_taxi_get_theme_dependencies() {
		$options = grab_taxi_storage_get('options');
		$depends = array();
		foreach ($options as $k=>$v) {
			if (isset($v['dependency'])) 
				$depends[$k] = $v['dependency'];
		}
		return $depends;
	}
}

// Return internal theme setting value
if (!function_exists('grab_taxi_get_theme_setting')) {
	function grab_taxi_get_theme_setting($name) {
		if ( !grab_taxi_storage_isset('settings', $name) ) {
			$s = debug_backtrace();
			$s = array_shift($s);
			echo '<pre>' . sprintf(esc_html__('Undefined setting "%s" called from:', 'grab-taxi'), $name);
			if (function_exists('dco')) dco($s);
			else print_r($s);
			echo '</pre>';
            wp_die();
		} else
			return grab_taxi_storage_get_array('settings', $name);
	}
}

// Set theme setting
if ( !function_exists( 'grab_taxi_set_theme_setting' ) ) {
	function grab_taxi_set_theme_setting($option_name, $value) {
		if (grab_taxi_storage_isset('settings', $option_name))
			grab_taxi_storage_set_array('settings', $option_name, $value);
	}
}
?>