<?php
/**
 * The template to display posts in widgets and/or in the search results
 *
 * @package WordPress
 * @subpackage GRAB_TAXI
 * @since GRAB_TAXI 1.0
 */

$grab_taxi_post_id    = get_the_ID();
$grab_taxi_post_date  = grab_taxi_get_date();
$grab_taxi_post_title = get_the_title();
$grab_taxi_post_link  = get_permalink();
$grab_taxi_post_author_id   = get_the_author_meta('ID');
$grab_taxi_post_author_name = get_the_author_meta('display_name');
$grab_taxi_post_author_url  = get_author_posts_url($grab_taxi_post_author_id, '');

$grab_taxi_args = get_query_var('grab_taxi_args_widgets_posts');
$grab_taxi_show_date = isset($grab_taxi_args['show_date']) ? (int) $grab_taxi_args['show_date'] : 1;
$grab_taxi_show_image = isset($grab_taxi_args['show_image']) ? (int) $grab_taxi_args['show_image'] : 1;
$grab_taxi_show_author = isset($grab_taxi_args['show_author']) ? (int) $grab_taxi_args['show_author'] : 1;
$grab_taxi_show_counters = isset($grab_taxi_args['show_counters']) ? (int) $grab_taxi_args['show_counters'] : 1;
$grab_taxi_show_categories = isset($grab_taxi_args['show_categories']) ? (int) $grab_taxi_args['show_categories'] : 1;

$grab_taxi_output = grab_taxi_storage_get('grab_taxi_output_widgets_posts');

$grab_taxi_post_counters_output = '';
if ( $grab_taxi_show_counters ) {
	$grab_taxi_post_counters_output = '<span class="post_info_item post_info_counters">'
								. grab_taxi_get_post_counters('comments')
							. '</span>';
}


$grab_taxi_output .= '<article class="post_item with_thumb">';

if ($grab_taxi_show_image) {
	$grab_taxi_post_thumb = get_the_post_thumbnail($grab_taxi_post_id, grab_taxi_get_thumb_size('tiny'), array(
		'alt' => the_title_attribute(array( 'echo' => false ))
	));
	if ($grab_taxi_post_thumb) $grab_taxi_output .= '<div class="post_thumb">' . ($grab_taxi_post_link ? '<a href="' . esc_url($grab_taxi_post_link) . '">' : '') . ($grab_taxi_post_thumb) . ($grab_taxi_post_link ? '</a>' : '') . '</div>';
}

$grab_taxi_output .= '<div class="post_content">'
			. ($grab_taxi_show_categories 
					? '<div class="post_categories">'
						. grab_taxi_get_post_categories()
						. $grab_taxi_post_counters_output
						. '</div>' 
					: '')
			. '<h6 class="post_title">' . ($grab_taxi_post_link ? '<a href="' . esc_url($grab_taxi_post_link) . '">' : '') . ($grab_taxi_post_title) . ($grab_taxi_post_link ? '</a>' : '') . '</h6>'
			. apply_filters('grab_taxi_filter_get_post_info', 
								'<div class="post_info">'
									. ($grab_taxi_show_date 
										? '<span class="post_info_item post_info_posted">'
											. ($grab_taxi_post_link ? '<a href="' . esc_url($grab_taxi_post_link) . '" class="post_info_date">' : '') 
											. esc_html($grab_taxi_post_date) 
											. ($grab_taxi_post_link ? '</a>' : '')
											. '</span>'
										: '')
									. ($grab_taxi_show_author 
										? '<span class="post_info_item post_info_posted_by">' 
											. esc_html__('by', 'grab-taxi') . ' ' 
											. ($grab_taxi_post_link ? '<a href="' . esc_url($grab_taxi_post_author_url) . '" class="post_info_author">' : '') 
											. esc_html($grab_taxi_post_author_name) 
											. ($grab_taxi_post_link ? '</a>' : '') 
											. '</span>'
										: '')
									. (!$grab_taxi_show_categories && $grab_taxi_post_counters_output
										? $grab_taxi_post_counters_output
										: '')
								. '</div>')
		. '</div>'
	. '</article>';
grab_taxi_storage_set('grab_taxi_output_widgets_posts', $grab_taxi_output);
?>