<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package WordPress
 * @subpackage GRAB_TAXI
 * @since GRAB_TAXI 1.0
 */

// Page (category, tag, archive, author) title

if ( grab_taxi_need_page_title() ) {
	grab_taxi_sc_layouts_showed('title', true);
	grab_taxi_sc_layouts_showed('postmeta', true);
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php
						// Post meta on the single post
						if ( is_single() )  {
							?><div class="sc_layouts_title_meta"><?php
								grab_taxi_show_post_meta(apply_filters('grab_taxi_filter_post_meta_args', array(
									'components' => 'date', /*categories,counters,edit*/
									'counters' => '',
									'seo' => true
									), 'header', 1)
								);
							?></div><?php
						}
						
						// Blog/Post title
						?><div class="sc_layouts_title_title"><?php
							$grab_taxi_blog_title = grab_taxi_get_blog_title();
							$grab_taxi_blog_title_text = $grab_taxi_blog_title_class = $grab_taxi_blog_title_link = $grab_taxi_blog_title_link_text = '';
							if (is_array($grab_taxi_blog_title)) {
								$grab_taxi_blog_title_text = $grab_taxi_blog_title['text'];
								$grab_taxi_blog_title_class = !empty($grab_taxi_blog_title['class']) ? ' '.$grab_taxi_blog_title['class'] : '';
								$grab_taxi_blog_title_link = !empty($grab_taxi_blog_title['link']) ? $grab_taxi_blog_title['link'] : '';
								$grab_taxi_blog_title_link_text = !empty($grab_taxi_blog_title['link_text']) ? $grab_taxi_blog_title['link_text'] : '';
							} else
								$grab_taxi_blog_title_text = $grab_taxi_blog_title;
							?>
							<h1 class="sc_layouts_title_caption<?php echo esc_attr($grab_taxi_blog_title_class); ?>"><?php
								$grab_taxi_top_icon = grab_taxi_get_category_icon();
								if (!empty($grab_taxi_top_icon)) {
									$grab_taxi_attr = grab_taxi_getimagesize($grab_taxi_top_icon);
									?><img src="<?php echo esc_url($grab_taxi_top_icon); ?>" alt="<?php esc_attr__('Image', 'grab-taxi')?>" <?php if (!empty($grab_taxi_attr[3])) grab_taxi_show_layout($grab_taxi_attr[3]);?>><?php
								}
								echo wp_kses_post($grab_taxi_blog_title_text);
							?></h1>
							<?php
							if (!empty($grab_taxi_blog_title_link) && !empty($grab_taxi_blog_title_link_text)) {
								?><a href="<?php echo esc_url($grab_taxi_blog_title_link); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html($grab_taxi_blog_title_link_text); ?></a><?php
							}
							
							// Category/Tag description
							if ( is_category() || is_tag() || is_tax() ) 
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
		
						?></div><?php
	
							// Post meta on the single post
						if ( is_single() )  {
							?><div class="sc_layouts_title_meta"><?php
								grab_taxi_show_post_meta(apply_filters('grab_taxi_filter_post_meta_args', array(
									'components' => 'edit', /*categories,counters,date*/
									'counters' => '',
									'seo' => true
									), 'header', 1)
								);
							?></div><?php
						}
						
						// Breadcrumbs
						?><div class="sc_layouts_title_breadcrumbs"><?php
							do_action( 'grab_taxi_action_breadcrumbs');
						?></div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
?>